/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.core.activity.response.transform.xml.ContentsXMLReader;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

public class XmlTransformResponse
extends TransformResponse {
    private static final String OUTPUT_METHOD_XML = "xml";
    private static final String INDENT_NUMBER_KEY = "indent-number";
    private static final Integer INDENT_NUMBER_VAL = 2;
    private static final String YES = "yes";
    private static final Log log = LogFactory.getLog(XmlTransformResponse.class);
    private final String encoding;
    private final String contentType;
    private final boolean pretty;

    public XmlTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.encoding = transformRule.getEncoding();
        this.contentType = transformRule.getContentType();
        this.pretty = transformRule.isPretty();
    }

    @Override
    public void commit(Activity activity) throws TransformResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.transformRule);
        }
        try {
            String encoding = this.encoding != null ? this.encoding : activity.getTranslet().getResponseEncoding();
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            ProcessResult processResult = activity.getProcessResult();
            Writer writer = responseAdapter.getWriter();
            XmlTransformResponse.transformXml(processResult, writer, encoding, this.pretty);
        }
        catch (Exception e) {
            throw new TransformResponseException(this.transformRule, (Throwable)e);
        }
    }

    @Override
    public ActionList getActionList() {
        return this.transformRule.getActionList();
    }

    @Override
    public Response replicate() {
        return new XmlTransformResponse(this.getTransformRule().replicate());
    }

    public static void transformXml(ProcessResult processResult, Writer writer, String encoding, boolean pretty) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (pretty) {
            transformerFactory.setAttribute(INDENT_NUMBER_KEY, INDENT_NUMBER_VAL);
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", OUTPUT_METHOD_XML);
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        if (pretty) {
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty("doctype-public", YES);
        }
        ContentsXMLReader xreader = new ContentsXMLReader();
        ContentsInputSource isource = new ContentsInputSource(processResult);
        transformer.transform(new SAXSource(xreader, isource), new StreamResult(writer));
    }
}

