/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform.json;

import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.util.json.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class ContentsJsonWriter
extends JsonWriter {
    public ContentsJsonWriter(Writer writer) {
        this(writer, false);
    }

    public ContentsJsonWriter(Writer writer, boolean prettyPrint) {
        super(writer, prettyPrint);
    }

    public ContentsJsonWriter(Writer writer, String indentString) {
        super(writer, indentString);
    }

    @Override
    public ContentsJsonWriter write(Object object) throws IOException {
        if (object instanceof ProcessResult) {
            this.write((ProcessResult)object);
        } else {
            super.write(object);
        }
        return this;
    }

    private void write(ProcessResult processResult) throws IOException {
        if (processResult.getName() != null) {
            this.openCurlyBracket();
            this.writeName(processResult.getName());
        }
        if (processResult.isEmpty()) {
            this.writeNull();
        } else if (processResult.size() == 1) {
            ContentResult contentResult = (ContentResult)processResult.get(0);
            this.write(contentResult);
        } else {
            this.openSquareBracket();
            Iterator it = processResult.iterator();
            while (it.hasNext()) {
                ContentResult contentResult = (ContentResult)it.next();
                this.write(contentResult);
                if (!it.hasNext()) continue;
                this.writeComma();
            }
            this.closeSquareBracket();
        }
        if (processResult.getName() != null) {
            this.closeCurlyBracket();
        }
    }

    private void write(ContentResult contentResult) throws IOException {
        if (contentResult.getName() != null) {
            this.openCurlyBracket();
            this.writeName(contentResult.getName());
        }
        if (contentResult.isEmpty()) {
            this.writeNull();
        } else if (contentResult.size() == 1) {
            ActionResult actionResult = (ActionResult)contentResult.get(0);
            if (actionResult.getActionId() != null) {
                this.openCurlyBracket();
                this.writeName(actionResult.getActionId());
                this.write(actionResult.getResultValue());
                this.closeCurlyBracket();
            } else {
                this.write(actionResult.getResultValue());
            }
        } else {
            this.openCurlyBracket();
            int cnt = 0;
            for (String actionId : contentResult.getActionIds()) {
                if (cnt++ > 0) {
                    this.writeComma();
                }
                ActionResult actionResult = contentResult.getActionResult(actionId);
                this.writeName(actionResult.getActionId());
                this.write(actionResult.getResultValue());
            }
            this.closeCurlyBracket();
        }
        if (contentResult.getName() != null) {
            this.closeCurlyBracket();
        }
    }
}

