/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform.xml;

import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.Parameters;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ContentsXMLReader
implements XMLReader {
    private static final String CONTENTS_TAG = "contents";
    private static final String CONTENT_TAG = "content";
    private static final String ROWS_TAG = "rows";
    private static final String ROW_TAG = "row";
    private static final String EMPTY_TAG = "empty";
    private static final Attributes NULL_ATTRS = new AttributesImpl();
    private ContentHandler handler;

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorhandler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String s) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver entityresolver) {
    }

    @Override
    public void setDTDHandler(DTDHandler dtdhandler) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String s, Object obj) {
    }

    @Override
    public void setFeature(String s, boolean flag) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void parse(InputSource is) throws SAXException {
        if (this.handler == null) {
            throw new SAXException("No XML ContentHandler");
        }
        ContentsInputSource cis = (ContentsInputSource)is;
        ProcessResult processResult = cis.getProcessResult();
        this.handler.startDocument();
        if (processResult != null && !processResult.isEmpty()) {
            this.output(processResult);
        } else {
            this.handler.startElement("", EMPTY_TAG, EMPTY_TAG, NULL_ATTRS);
            this.handler.endElement("", EMPTY_TAG, EMPTY_TAG);
        }
        this.handler.endDocument();
    }

    private void output(ProcessResult processResult) throws SAXException {
        String contentsName = processResult.getName();
        if (processResult.isExplicit()) {
            if (contentsName != null) {
                this.handler.startElement("", contentsName, contentsName, NULL_ATTRS);
            } else {
                this.handler.startElement("", CONTENTS_TAG, CONTENTS_TAG, NULL_ATTRS);
            }
        }
        for (ContentResult contentResult : processResult) {
            String contentName = contentResult.getName();
            if (contentResult.isExplicit()) {
                if (contentName != null) {
                    this.handler.startElement("", contentName, contentName, NULL_ATTRS);
                } else {
                    this.handler.startElement("", CONTENT_TAG, CONTENT_TAG, NULL_ATTRS);
                }
            }
            for (ActionResult actionResult : contentResult) {
                String actionId = actionResult.getActionId();
                Object resultValue = actionResult.getResultValue();
                if (actionId != null) {
                    this.handler.startElement("", actionId, actionId, NULL_ATTRS);
                }
                this.output(resultValue);
                if (actionId == null) continue;
                this.handler.endElement("", actionId, actionId);
            }
            if (!contentResult.isExplicit()) continue;
            if (contentResult.getName() != null) {
                this.handler.endElement("", contentName, contentName);
                continue;
            }
            this.handler.endElement("", CONTENT_TAG, CONTENT_TAG);
        }
        if (processResult.isExplicit()) {
            if (contentsName != null) {
                this.handler.endElement("", contentsName, contentsName);
            } else {
                this.handler.endElement("", CONTENTS_TAG, CONTENTS_TAG);
            }
        }
    }

    private void output(Object object) throws SAXException {
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    if (object == null) {
                                        return;
                                    }
                                    if (!(object instanceof ProcessResult)) break block8;
                                    this.output((ProcessResult)object);
                                    break block9;
                                }
                                if (!(object instanceof String) && !(object instanceof Number) && !(object instanceof Boolean) && !(object instanceof Date)) break block10;
                                this.outputString(object.toString());
                                break block9;
                            }
                            if (!(object instanceof Parameters)) break block11;
                            Map<String, ParameterValue> params = ((Parameters)object).getParameterValueMap();
                            for (Parameter parameter : params.values()) {
                                String name = parameter.getName();
                                Object value = parameter.getValue();
                                this.checkCircularReference(object, value);
                                this.handler.startElement("", name, name, NULL_ATTRS);
                                this.output(value);
                                this.handler.endElement("", name, name);
                            }
                            break block9;
                        }
                        if (!(object instanceof Map)) break block12;
                        for (Map.Entry entry : ((Map)object).entrySet()) {
                            String string = entry.getKey().toString();
                            Object value = entry.getValue();
                            this.checkCircularReference(object, value);
                            this.handler.startElement("", string, string, NULL_ATTRS);
                            this.output(value);
                            this.handler.endElement("", string, string);
                        }
                        break block9;
                    }
                    if (!(object instanceof Collection)) break block13;
                    this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                    for (Object value : (Collection)object) {
                        this.checkCircularReference(object, value);
                        this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                        this.output(value);
                        this.handler.endElement("", ROW_TAG, ROW_TAG);
                    }
                    this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                    break block9;
                }
                if (!object.getClass().isArray()) break block14;
                this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                int len = Array.getLength(object);
                for (int i = 0; i < len; ++i) {
                    Object object2 = Array.get(object, i);
                    this.checkCircularReference(object, object2);
                    this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                    this.output(object2);
                    this.handler.endElement("", ROW_TAG, ROW_TAG);
                }
                this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                break block9;
            }
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames == null || readablePropertyNames.length <= 0) break block9;
            for (String name : readablePropertyNames) {
                Object value;
                try {
                    value = BeanUtils.getProperty(object, name);
                }
                catch (InvocationTargetException e) {
                    throw new SAXException(e);
                }
                this.checkCircularReference(object, value);
                this.handler.startElement("", name, name, NULL_ATTRS);
                this.output(value);
                this.handler.endElement("", name, name);
            }
        }
    }

    private void outputString(String s) throws SAXException {
        this.handler.characters(s.toCharArray(), 0, s.length());
    }

    private void checkCircularReference(Object wrapper, Object member) throws SAXException {
        if (wrapper.equals(member)) {
            throw new SAXException("XML Serialization Failure: A circular reference was detected while converting a member object [" + member + "] in [" + wrapper + "]");
        }
    }
}

