/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component;

import com.aspectran.core.component.Component;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;

public abstract class AbstractComponent
implements Component {
    private static final Log log = LogFactory.getLog(AbstractComponent.class);
    private final Object lock = new Object();
    private volatile boolean initialized;
    private volatile boolean destroyed;

    protected abstract void doInitialize() throws Exception;

    protected abstract void doDestroy() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            if (this.initialized) {
                throw new IllegalStateException("Already initialized " + this.getComponentName());
            }
            this.doInitialize();
            log.info("Initialized " + this.getComponentName());
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                throw new IllegalStateException("Not yet initialized " + this.getComponentName());
            }
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            try {
                this.doDestroy();
                log.info("Destroyed " + this.getComponentName());
            }
            catch (Exception e) {
                log.warn("Failed to destroy " + this.getComponentName(), e);
            }
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.lock;
        synchronized (object) {
            return this.initialized && !this.destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    @Override
    public String getComponentName() {
        return this.getClass().getSimpleName() + '@' + Integer.toString(this.hashCode(), 16);
    }
}

