/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect;

import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.util.BeanDescriptor;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.List;
import java.util.Set;

public class AspectAdviceRulePreRegister {
    private static final Log log = LogFactory.getLog(AspectAdviceRulePreRegister.class);
    private AspectRuleRegistry aspectRuleRegistry;

    public AspectAdviceRulePreRegister(AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
        for (AspectRule aspectRule : aspectRuleRegistry.getAspectRules()) {
            JoinpointTargetType joinpointTargetType = aspectRule.getJoinpointTargetType();
            if (joinpointTargetType == JoinpointTargetType.METHOD) {
                aspectRule.setBeanRelevant(true);
            } else if (joinpointTargetType == JoinpointTargetType.SESSION) {
                aspectRule.setBeanRelevant(false);
            } else {
                Pointcut pointcut = aspectRule.getPointcut();
                if (pointcut == null) {
                    aspectRule.setBeanRelevant(false);
                } else {
                    List<PointcutPatternRule> pointcutPatternRuleList = pointcut.getPointcutPatternRuleList();
                    boolean beanRelevant = false;
                    for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                        if (ppr.getBeanIdPattern() == null && ppr.getClassNamePattern() == null && ppr.getMethodNamePattern() == null) continue;
                        beanRelevant = true;
                        break;
                    }
                    aspectRule.setBeanRelevant(beanRelevant);
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("preregistered AspectRule " + aspectRule);
        }
    }

    public void register(BeanRuleRegistry beanRuleRegistry) {
        for (BeanRule beanRule : beanRuleRegistry.getConfigurableBeanRules()) {
            if (!beanRule.isProxiable()) continue;
            this.determineProxyBean(beanRule);
        }
        for (BeanRule beanRule : beanRuleRegistry.getIdBasedBeanRules()) {
            if (!beanRule.isProxiable()) continue;
            this.determineProxyBean(beanRule);
        }
        for (Set set : beanRuleRegistry.getTypeBasedBeanRules()) {
            for (BeanRule beanRule : set) {
                if (!beanRule.isProxiable()) continue;
                this.determineProxyBean(beanRule);
            }
        }
    }

    private void determineProxyBean(BeanRule beanRule) {
        for (AspectRule aspectRule : this.aspectRuleRegistry.getAspectRules()) {
            if (!aspectRule.isBeanRelevant()) continue;
            Pointcut pointcut = aspectRule.getPointcut();
            if (pointcut != null) {
                if (pointcut.hasBeanMethodNamePattern()) {
                    if (!this.existsMatchedBean(pointcut, beanRule)) continue;
                    beanRule.setProxied(true);
                    if (!log.isTraceEnabled()) break;
                    log.trace("apply AspectRule " + aspectRule + " to BeanRule " + beanRule);
                    break;
                }
                if (!this.existsMatchedBean(pointcut, beanRule.getId(), beanRule.getTargetBeanClassName())) continue;
                beanRule.setProxied(true);
                if (!log.isTraceEnabled()) break;
                log.trace("apply AspectRule " + aspectRule + " to BeanRule " + beanRule);
                break;
            }
            Class<?> beanClass = beanRule.getTargetBeanClass();
            if (beanClass.isAnnotationPresent(AvoidAdvice.class)) continue;
            beanRule.setProxied(true);
            if (!log.isTraceEnabled()) break;
            log.trace("apply AspectRule " + aspectRule + " to BeanRule " + beanRule);
            break;
        }
    }

    public void register(TransletRuleRegistry transletRuleRegistry) {
        for (TransletRule transletRule : transletRuleRegistry.getTransletRules()) {
            if (transletRule.hasPathVariables()) continue;
            this.register(transletRule);
        }
    }

    private void register(TransletRule transletRule) {
        for (AspectRule aspectRule : this.aspectRuleRegistry.getAspectRules()) {
            JoinpointTargetType joinpointTargetType = aspectRule.getJoinpointTargetType();
            Pointcut pointcut = aspectRule.getPointcut();
            if (aspectRule.isBeanRelevant() || joinpointTargetType == JoinpointTargetType.SESSION || pointcut != null && !pointcut.matches(transletRule.getName())) continue;
            transletRule.touchAspectAdviceRuleRegistry().register(aspectRule);
            if (!log.isTraceEnabled()) continue;
            log.trace("apply AspectRule " + aspectRule + " to TransletRule " + transletRule);
        }
    }

    private boolean existsMatchedBean(Pointcut pointcut, String beanId, String className) {
        List<PointcutPatternRule> pointcutPatternRuleList = pointcut.getPointcutPatternRuleList();
        if (pointcutPatternRuleList != null) {
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                if (!this.existsBean(pointcut, ppr, beanId, className, null)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsMatchedBean(Pointcut pointcut, BeanRule beanRule) {
        List<PointcutPatternRule> pointcutPatternRuleList = pointcut.getPointcutPatternRuleList();
        if (pointcutPatternRuleList != null) {
            BeanDescriptor bd = BeanDescriptor.getInstance(beanRule.getTargetBeanClass());
            String beanId = beanRule.getId();
            String className = beanRule.getTargetBeanClassName();
            String[] methodNames = bd.getDistinctMethodNames();
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                if (!this.existsBean(pointcut, ppr, beanId, className, methodNames)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsBean(Pointcut pointcut, PointcutPatternRule pointcutPatternRule, String beanId, String className, String[] methodNames) {
        boolean matched = true;
        if (beanId != null && pointcutPatternRule.getBeanIdPattern() != null && (matched = pointcut.patternMatches(pointcutPatternRule.getBeanIdPattern(), beanId, '.'))) {
            pointcutPatternRule.increaseMatchedBeanCount();
        }
        if (matched && className != null && pointcutPatternRule.getClassNamePattern() != null && (matched = pointcut.patternMatches(pointcutPatternRule.getClassNamePattern(), className, '.'))) {
            pointcutPatternRule.increaseMatchedClassCount();
        }
        if (matched && methodNames != null && pointcutPatternRule.getMethodNamePattern() != null) {
            matched = false;
            for (String methodName : methodNames) {
                boolean matched2 = pointcut.patternMatches(pointcutPatternRule.getMethodNamePattern(), methodName);
                if (!matched2) continue;
                matched = true;
                pointcutPatternRule.increaseMatchedMethodCount();
            }
        }
        return matched;
    }
}

