/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect;

import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AspectAdviceRuleRegistry
implements Replicable<AspectAdviceRuleRegistry> {
    private Map<String, Object> settings;
    private List<SettingsAdviceRule> settingsAdviceRuleList;
    private List<AspectAdviceRule> beforeAdviceRuleList;
    private List<AspectAdviceRule> afterAdviceRuleList;
    private List<AspectAdviceRule> finallyAdviceRuleList;
    private List<ExceptionRule> exceptionRuleList;

    public void register(AspectRule aspectRule) {
        if (aspectRule != null) {
            if (aspectRule.getSettingsAdviceRule() != null) {
                this.addAspectAdviceRule(aspectRule.getSettingsAdviceRule());
            }
            if (aspectRule.getAspectAdviceRuleList() != null) {
                for (AspectAdviceRule aspectAdviceRule : aspectRule.getAspectAdviceRuleList()) {
                    this.addAspectAdviceRule(aspectAdviceRule);
                }
            }
            if (aspectRule.getExceptionRule() != null) {
                this.addExceptionRule(aspectRule.getExceptionRule());
            }
        }
    }

    public void merge(AspectAdviceRuleRegistry aarr) {
        if (aarr.getSettingsAdviceRuleList() != null) {
            for (SettingsAdviceRule sar : aarr.getSettingsAdviceRuleList()) {
                this.addAspectAdviceRule(sar);
            }
        }
        if (aarr.getBeforeAdviceRuleList() != null) {
            for (AspectAdviceRule aar : aarr.getBeforeAdviceRuleList()) {
                this.addBeforeAdviceRule(aar);
            }
        }
        if (aarr.getAfterAdviceRuleList() != null) {
            for (AspectAdviceRule aar : aarr.getAfterAdviceRuleList()) {
                this.addAfterAdviceRule(aar);
            }
        }
        if (aarr.getFinallyAdviceRuleList() != null) {
            for (AspectAdviceRule aar : aarr.getFinallyAdviceRuleList()) {
                this.addFinallyAdviceRule(aar);
            }
        }
        if (aarr.getExceptionRuleList() != null) {
            for (ExceptionRule er : aarr.getExceptionRuleList()) {
                this.addExceptionRule(er);
            }
        }
    }

    @Override
    public AspectAdviceRuleRegistry replicate() {
        AspectAdviceRuleRegistry aarr = new AspectAdviceRuleRegistry();
        if (this.settingsAdviceRuleList != null) {
            aarr.setSettingsAdviceRuleList(new ArrayList<SettingsAdviceRule>(this.settingsAdviceRuleList));
        }
        if (this.beforeAdviceRuleList != null) {
            aarr.setBeforeAdviceRuleList(new LinkedList<AspectAdviceRule>(this.beforeAdviceRuleList));
        }
        if (this.afterAdviceRuleList != null) {
            aarr.setAfterAdviceRuleList(new LinkedList<AspectAdviceRule>(this.afterAdviceRuleList));
        }
        if (this.finallyAdviceRuleList != null) {
            aarr.setFinallyAdviceRuleList(new LinkedList<AspectAdviceRule>(this.finallyAdviceRuleList));
        }
        if (this.exceptionRuleList != null) {
            aarr.setExceptionRuleList(new LinkedList<ExceptionRule>(this.exceptionRuleList));
        }
        return aarr;
    }

    public <T> T getSetting(String settingName) {
        return (T)(this.settings != null ? this.settings.get(settingName) : null);
    }

    private void addSettings(Map<String, Object> settings) {
        if (settings != null) {
            if (this.settings == null) {
                this.settings = new HashMap<String, Object>(settings);
            } else {
                this.settings.putAll(settings);
            }
        }
    }

    public List<SettingsAdviceRule> getSettingsAdviceRuleList() {
        return this.settingsAdviceRuleList;
    }

    private void setSettingsAdviceRuleList(List<SettingsAdviceRule> settingsAdviceRuleList) {
        this.settingsAdviceRuleList = settingsAdviceRuleList;
        for (SettingsAdviceRule settingsAdviceRule : settingsAdviceRuleList) {
            this.addSettings(settingsAdviceRule.getSettings());
        }
    }

    public List<AspectAdviceRule> getBeforeAdviceRuleList() {
        return this.beforeAdviceRuleList;
    }

    private void setBeforeAdviceRuleList(List<AspectAdviceRule> beforeAdviceRuleList) {
        this.beforeAdviceRuleList = beforeAdviceRuleList;
    }

    public List<AspectAdviceRule> getAfterAdviceRuleList() {
        return this.afterAdviceRuleList;
    }

    private void setAfterAdviceRuleList(List<AspectAdviceRule> afterAdviceRuleList) {
        this.afterAdviceRuleList = afterAdviceRuleList;
    }

    public List<AspectAdviceRule> getFinallyAdviceRuleList() {
        return this.finallyAdviceRuleList;
    }

    private void setFinallyAdviceRuleList(List<AspectAdviceRule> finallyAdviceRuleList) {
        this.finallyAdviceRuleList = finallyAdviceRuleList;
    }

    public void addAspectAdviceRule(SettingsAdviceRule settingsAdviceRule) {
        if (this.settingsAdviceRuleList == null) {
            this.settingsAdviceRuleList = new ArrayList<SettingsAdviceRule>();
        }
        this.settingsAdviceRuleList.add(settingsAdviceRule);
        this.addSettings(settingsAdviceRule.getSettings());
    }

    public void addAspectAdviceRule(AspectAdviceRule aspectAdviceRule) {
        if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.BEFORE) {
            this.addBeforeAdviceRule(aspectAdviceRule);
        } else if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AFTER) {
            this.addAfterAdviceRule(aspectAdviceRule);
        } else if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AROUND) {
            this.addBeforeAdviceRule(aspectAdviceRule);
            this.addAfterAdviceRule(aspectAdviceRule);
        } else if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.FINALLY) {
            this.addFinallyAdviceRule(aspectAdviceRule);
        }
    }

    private void addBeforeAdviceRule(AspectAdviceRule aspectAdviceRule) {
        if (this.beforeAdviceRuleList == null) {
            this.beforeAdviceRuleList = new LinkedList<AspectAdviceRule>();
            this.beforeAdviceRuleList.add(aspectAdviceRule);
        } else {
            int leftInt = aspectAdviceRule.getAspectRule().getOrder();
            int index = this.findLessThanIndex(this.beforeAdviceRuleList, leftInt);
            this.beforeAdviceRuleList.add(index, aspectAdviceRule);
        }
    }

    private void addAfterAdviceRule(AspectAdviceRule aspectAdviceRule) {
        if (this.afterAdviceRuleList == null) {
            this.afterAdviceRuleList = new LinkedList<AspectAdviceRule>();
            this.afterAdviceRuleList.add(aspectAdviceRule);
        } else {
            int leftInt = aspectAdviceRule.getAspectRule().getOrder();
            int index = this.findGreaterThanOrEqualIndex(this.afterAdviceRuleList, leftInt);
            this.afterAdviceRuleList.add(index, aspectAdviceRule);
        }
    }

    private void addFinallyAdviceRule(AspectAdviceRule aspectAdviceRule) {
        if (this.finallyAdviceRuleList == null) {
            this.finallyAdviceRuleList = new LinkedList<AspectAdviceRule>();
            this.finallyAdviceRuleList.add(aspectAdviceRule);
        } else {
            int leftInt = aspectAdviceRule.getAspectRule().getOrder();
            int index = this.findGreaterThanOrEqualIndex(this.finallyAdviceRuleList, leftInt);
            this.finallyAdviceRuleList.add(index, aspectAdviceRule);
        }
    }

    public List<ExceptionRule> getExceptionRuleList() {
        return this.exceptionRuleList;
    }

    private void setExceptionRuleList(List<ExceptionRule> exceptionRuleList) {
        this.exceptionRuleList = exceptionRuleList;
    }

    private void addExceptionRule(ExceptionRule exceptionRule) {
        if (this.exceptionRuleList == null) {
            this.exceptionRuleList = new LinkedList<ExceptionRule>();
        }
        this.exceptionRuleList.add(0, exceptionRule);
    }

    private int findLessThanIndex(List<AspectAdviceRule> adviceRuleList, int leftInt) {
        for (int i = 0; i < adviceRuleList.size(); ++i) {
            int rightInt = adviceRuleList.get(i).getAspectRule().getOrder();
            if (leftInt >= rightInt) continue;
            return i;
        }
        return adviceRuleList.size();
    }

    private int findGreaterThanOrEqualIndex(List<AspectAdviceRule> adviceRuleList, int leftInt) {
        for (int i = 0; i < adviceRuleList.size(); ++i) {
            int rightInt = adviceRuleList.get(i).getAspectRule().getOrder();
            if (leftInt < rightInt) continue;
            return i;
        }
        return adviceRuleList.size();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(94);
        tsb.append("settings", this.settings);
        tsb.append("beforeAdvices", this.beforeAdviceRuleList);
        tsb.append("afterAdvices", this.afterAdviceRuleList);
        tsb.append("finallyAdvices", this.finallyAdviceRuleList);
        tsb.append("exceptionRules", this.exceptionRuleList);
        return tsb.toString();
    }
}

