/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.context.rule.PointcutPatternRule;
import java.util.List;

public abstract class AbstractPointcut
implements Pointcut {
    private final List<PointcutPatternRule> pointcutPatternRuleList;
    private final boolean existsBeanMethodNamePattern;

    public AbstractPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        this.pointcutPatternRuleList = pointcutPatternRuleList;
        if (pointcutPatternRuleList != null) {
            boolean existsBeanMethodNamePattern = false;
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                if (ppr.getMethodNamePattern() == null) continue;
                existsBeanMethodNamePattern = true;
                break;
            }
            this.existsBeanMethodNamePattern = existsBeanMethodNamePattern;
        } else {
            this.existsBeanMethodNamePattern = false;
        }
    }

    @Override
    public List<PointcutPatternRule> getPointcutPatternRuleList() {
        return this.pointcutPatternRuleList;
    }

    @Override
    public boolean hasBeanMethodNamePattern() {
        return this.existsBeanMethodNamePattern;
    }

    @Override
    public boolean matches(String transletName) {
        return this.matches(transletName, null, null, null);
    }

    @Override
    public boolean matches(String transletName, String beanId, String className) {
        return this.matches(transletName, beanId, className, null);
    }

    @Override
    public boolean matches(String transletName, String beanId, String className, String methodName) {
        if (this.pointcutPatternRuleList != null) {
            for (PointcutPatternRule ppr : this.pointcutPatternRuleList) {
                if (!this.matches(ppr, transletName, beanId, className, methodName)) continue;
                List<PointcutPatternRule> epprList = ppr.getExcludePointcutPatternRuleList();
                if (epprList != null) {
                    for (PointcutPatternRule eppr : epprList) {
                        if (!this.matches(eppr, transletName, beanId, className, methodName)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean matches(PointcutPatternRule pointcutPatternRule, String transletName, String beanId, String className, String methodName) {
        if (transletName == null && pointcutPatternRule.getTransletNamePattern() != null || beanId == null && pointcutPatternRule.getBeanIdPattern() != null || className == null && pointcutPatternRule.getClassNamePattern() != null || methodName == null && pointcutPatternRule.getMethodNamePattern() != null) {
            return false;
        }
        return this.exists(pointcutPatternRule, transletName, beanId, className, methodName);
    }

    @Override
    public boolean exists(String transletName) {
        return this.exists(transletName, null, null, null);
    }

    @Override
    public boolean exists(String transletName, String beanId, String className) {
        return this.exists(transletName, beanId, className, null);
    }

    @Override
    public boolean exists(String transletName, String beanId, String className, String methodName) {
        if (this.pointcutPatternRuleList != null) {
            for (PointcutPatternRule ppr : this.pointcutPatternRuleList) {
                if (!this.exists(ppr, transletName, beanId, className, methodName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean exists(PointcutPatternRule pointcutPatternRule, String transletName, String beanId, String className, String methodName) {
        boolean matched = true;
        if (transletName != null && pointcutPatternRule.getTransletNamePattern() != null) {
            matched = this.patternMatches(pointcutPatternRule.getTransletNamePattern(), transletName, '/');
        }
        if (matched && beanId != null && pointcutPatternRule.getBeanIdPattern() != null) {
            matched = this.patternMatches(pointcutPatternRule.getBeanIdPattern(), beanId, '.');
        }
        if (matched && className != null && pointcutPatternRule.getClassNamePattern() != null) {
            matched = this.patternMatches(pointcutPatternRule.getClassNamePattern(), className, '.');
        }
        if (matched && methodName != null && pointcutPatternRule.getMethodNamePattern() != null) {
            matched = this.patternMatches(pointcutPatternRule.getMethodNamePattern(), methodName);
        }
        return matched;
    }
}

