/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.AnnotatedMethodAction;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.bean.BeanCreationException;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.BeanInstantiationException;
import com.aspectran.core.component.bean.BeanNotFoundException;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.FactoryBeanNotInitializedException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.ablility.InitializableTransletBean;
import com.aspectran.core.component.bean.annotation.Component;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.bean.aware.Aware;
import com.aspectran.core.component.bean.aware.ClassLoaderAware;
import com.aspectran.core.component.bean.aware.CurrentActivityAware;
import com.aspectran.core.component.bean.aware.EnvironmentAware;
import com.aspectran.core.component.bean.proxy.CglibDynamicBeanProxy;
import com.aspectran.core.component.bean.proxy.JavassistDynamicBeanProxy;
import com.aspectran.core.component.bean.proxy.JdkDynamicBeanProxy;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.expr.TokenExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.type.AutowireTargetType;
import com.aspectran.core.context.rule.type.BeanProxifierType;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.ReflectionUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBeanFactory
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(AbstractBeanFactory.class);
    private final ActivityContext context;
    private final BeanRuleRegistry beanRuleRegistry;
    private final BeanProxifierType beanProxifierType;

    public AbstractBeanFactory(ActivityContext context, BeanRuleRegistry beanRuleRegistry, BeanProxifierType beanProxifierType) {
        this.context = context;
        this.beanRuleRegistry = beanRuleRegistry;
        this.beanProxifierType = beanProxifierType != null ? beanProxifierType : BeanProxifierType.JAVASSIST;
    }

    protected ActivityContext getContext() {
        return this.context;
    }

    protected BeanRuleRegistry getBeanRuleRegistry() {
        return this.beanRuleRegistry;
    }

    protected Object createBean(BeanRule beanRule) {
        Activity activity = this.context.getCurrentActivity();
        return this.createBean(beanRule, activity);
    }

    protected Object getFactoryProducedObject(BeanRule beanRule, Object bean) {
        if (beanRule.isFactoryBean()) {
            return this.invokeMethodOfFactoryBean(beanRule, bean);
        }
        if (beanRule.getFactoryMethodName() != null) {
            Activity activity = this.context.getCurrentActivity();
            return this.invokeFactoryMethod(beanRule, bean, activity);
        }
        return null;
    }

    private Object createBean(BeanRule beanRule, Activity activity) {
        Object bean = beanRule.isFactoryOffered() ? this.createOfferedFactoryBean(beanRule, activity) : this.createNormalBean(beanRule, activity);
        return bean;
    }

    private Object createNormalBean(BeanRule beanRule, Activity activity) {
        try {
            Class<?>[] argTypes;
            Object[] args;
            ItemExpression evaluator = null;
            ItemRuleMap constructorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
            if (constructorArgumentItemRuleMap != null && !constructorArgumentItemRuleMap.isEmpty()) {
                evaluator = new ItemExpression(activity);
                Map<String, Object> valueMap = evaluator.evaluate(constructorArgumentItemRuleMap);
                args = new Object[constructorArgumentItemRuleMap.size()];
                argTypes = new Class[constructorArgumentItemRuleMap.size()];
                int i = 0;
                for (Map.Entry entry : constructorArgumentItemRuleMap.entrySet()) {
                    Object value;
                    args[i] = value = valueMap.get(entry.getKey());
                    argTypes[i] = ItemRule.getPrototypeClass((ItemRule)entry.getValue(), value);
                    ++i;
                }
            } else {
                AutowireRule ctorAutowireRule = beanRule.getConstructorAutowireRule();
                if (ctorAutowireRule != null) {
                    Class<?>[] types = ctorAutowireRule.getTypes();
                    String[] qualifiers = ctorAutowireRule.getQualifiers();
                    args = new Object[types.length];
                    argTypes = new Class[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        if (ctorAutowireRule.isRequired()) {
                            args[i] = activity.getBean(types[i], qualifiers[i]);
                        } else {
                            try {
                                args[i] = activity.getBean(types[i], qualifiers[i]);
                            }
                            catch (BeanNotFoundException | NoUniqueBeanException e) {
                                args[i] = null;
                                log.warn(e.getMessage());
                            }
                        }
                        argTypes[i] = types[i];
                    }
                } else {
                    args = MethodUtils.EMPTY_OBJECT_ARRAY;
                    argTypes = MethodUtils.EMPTY_CLASS_PARAMETERS;
                }
            }
            Object bean = this.createBeanInstance(beanRule, args, argTypes);
            if (beanRule.isSingleton()) {
                beanRule.setBeanInstance(new BeanInstance(bean));
            }
            this.invokeAwareMethods(bean);
            this.autowiring(beanRule, bean, activity);
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                if (evaluator == null) {
                    evaluator = new ItemExpression(activity);
                }
                Map<String, Object> valueMap = evaluator.evaluate(propertyItemRuleMap);
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    MethodUtils.invokeSetter(bean, entry.getKey(), entry.getValue());
                }
            }
            if (beanRule.isInitializableBean() || beanRule.isInitializableTransletBean()) {
                this.initializeBean(beanRule, bean, activity);
            } else if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object createOfferedFactoryBean(BeanRule beanRule, Activity activity) {
        Object bean;
        String factoryBeanId = beanRule.getFactoryBeanId();
        Class<?> factoryBeanClass = beanRule.getFactoryBeanClass();
        try {
            bean = factoryBeanClass != null ? (Modifier.isInterface(factoryBeanClass.getModifiers()) ? null : (factoryBeanClass.isAnnotationPresent(Component.class) ? activity.getBeanForConfig(factoryBeanClass) : activity.getBean(factoryBeanClass))) : activity.getBean(factoryBeanId);
            bean = this.invokeFactoryMethod(beanRule, bean, activity);
            if (bean == null) {
                throw new NullPointerException("Factory Method [" + beanRule.getFactoryMethod() + "] has returned null");
            }
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while invoking a factory method from the offered factory bean", beanRule, e);
        }
        if (beanRule.isSingleton()) {
            beanRule.setBeanInstance(new BeanInstance(bean));
        }
        try {
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                ItemExpression evaluator = new ItemExpression(activity);
                Map<String, Object> valueMap = evaluator.evaluate(propertyItemRuleMap);
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    MethodUtils.invokeSetter(bean, entry.getKey(), entry.getValue());
                }
            }
            if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object createBeanInstance(BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean = beanRule.isProxied() ? this.createDynamicBeanProxy(beanRule, args, argTypes) : (args != null ? AbstractBeanFactory.newInstance(beanRule.getBeanClass(), args, argTypes) : AbstractBeanFactory.newInstance(beanRule.getBeanClass()));
        return bean;
    }

    private Object createDynamicBeanProxy(BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean;
        if (this.beanProxifierType == BeanProxifierType.JAVASSIST) {
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using Javassist");
            }
            bean = JavassistDynamicBeanProxy.newInstance(this.context, beanRule, args, argTypes);
        } else if (this.beanProxifierType == BeanProxifierType.CGLIB) {
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using CGLIB");
            }
            bean = CglibDynamicBeanProxy.newInstance(this.context, beanRule, args, argTypes);
        } else {
            bean = argTypes != null && args != null ? AbstractBeanFactory.newInstance(beanRule.getBeanClass(), args, argTypes) : AbstractBeanFactory.newInstance(beanRule.getBeanClass());
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using JDK");
            }
            bean = JdkDynamicBeanProxy.newInstance(this.context, beanRule, bean);
        }
        return bean;
    }

    private void autowiring(BeanRule beanRule, Object bean, Activity activity) {
        if (beanRule.getAutowireRuleList() != null) {
            for (AutowireRule autowireRule : beanRule.getAutowireRuleList()) {
                Object value;
                String[] qualifiers;
                Class<?>[] types;
                Field field;
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD) {
                    field = (Field)autowireRule.getTarget();
                    types = autowireRule.getTypes();
                    qualifiers = autowireRule.getQualifiers();
                    if (autowireRule.isRequired()) {
                        value = activity.getBean(types[0], qualifiers[0]);
                    } else {
                        try {
                            value = activity.getBean(types[0], qualifiers[0]);
                        }
                        catch (BeanNotFoundException | NoUniqueBeanException e) {
                            value = null;
                            log.warn(e.getMessage());
                        }
                    }
                    ReflectionUtils.setField(field, bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD_VALUE) {
                    field = (Field)autowireRule.getTarget();
                    Token token = autowireRule.getToken();
                    TokenExpression evaluator = new TokenExpression(activity);
                    value = evaluator.evaluate(token);
                    ReflectionUtils.setField(field, bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() != AutowireTargetType.METHOD) continue;
                Method method = (Method)autowireRule.getTarget();
                types = autowireRule.getTypes();
                qualifiers = autowireRule.getQualifiers();
                Object[] args = new Object[types.length];
                for (int i = 0; i < types.length; ++i) {
                    if (autowireRule.isRequired()) {
                        args[i] = activity.getBean(types[i], qualifiers[i]);
                        continue;
                    }
                    try {
                        args[i] = activity.getBean(types[i], qualifiers[i]);
                        continue;
                    }
                    catch (BeanNotFoundException | NoUniqueBeanException e) {
                        args[i] = null;
                        log.warn(e.getMessage());
                    }
                }
                ReflectionUtils.invokeMethod(method, bean, args);
            }
        }
    }

    private void invokeAwareMethods(Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof CurrentActivityAware) {
                ((CurrentActivityAware)bean).setCurrentActivity(this.context.getCurrentActivity());
            }
            if (bean instanceof ActivityContextAware) {
                ((ActivityContextAware)bean).setActivityContext(this.context);
            }
            if (bean instanceof ApplicationAdapterAware) {
                ((ApplicationAdapterAware)bean).setApplicationAdapter(this.context.getEnvironment().getApplicationAdapter());
            }
            if (bean instanceof ClassLoaderAware) {
                ((ClassLoaderAware)bean).setClassLoader(this.context.getEnvironment().getClassLoader());
            }
            if (bean instanceof EnvironmentAware) {
                ((EnvironmentAware)bean).setEnvironment(this.context.getEnvironment());
            }
        }
    }

    private void initializeBean(BeanRule beanRule, Object bean, Activity activity) {
        try {
            if (beanRule.isInitializableBean()) {
                ((InitializableBean)bean).initialize();
            } else if (beanRule.isInitializableTransletBean()) {
                ((InitializableTransletBean)bean).initialize(activity.getTranslet());
            }
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while initialization of bean", beanRule, e);
        }
    }

    private void invokeInitMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method initMethod = beanRule.getInitMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getInitMethodParameterBindingRules();
            AnnotatedMethodAction.invokeMethod(activity, bean, initMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing an initialization method of bean", beanRule, e);
        }
    }

    private Object invokeFactoryMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method factoryMethod = beanRule.getFactoryMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getFactoryMethodParameterBindingRules();
            return AnnotatedMethodAction.invokeMethod(activity, bean, factoryMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing a factory method of bean", beanRule, e);
        }
    }

    private Object invokeMethodOfFactoryBean(BeanRule beanRule, Object bean) {
        Object resultBean;
        try {
            resultBean = ((FactoryBean)bean).getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("FactoryBean threw exception on object creation", beanRule, e);
        }
        if (resultBean == null) {
            throw new FactoryBeanNotInitializedException("FactoryBean returned null object: probably not fully initialized (maybe due to circular bean reference)", beanRule);
        }
        return resultBean;
    }

    private void instantiateSingletons() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing singletons in " + this);
        }
        Activity activity = this.context.getDefaultActivity();
        for (BeanRule beanRule : this.beanRuleRegistry.getIdBasedBeanRules()) {
            this.instantiateSingleton(beanRule, activity);
        }
        for (Set set : this.beanRuleRegistry.getTypeBasedBeanRules()) {
            for (BeanRule beanRule : set) {
                this.instantiateSingleton(beanRule, activity);
            }
        }
        for (BeanRule beanRule : this.beanRuleRegistry.getConfigurableBeanRules()) {
            this.instantiateSingleton(beanRule, activity);
        }
    }

    private void instantiateSingleton(BeanRule beanRule, Activity activity) {
        if (beanRule.isSingleton() && beanRule.getBeanInstance() == null && !beanRule.isLazyInit()) {
            this.createBean(beanRule, activity);
        }
    }

    private void destroySingletons() {
        if (log.isDebugEnabled()) {
            log.debug("Destroying singletons in " + this);
        }
        int failedDestroyes = 0;
        for (BeanRule beanRule : this.beanRuleRegistry.getIdBasedBeanRules()) {
            failedDestroyes += this.doDestroySingleton(beanRule);
        }
        for (Set set : this.beanRuleRegistry.getTypeBasedBeanRules()) {
            for (BeanRule beanRule : set) {
                failedDestroyes += this.doDestroySingleton(beanRule);
            }
        }
        for (BeanRule beanRule : this.beanRuleRegistry.getConfigurableBeanRules()) {
            failedDestroyes += this.doDestroySingleton(beanRule);
        }
        if (failedDestroyes > 0) {
            log.warn("Singletons has not been destroyed cleanly (Failure Count: " + failedDestroyes + ")");
        } else {
            log.debug("Destroyed all cached singletons in " + this);
        }
    }

    private int doDestroySingleton(BeanRule beanRule) {
        int failedCount = 0;
        if (beanRule.getBeanInstance() != null && beanRule.isSingleton()) {
            try {
                BeanInstance instantiatedBean = beanRule.getBeanInstance();
                Object bean = instantiatedBean.getBean();
                if (bean != null) {
                    if (beanRule.isDisposableBean()) {
                        ((DisposableBean)bean).destroy();
                    } else if (beanRule.getDestroyMethod() != null) {
                        Method destroyMethod = beanRule.getDestroyMethod();
                        destroyMethod.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
                    }
                }
            }
            catch (Exception e) {
                ++failedCount;
                log.error("Could not destroy singleton bean " + beanRule, e);
            }
            beanRule.setBeanInstance(null);
        }
        return failedCount;
    }

    private static Object newInstance(Class<?> beanClass, Object[] args, Class<?>[] argTypes) {
        Constructor<?> constructorToUse;
        if (beanClass.isInterface()) {
            throw new BeanInstantiationException(beanClass, "Specified class is an interface");
        }
        try {
            constructorToUse = AbstractBeanFactory.getMatchConstructor(beanClass, args);
            if (constructorToUse == null) {
                constructorToUse = ClassUtils.findConstructor(beanClass, argTypes);
            }
        }
        catch (NoSuchMethodException e) {
            throw new BeanInstantiationException(beanClass, "No default constructor found", e);
        }
        return AbstractBeanFactory.newInstance(constructorToUse, args);
    }

    private static Object newInstance(Class<?> beanClass) {
        return AbstractBeanFactory.newInstance(beanClass, MethodUtils.EMPTY_OBJECT_ARRAY, MethodUtils.EMPTY_CLASS_PARAMETERS);
    }

    private static Object newInstance(Constructor<?> ctor, Object[] args) {
        try {
            return ctor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", e.getTargetException());
        }
    }

    private static Constructor<?> getMatchConstructor(Class<?> beanClass, Object[] args) {
        Constructor<?>[] candidates = beanClass.getDeclaredConstructors();
        Constructor<?> constructorToUse = null;
        float bestMatchWeight = Float.MAX_VALUE;
        for (Constructor<?> candidate : candidates) {
            float matchWeight = ReflectionUtils.getTypeDifferenceWeight(candidate.getParameterTypes(), args);
            if (!(matchWeight < bestMatchWeight)) continue;
            constructorToUse = candidate;
            bestMatchWeight = matchWeight;
        }
        return constructorToUse;
    }

    @Override
    protected void doInitialize() throws Exception {
        this.instantiateSingletons();
    }

    @Override
    protected void doDestroy() throws Exception {
        this.destroySingletons();
    }
}

