/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.AbstractBeanFactory;
import com.aspectran.core.component.bean.BeanNotFoundException;
import com.aspectran.core.component.bean.BeanNotOfRequiredTypeException;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.RequiredTypeBeanNotFoundException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.BeanProxifierType;

public abstract class AbstractBeanRegistry
extends AbstractBeanFactory
implements BeanRegistry {
    public AbstractBeanRegistry(ActivityContext context, BeanRuleRegistry beanRuleRegistry, BeanProxifierType beanProxifierType) {
        super(context, beanRuleRegistry, beanProxifierType);
    }

    @Override
    public <T> T getBean(String id) {
        BeanRule beanRule = this.getBeanRuleRegistry().getBeanRule(id);
        if (beanRule == null) {
            throw new BeanNotFoundException(id);
        }
        return this.getBean(beanRule);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(requiredType);
        if (beanRules == null) {
            BeanRule beanRule = this.getBeanRuleRegistry().getBeanRuleForConfig(requiredType);
            if (beanRule != null) {
                return this.getBean(beanRule);
            }
            throw new RequiredTypeBeanNotFoundException(requiredType);
        }
        if (beanRules.length > 1) {
            throw new NoUniqueBeanException(requiredType, beanRules);
        }
        return this.getBean(beanRules[0]);
    }

    @Override
    public <T> T getBean(String id, Class<T> requiredType) {
        BeanRule beanRule = this.getBeanRuleRegistry().getBeanRule(id);
        if (beanRule == null) {
            throw new BeanNotFoundException(id);
        }
        if (requiredType != null && !requiredType.isAssignableFrom(beanRule.getTargetBeanClass())) {
            throw new BeanNotOfRequiredTypeException(requiredType, beanRule);
        }
        return this.getBean(beanRule);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, String id) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(requiredType);
        if (beanRules == null) {
            throw new RequiredTypeBeanNotFoundException(requiredType);
        }
        if (beanRules.length == 1) {
            return this.getBean(beanRules[0]);
        }
        if (id != null) {
            for (BeanRule beanRule : beanRules) {
                if (!id.equals(beanRule.getId())) continue;
                return this.getBean(beanRule);
            }
        }
        throw new NoUniqueBeanException(requiredType, beanRules);
    }

    @Override
    public <T> T getBeanForConfig(Class<T> requiredType) {
        BeanRule beanRule = this.getBeanRuleRegistry().getBeanRuleForConfig(requiredType);
        if (beanRule == null) {
            throw new RequiredTypeBeanNotFoundException(requiredType);
        }
        return this.getBean(beanRule);
    }

    @Override
    public boolean containsBean(String id) {
        return this.getBeanRuleRegistry().containsBeanRule(id);
    }

    @Override
    public boolean containsBean(Class<?> requiredType) {
        return this.getBeanRuleRegistry().containsBeanRule(requiredType);
    }

    protected abstract <T> T getBean(BeanRule var1);
}

