/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.bean.AbstractBeanRegistry;
import com.aspectran.core.component.bean.BeanCreationException;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.UnsupportedBeanScopeException;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.BeanProxifierType;
import com.aspectran.core.context.rule.type.ScopeType;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ContextBeanRegistry
extends AbstractBeanRegistry {
    private final ReadWriteLock singletonScopeLock = new ReentrantReadWriteLock();

    public ContextBeanRegistry(ActivityContext context, BeanRuleRegistry beanRuleRegistry, BeanProxifierType beanProxifierType) {
        super(context, beanRuleRegistry, beanProxifierType);
    }

    @Override
    public <T> T getBean(BeanRule beanRule) {
        if (beanRule.getScopeType() == ScopeType.PROTOTYPE) {
            return (T)this.getPrototypeScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.SINGLETON) {
            return (T)this.getSingletonScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.REQUEST) {
            return (T)this.getRequestScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.SESSION) {
            return (T)this.getSessionScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.APPLICATION) {
            return (T)this.getApplicationScopeBean(beanRule);
        }
        throw new BeanCreationException(beanRule);
    }

    private Object getPrototypeScopeBean(BeanRule beanRule) {
        Object bean = this.createBean(beanRule);
        if (bean != null && beanRule.isFactoryProductionRequired()) {
            bean = this.getFactoryProducedObject(beanRule, bean);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSingletonScopeBean(BeanRule beanRule) {
        Object bean;
        block12: {
            boolean readLocked = true;
            this.singletonScopeLock.readLock().lock();
            try {
                BeanInstance instantiatedBean = beanRule.getBeanInstance();
                if (instantiatedBean == null) {
                    readLocked = false;
                    this.singletonScopeLock.readLock().unlock();
                    this.singletonScopeLock.writeLock().lock();
                    try {
                        instantiatedBean = beanRule.getBeanInstance();
                        bean = instantiatedBean == null ? this.createBean(beanRule) : instantiatedBean.getBean();
                        if (bean != null && beanRule.isFactoryProductionRequired()) {
                            bean = this.getFactoryProducedObject(beanRule, bean);
                        }
                        break block12;
                    }
                    finally {
                        this.singletonScopeLock.writeLock().unlock();
                    }
                }
                instantiatedBean = beanRule.getBeanInstance();
                bean = instantiatedBean.getBean();
                if (bean == null || !beanRule.isFactoryProductionRequired()) break block12;
                readLocked = false;
                this.singletonScopeLock.readLock().unlock();
                this.singletonScopeLock.writeLock().lock();
                try {
                    bean = this.getFactoryProducedObject(beanRule, bean);
                }
                finally {
                    this.singletonScopeLock.writeLock().unlock();
                }
            }
            finally {
                if (readLocked) {
                    this.singletonScopeLock.readLock().unlock();
                }
            }
        }
        return bean;
    }

    private Object getRequestScopeBean(BeanRule beanRule) {
        Scope scope = this.getRequestScope();
        if (scope == null) {
            throw new UnsupportedBeanScopeException(ScopeType.REQUEST, beanRule);
        }
        return this.getScopedBean(scope, beanRule);
    }

    private Object getSessionScopeBean(BeanRule beanRule) {
        Scope scope = this.getSessionScope();
        if (scope == null) {
            throw new UnsupportedBeanScopeException(ScopeType.SESSION, beanRule);
        }
        return this.getScopedBean(scope, beanRule);
    }

    private Object getApplicationScopeBean(BeanRule beanRule) {
        Scope scope = this.getApplicationScope();
        if (scope == null) {
            throw new UnsupportedBeanScopeException(ScopeType.APPLICATION, beanRule);
        }
        return this.getScopedBean(scope, beanRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getScopedBean(Scope scope, BeanRule beanRule) {
        Object bean;
        block14: {
            ReadWriteLock scopeLock = scope.getScopeLock();
            boolean readLocked = true;
            scopeLock.readLock().lock();
            try {
                BeanInstance instantiatedBean = scope.getBeanInstance(beanRule);
                if (instantiatedBean == null) {
                    readLocked = false;
                    scopeLock.readLock().unlock();
                    scopeLock.writeLock().lock();
                    try {
                        instantiatedBean = scope.getBeanInstance(beanRule);
                        if (instantiatedBean == null) {
                            bean = this.createBean(beanRule);
                            scope.putBeanInstance(beanRule, new BeanInstance(bean));
                        } else {
                            bean = instantiatedBean.getBean();
                        }
                        if (beanRule.isFactoryProductionRequired()) {
                            bean = this.getFactoryProducedObject(beanRule, bean);
                        }
                        break block14;
                    }
                    finally {
                        scopeLock.writeLock().unlock();
                    }
                }
                bean = instantiatedBean.getBean();
                if (bean == null || !beanRule.isFactoryProductionRequired()) break block14;
                readLocked = false;
                scopeLock.readLock().unlock();
                scopeLock.writeLock().lock();
                try {
                    bean = this.getFactoryProducedObject(beanRule, bean);
                }
                finally {
                    scopeLock.writeLock().unlock();
                }
            }
            finally {
                if (readLocked) {
                    scopeLock.readLock().unlock();
                }
            }
        }
        return bean;
    }

    private Scope getRequestScope() {
        RequestAdapter requestAdapter;
        Activity activity = this.getContext().getCurrentActivity();
        if (activity != null && (requestAdapter = activity.getRequestAdapter()) != null) {
            return requestAdapter.getRequestScope();
        }
        return null;
    }

    private Scope getSessionScope() {
        SessionAdapter sessionAdapter;
        Activity activity = this.getContext().getCurrentActivity();
        if (activity != null && (sessionAdapter = activity.getSessionAdapter()) != null) {
            return sessionAdapter.getSessionScope();
        }
        return null;
    }

    private Scope getApplicationScope() {
        return this.getContext().getEnvironment().getApplicationAdapter().getApplicationScope();
    }
}

