/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.proxy;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.aspect.AspectAdviceRulePostRegister;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.proxy.RelevantAspectRuleHolder;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public abstract class AbstractDynamicBeanProxy {
    private static final Log log = LogFactory.getLog(AbstractDynamicBeanProxy.class);
    private static final RelevantAspectRuleHolder EMPTY_HOLDER = new RelevantAspectRuleHolder();
    private static final Map<String, RelevantAspectRuleHolder> cache = new ConcurrentReferenceHashMap<String, RelevantAspectRuleHolder>(256);
    private final AspectRuleRegistry aspectRuleRegistry;

    public AbstractDynamicBeanProxy(AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
    }

    protected boolean isAvoidAdvice(Method method) {
        return Object.class == method.getDeclaringClass() || method.getDeclaringClass().isAnnotationPresent(AvoidAdvice.class) || method.isAnnotationPresent(AvoidAdvice.class);
    }

    protected AspectAdviceRuleRegistry retrieveAspectAdviceRuleRegistry(Activity activity, String transletName, String beanId, String className, String methodName) {
        RelevantAspectRuleHolder holder = this.getRelevantAspectRuleHolder(transletName, beanId, className, methodName);
        AspectAdviceRuleRegistry aarr = holder.getAspectAdviceRuleRegistry();
        if (aarr != null && aarr.getSettingsAdviceRuleList() != null) {
            for (SettingsAdviceRule sar : aarr.getSettingsAdviceRuleList()) {
                activity.registerSettingsAdviceRule(sar);
            }
        }
        if (holder.getDynamicAspectRuleList() != null) {
            for (AspectRule aspectRule : holder.getDynamicAspectRuleList()) {
                activity.registerAspectRule(aspectRule);
            }
        }
        return aarr;
    }

    private RelevantAspectRuleHolder getRelevantAspectRuleHolder(String transletName, String beanId, String className, String methodName) {
        String pattern = PointcutPatternRule.combinePattern(transletName, beanId, className, methodName);
        RelevantAspectRuleHolder holder = cache.get(pattern);
        if (holder == null) {
            holder = this.createRelevantAspectRuleHolder(transletName, beanId, className, methodName);
            RelevantAspectRuleHolder existing = cache.putIfAbsent(pattern, holder);
            if (existing != null) {
                holder = existing;
            } else if (log.isDebugEnabled()) {
                log.debug("Caching [" + pattern + "] for Aspects " + holder);
            }
        }
        return holder;
    }

    private RelevantAspectRuleHolder createRelevantAspectRuleHolder(String transletName, String beanId, String className, String methodName) {
        AspectAdviceRulePostRegister postRegister = new AspectAdviceRulePostRegister();
        ArrayList<AspectRule> dynamicAspectRuleList = new ArrayList<AspectRule>();
        for (AspectRule aspectRule : this.aspectRuleRegistry.getAspectRules()) {
            Pointcut pointcut;
            if (!aspectRule.isBeanRelevant() || (pointcut = aspectRule.getPointcut()) != null && !pointcut.matches(transletName, beanId, className, methodName)) continue;
            if (aspectRule.getJoinpointTargetType() == JoinpointTargetType.METHOD) {
                postRegister.register(aspectRule);
                continue;
            }
            if (aspectRule.getJoinpointTargetType() != JoinpointTargetType.TRANSLET) continue;
            dynamicAspectRuleList.add(aspectRule);
        }
        AspectAdviceRuleRegistry registry = postRegister.getAspectAdviceRuleRegistry();
        if (!dynamicAspectRuleList.isEmpty() || registry != null) {
            RelevantAspectRuleHolder holder = new RelevantAspectRuleHolder();
            holder.setAspectAdviceRuleRegistry(registry);
            if (!dynamicAspectRuleList.isEmpty()) {
                holder.setDynamicAspectRuleList(dynamicAspectRuleList);
            }
            return holder;
        }
        return EMPTY_HOLDER;
    }

    protected boolean isSameBean(BeanRule beanRule, AspectAdviceRule aspectAdviceRule) {
        if (beanRule.getId() != null && beanRule.getId().equals(aspectAdviceRule.getAdviceBeanId())) {
            return true;
        }
        if (beanRule.getBeanClass() != null && aspectAdviceRule.getAdviceBeanClass() != null) {
            return beanRule.getBeanClass() == aspectAdviceRule.getAdviceBeanClass();
        }
        return false;
    }
}

