/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scope;

import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AbstractScope
implements Scope {
    private static final Log log = LogFactory.getLog(AbstractScope.class);
    private final ReadWriteLock scopeLock = new ReentrantReadWriteLock();
    private final Map<BeanRule, BeanInstance> scopedBeanMap = new HashMap<BeanRule, BeanInstance>();
    private final ScopeType scopeType;

    AbstractScope(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    @Override
    public ReadWriteLock getScopeLock() {
        return this.scopeLock;
    }

    @Override
    public BeanInstance getBeanInstance(BeanRule beanRule) {
        return this.scopedBeanMap.get(beanRule);
    }

    @Override
    public void putBeanInstance(BeanRule beanRule, BeanInstance beanInstance) {
        this.scopedBeanMap.put(beanRule, beanInstance);
    }

    @Override
    public void destroy() {
        if (log.isDebugEnabled() && !this.scopedBeanMap.isEmpty()) {
            log.debug("Destroy " + (Object)((Object)this.scopeType) + " scoped beans from " + this);
        }
        for (Map.Entry<BeanRule, BeanInstance> entry : this.scopedBeanMap.entrySet()) {
            BeanRule beanRule = entry.getKey();
            BeanInstance instantiatedBean = entry.getValue();
            Object bean = instantiatedBean.getBean();
            if (bean == null) continue;
            this.doDestroy(beanRule, bean);
        }
        this.scopedBeanMap.clear();
    }

    private void doDestroy(BeanRule beanRule, Object bean) {
        if (bean != null) {
            try {
                if (beanRule.isDisposableBean()) {
                    ((DisposableBean)bean).destroy();
                } else if (beanRule.getDestroyMethodName() != null) {
                    Method destroyMethod = beanRule.getDestroyMethod();
                    destroyMethod.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
                }
            }
            catch (Exception e) {
                log.error("Could not destroy " + (Object)((Object)this.scopeType) + " scoped bean " + beanRule, e);
            }
        }
    }
}

