/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Locker;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSessionCache
implements SessionCache {
    private static final Log log = LogFactory.getLog(AbstractSessionCache.class);
    protected final SessionHandler sessionHandler;
    protected SessionDataStore sessionDataStore;
    protected int evictionPolicy = -1;
    protected boolean saveOnCreate;
    protected boolean saveOnInactiveEviction;
    protected boolean removeUnloadableSessions;

    public AbstractSessionCache(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    protected SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public SessionDataStore getSessionDataStore() {
        return this.sessionDataStore;
    }

    @Override
    public void setSessionDataStore(SessionDataStore sessionDataStore) {
        this.sessionDataStore = sessionDataStore;
    }

    @Override
    public int getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Override
    public void setEvictionPolicy(int evictionTimeout) {
        this.evictionPolicy = evictionTimeout;
    }

    @Override
    public boolean isSaveOnCreate() {
        return this.saveOnCreate;
    }

    @Override
    public void setSaveOnCreate(boolean saveOnCreate) {
        this.saveOnCreate = saveOnCreate;
    }

    @Override
    public boolean isRemoveUnloadableSessions() {
        return this.removeUnloadableSessions;
    }

    @Override
    public void setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.removeUnloadableSessions = removeUnloadableSessions;
    }

    @Override
    public boolean isSaveOnInactiveEviction() {
        return this.saveOnInactiveEviction;
    }

    @Override
    public void setSaveOnInactiveEviction(boolean saveOnEvict) {
        this.saveOnInactiveEviction = saveOnEvict;
    }

    @Override
    public Session get(String id) throws Exception {
        Session session;
        Exception ex = null;
        while (true) {
            session = this.doGet(id);
            if (this.sessionDataStore == null) break;
            if (session == null) {
                Locker.Lock ignored;
                if (log.isDebugEnabled()) {
                    log.debug("Session " + id + " not found locally, attempting to load");
                }
                PlaceHolderSession phs = new PlaceHolderSession(new SessionData(id, 0L, 0L, 0L, 0L));
                Locker.Lock phsLock = phs.lock();
                Session s = this.doPutIfAbsent(id, phs);
                if (s == null) {
                    try {
                        session = this.loadSession(id);
                        if (session == null) {
                            this.doDelete(id);
                            phsLock.close();
                            break;
                        }
                        ignored = session.lock();
                        try {
                            boolean success = this.doReplace(id, phs, session);
                            if (!success) {
                                this.doDelete(id);
                                session = null;
                                log.warn("Replacement of placeholder for session " + id + " failed");
                                phsLock.close();
                            } else {
                                session.setResident(true);
                                session.updateInactivityTimer();
                                phsLock.close();
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        ex = e;
                        this.doDelete(id);
                        phsLock.close();
                        session = null;
                    }
                    break;
                }
                phsLock.close();
                ignored = s.lock();
                try {
                    if (!s.isResident() || s instanceof PlaceHolderSession) continue;
                    session = s;
                    break;
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                    continue;
                }
            }
            Locker.Lock ignored = session.lock();
            try {
                if (session.isResident() && !(session instanceof PlaceHolderSession)) break;
                continue;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
        if (ex != null) {
            throw ex;
        }
        return session;
    }

    private Session loadSession(String id) throws Exception {
        if (this.sessionDataStore == null) {
            return null;
        }
        try {
            SessionData data = this.sessionDataStore.load(id);
            if (data == null) {
                return null;
            }
            return this.newSession(data);
        }
        catch (UnreadableSessionDataException e) {
            if (this.isRemoveUnloadableSessions()) {
                this.sessionDataStore.delete(id);
            }
            throw e;
        }
    }

    @Override
    public void put(String id, Session session) throws Exception {
        if (id == null || session == null) {
            throw new IllegalArgumentException("Put key=" + id + " session=" + (session == null ? "null" : session.getId()));
        }
        try (Locker.Lock ignored = session.lock();){
            if (!session.isValid()) {
                return;
            }
            if (this.sessionDataStore == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No SessionDataStore, putting into SessionCache only id=" + id);
                }
                session.setResident(true);
                if (this.doPutIfAbsent(id, session) == null) {
                    session.updateInactivityTimer();
                }
                return;
            }
            if (session.getRequests() <= 0L) {
                if (!this.sessionDataStore.isPassivating()) {
                    this.sessionDataStore.store(id, session.getSessionData());
                    if (this.getEvictionPolicy() == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("Eviction on request exit id=" + id);
                        }
                        this.doDelete(session.getId());
                        session.setResident(false);
                    } else {
                        session.setResident(true);
                        if (this.doPutIfAbsent(id, session) == null) {
                            session.updateInactivityTimer();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Non passivating SessionDataStore, session in SessionCache only id=" + id);
                        }
                    }
                } else {
                    this.sessionHandler.willPassivate(session);
                    if (log.isDebugEnabled()) {
                        log.debug("Session passivating id=" + id);
                    }
                    this.sessionDataStore.store(id, session.getSessionData());
                    if (this.getEvictionPolicy() == 0) {
                        this.doDelete(id);
                        session.setResident(false);
                        if (log.isDebugEnabled()) {
                            log.debug("Evicted on request exit id=" + id);
                        }
                    } else {
                        this.sessionHandler.didActivate(session);
                        session.setResident(true);
                        if (this.doPutIfAbsent(id, session) == null) {
                            session.updateInactivityTimer();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Session reactivated id=" + id);
                        }
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Req count=" + session.getRequests() + " for id=" + id);
                }
                session.setResident(true);
                if (this.doPutIfAbsent(id, session) == null) {
                    session.updateInactivityTimer();
                }
            }
        }
    }

    @Override
    public boolean exists(String id) throws Exception {
        Session s = this.doGet(id);
        if (s != null) {
            try (Locker.Lock ignored = s.lock();){
                boolean bl = s.isValid();
                return bl;
            }
        }
        return this.sessionDataStore != null && this.sessionDataStore.exists(id);
    }

    @Override
    public boolean contains(String id) throws Exception {
        return this.doGet(id) != null;
    }

    @Override
    public Session delete(String id) throws Exception {
        Session session = this.get(id);
        if (this.sessionDataStore != null) {
            boolean deleted = this.sessionDataStore.delete(id);
            if (log.isDebugEnabled()) {
                log.debug("Session " + id + " deleted in db: " + deleted);
            }
        }
        if (session != null) {
            session.stopInactivityTimer();
            session.setResident(false);
        }
        return this.doDelete(id);
    }

    @Override
    public Set<String> checkExpiration(Set<String> candidates) {
        if (log.isDebugEnabled()) {
            log.debug("SessionDataStore checking expiration on " + candidates);
        }
        if (this.sessionDataStore == null) {
            return null;
        }
        Set<String> allCandidates = this.sessionDataStore.getExpired(candidates);
        HashSet<String> sessionsInUse = new HashSet<String>();
        if (allCandidates != null) {
            for (String c : allCandidates) {
                Session s = this.doGet(c);
                if (s == null || s.getRequests() <= 0L) continue;
                sessionsInUse.add(c);
            }
            try {
                allCandidates.removeAll(sessionsInUse);
            }
            catch (UnsupportedOperationException e) {
                HashSet<String> tmp = new HashSet<String>(allCandidates);
                tmp.removeAll(sessionsInUse);
                allCandidates = tmp;
            }
        }
        return allCandidates;
    }

    @Override
    public void checkInactiveSession(Session session) {
        if (session == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking for idle " + session.getId());
        }
        try (Locker.Lock ignored = session.lock();){
            if (this.getEvictionPolicy() > 0 && session.isIdleLongerThan(this.getEvictionPolicy()) && session.isValid() && session.isResident() && session.getRequests() <= 0L) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Evicting idle session " + session.getId());
                    }
                    if (this.isSaveOnInactiveEviction() && this.sessionDataStore != null) {
                        if (this.sessionDataStore.isPassivating()) {
                            this.sessionHandler.willPassivate(session);
                        }
                        this.sessionDataStore.store(session.getId(), session.getSessionData());
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                }
                catch (Exception e) {
                    log.warn("Passivation of idle session" + session.getId() + " failed", e);
                    session.updateInactivityTimer();
                }
            }
        }
    }

    @Override
    public Session newSession(String id, long time, long maxInactiveIntervalMS) {
        if (log.isDebugEnabled()) {
            log.debug("Creating new session id=" + id);
        }
        SessionData sessionData = new SessionData(id, time, time, time, maxInactiveIntervalMS);
        Session session = this.newSession(sessionData);
        try {
            if (this.isSaveOnCreate() && this.sessionDataStore != null) {
                this.sessionDataStore.store(id, sessionData);
            }
        }
        catch (Exception e) {
            log.warn("Save of new session " + id + " failed", e);
        }
        return session;
    }

    @Override
    public abstract Session newSession(SessionData var1);

    public abstract Session doGet(String var1);

    public abstract Session doPutIfAbsent(String var1, Session var2);

    public abstract boolean doReplace(String var1, Session var2, Session var3);

    public abstract Session doDelete(String var1);

    protected class PlaceHolderSession
    extends Session {
        public PlaceHolderSession(SessionData data) {
            super(null, data);
        }
    }
}

