/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSessionDataStore
extends AbstractComponent
implements SessionDataStore {
    private static final Log log = LogFactory.getLog(AbstractSessionDataStore.class);
    protected int gracePeriodSec = 3600;
    protected long lastExpiryCheckTime = 0L;
    protected int savePeriodSec = 0;

    public abstract void doStore(String var1, SessionData var2, long var3) throws Exception;

    public abstract Set<String> doGetExpired(Set<String> var1);

    @Override
    public void store(String id, SessionData data) throws Exception {
        long savePeriodMs;
        if (data == null) {
            return;
        }
        long lastSave = data.getLastSaved();
        long l = savePeriodMs = this.savePeriodSec <= 0 ? 0L : TimeUnit.SECONDS.toMillis(this.savePeriodSec);
        if (log.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Store");
            tsb.append("id", id);
            tsb.append("dirty", data.isDirty());
            tsb.append("lastSaved", data.getLastSaved());
            tsb.append("period", savePeriodMs);
            tsb.append("elapsed", System.currentTimeMillis() - lastSave);
            log.debug(tsb.toString());
        }
        if (data.isDirty() || lastSave <= 0L || System.currentTimeMillis() - lastSave > savePeriodMs) {
            data.setLastSaved(System.currentTimeMillis());
            try {
                this.doStore(id, data, lastSave);
                data.setDirty(false);
            }
            catch (Exception e) {
                data.setLastSaved(lastSave);
                throw e;
            }
        }
    }

    @Override
    public Set<String> getExpired(Set<String> candidates) {
        try {
            Set<String> set = this.doGetExpired(candidates);
            return set;
        }
        finally {
            this.lastExpiryCheckTime = System.currentTimeMillis();
        }
    }

    @Override
    public SessionData newSessionData(String id, long createdTime, long accessedTime, long lastAccessedTime, long maxInactiveIntervalMS) {
        return new SessionData(id, createdTime, accessedTime, lastAccessedTime, maxInactiveIntervalMS);
    }

    public int getGracePeriodSec() {
        return this.gracePeriodSec;
    }

    public void setGracePeriodSec(int sec) {
        this.gracePeriodSec = sec;
    }

    public int getSavePeriodSec() {
        return this.savePeriodSec;
    }

    public void setSavePeriodSec(int savePeriodSec) {
        this.savePeriodSec = savePeriodSec;
    }

    @Override
    protected void doInitialize() throws Exception {
    }

    @Override
    protected void doDestroy() {
    }

    protected void checkInitialized() throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
    }
}

