/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionActivationListener;
import com.aspectran.core.component.session.SessionAttributeListener;
import com.aspectran.core.component.session.SessionBindingListener;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.statistic.CounterStatistic;
import com.aspectran.core.util.statistic.SampleStatistic;
import com.aspectran.core.util.thread.ScheduledExecutorScheduler;
import com.aspectran.core.util.thread.Scheduler;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractSessionHandler
extends AbstractComponent
implements SessionHandler {
    private static final Log log = LogFactory.getLog(AbstractSessionHandler.class);
    protected final SampleStatistic sessionTimeStats = new SampleStatistic();
    protected final CounterStatistic sessionsCreatedStats = new CounterStatistic();
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private final List<SessionAttributeListener> sessionAttributeListeners = new CopyOnWriteArrayList<SessionAttributeListener>();
    private final Scheduler scheduler = new ScheduledExecutorScheduler();
    private SessionIdGenerator sessionIdGenerator;
    private SessionCache sessionCache;
    private int defaultMaxIdleSecs = -1;

    @Override
    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    protected void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    @Override
    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    protected void setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public int getDefaultMaxIdleSecs() {
        return this.defaultMaxIdleSecs;
    }

    @Override
    public void setDefaultMaxIdleSecs(int defaultMaxIdleSecs) {
        this.defaultMaxIdleSecs = defaultMaxIdleSecs;
        if (log.isDebugEnabled()) {
            if (defaultMaxIdleSecs <= 0) {
                log.debug("Sessions created by this manager are immortal (default maxInactiveInterval=" + defaultMaxIdleSecs + ")");
            } else {
                log.debug("SessionHandler default maxInactiveInterval=" + defaultMaxIdleSecs);
            }
        }
    }

    @Override
    public void access(Session session) {
        long now = System.currentTimeMillis();
        session.access(now);
    }

    @Override
    public void complete(Session session) {
        try {
            session.complete();
            this.sessionCache.put(session.getId(), session);
        }
        catch (Exception e) {
            log.warn("Session failed to complete", e);
        }
    }

    @Override
    public Session newSession(String id) {
        long created = System.currentTimeMillis();
        Session session = this.sessionCache.newSession(id, created, this.defaultMaxIdleSecs > 0 ? (long)this.defaultMaxIdleSecs * 1000L : -1L);
        try {
            this.sessionCache.put(id, session);
            this.sessionsCreatedStats.increment();
            for (SessionListener listener : this.sessionListeners) {
                listener.sessionCreated(session);
            }
            return session;
        }
        catch (Exception e) {
            log.warn("Failed to create a new session", e);
            return null;
        }
    }

    @Override
    public Session getSession(String id) {
        try {
            Session session = this.sessionCache.get(id);
            if (session != null && session.isExpiredAt(System.currentTimeMillis())) {
                try {
                    session.invalidate();
                }
                catch (Exception e) {
                    log.warn("Invalidating session " + id + " found to be expired when requested", e);
                }
                return null;
            }
            return session;
        }
        catch (UnreadableSessionDataException e) {
            log.warn(e.getMessage(), e);
            return null;
        }
        catch (Exception other) {
            log.warn(other.getMessage(), other);
            return null;
        }
    }

    @Override
    public void invalidate(String id) {
        Session session = this.removeSession(id);
        if (session != null) {
            this.sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getSessionData().getCreationTime()) / 1000.0));
            session.finishInvalidate();
        }
    }

    private Session removeSession(String id) {
        try {
            Session session = this.sessionCache.delete(id);
            if (session != null) {
                session.beginInvalidate();
                for (int i = this.sessionListeners.size() - 1; i >= 0; --i) {
                    this.sessionListeners.get(i).sessionDestroyed(session);
                }
            }
            return session;
        }
        catch (Exception e) {
            log.warn("Failed to delete session", e);
            return null;
        }
    }

    @Override
    public String newSessionId(long seedTerm) {
        return this.sessionIdGenerator.newSessionId(seedTerm);
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof SessionListener) {
            this.sessionListeners.add((SessionListener)listener);
        }
        if (listener instanceof SessionAttributeListener) {
            this.sessionAttributeListeners.add((SessionAttributeListener)((Object)listener));
        }
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof SessionListener) {
            this.sessionListeners.remove(listener);
        }
        if (listener instanceof SessionAttributeListener) {
            this.sessionAttributeListeners.remove(listener);
        }
    }

    @Override
    public void clearEventListeners() {
        this.sessionListeners.clear();
        this.sessionAttributeListeners.clear();
    }

    @Override
    public void sessionAttributeChanged(Session session, String name, Object oldValue, Object newValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this.unbindValue(session, name, oldValue);
            }
            if (newValue != null) {
                this.bindValue(session, name, newValue);
            }
        }
        if (!this.sessionAttributeListeners.isEmpty()) {
            for (SessionAttributeListener listener : this.sessionAttributeListeners) {
                if (oldValue == null) {
                    listener.attributeAdded(session, name, newValue);
                    continue;
                }
                if (newValue == null) {
                    listener.attributeRemoved(session, name, oldValue);
                    continue;
                }
                listener.attributeReplaced(session, name, oldValue);
            }
        }
    }

    private void unbindValue(Session session, String name, Object value) {
        if (value instanceof SessionBindingListener) {
            ((SessionBindingListener)value).valueUnbound(session, name, value);
        }
    }

    private void bindValue(Session session, String name, Object value) {
        if (value instanceof SessionBindingListener) {
            ((SessionBindingListener)value).valueBound(session, name, value);
        }
    }

    @Override
    public void didActivate(Session session) {
        SessionData sessionData = session.getSessionData();
        if (sessionData != null) {
            for (String key : sessionData.getKeys()) {
                Object value = sessionData.getAttribute(key);
                if (!(value instanceof SessionActivationListener)) continue;
                SessionActivationListener listener = (SessionActivationListener)value;
                listener.sessionDidActivate(session);
            }
        }
    }

    @Override
    public void willPassivate(Session session) {
        SessionData sessionData = session.getSessionData();
        if (sessionData != null) {
            for (String key : sessionData.getKeys()) {
                Object value = sessionData.getAttribute(key);
                if (!(value instanceof SessionActivationListener)) continue;
                SessionActivationListener listener = (SessionActivationListener)value;
                listener.sessionWillPassivate(session);
            }
        }
    }

    @Override
    public long getSessionTimeMax() {
        return this.sessionTimeStats.getMax();
    }

    @Override
    public long getSessionTimeTotal() {
        return this.sessionTimeStats.getTotal();
    }

    @Override
    public double getSessionTimeMean() {
        return this.sessionTimeStats.getMean();
    }

    @Override
    public double getSessionTimeStdDev() {
        return this.sessionTimeStats.getStdDev();
    }

    @Override
    public int getSessionsCreated() {
        return (int)this.sessionsCreatedStats.getCurrent();
    }

    @Override
    public void statsReset() {
        this.sessionsCreatedStats.reset();
        this.sessionTimeStats.reset();
    }

    @Override
    protected void doInitialize() throws Exception {
        this.scheduler.start();
    }

    @Override
    protected void doDestroy() throws Exception {
        this.scheduler.stop();
        this.sessionCache.clear();
    }
}

