/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionCache;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.statistic.CounterStatistic;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Log log = LogFactory.getLog(DefaultSessionCache.class);
    private final ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    private final CounterStatistic statistic = new CounterStatistic();

    public DefaultSessionCache(SessionHandler sessionHandler) {
        super(sessionHandler);
    }

    @Override
    public Session doGet(String id) {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session doPutIfAbsent(String id, Session session) {
        Session s = this.sessions.putIfAbsent(id, session);
        if (s == null && !(session instanceof AbstractSessionCache.PlaceHolderSession)) {
            this.statistic.increment();
        }
        return s;
    }

    @Override
    public Session doDelete(String id) {
        Session s = this.sessions.remove(id);
        if (s != null && !(s instanceof AbstractSessionCache.PlaceHolderSession)) {
            this.statistic.decrement();
        }
        return s;
    }

    @Override
    public boolean doReplace(String id, Session oldValue, Session newValue) {
        boolean result = this.sessions.replace(id, oldValue, newValue);
        if (result && oldValue instanceof AbstractSessionCache.PlaceHolderSession) {
            this.statistic.increment();
        }
        return result;
    }

    @Override
    public Session newSession(SessionData data) {
        return new Session(this.getSessionHandler(), data);
    }

    @Override
    public long getSessionsCurrent() {
        return this.statistic.getCurrent();
    }

    @Override
    public long getSessionsMax() {
        return this.statistic.getMax();
    }

    @Override
    public long getSessionsTotal() {
        return this.statistic.getTotal();
    }

    @Override
    public void resetStats() {
        this.statistic.reset();
    }

    @Override
    public void clear() {
        int loop = 100;
        while (!this.sessions.isEmpty() && loop-- >= 0) {
            for (Session session : this.sessions.values()) {
                if (this.sessionDataStore != null) {
                    this.sessionHandler.willPassivate(session);
                    try {
                        this.sessionDataStore.store(session.getId(), session.getSessionData());
                    }
                    catch (Exception e) {
                        log.warn("Failed to save session data", e);
                    }
                    this.doDelete(session.getId());
                    continue;
                }
                try {
                    session.invalidate();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Session invalidation failed, but ignored", e);
                }
            }
        }
    }
}

