/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.activity.aspect.SessionScopeAdvisor;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.DefaultSessionCache;
import com.aspectran.core.component.session.FileSessionDataStore;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.SessionConfig;
import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.core.context.rule.type.SessionStoreType;
import com.aspectran.core.util.StringUtils;
import java.io.File;

public class DefaultSessionManager
extends AbstractSessionHandler
implements SessionManager {
    private final ActivityContext context;
    private String groupName;
    private SessionConfig sessionConfig;
    private SessionDataStore sessionDataStore;

    public DefaultSessionManager() {
        this(null);
    }

    public DefaultSessionManager(ActivityContext context) {
        this.context = context;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    @Override
    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    @Override
    public SessionDataStore getSessionDataStore() {
        return this.sessionDataStore;
    }

    @Override
    public void setSessionDataStore(SessionDataStore sessionDataStore) {
        this.sessionDataStore = sessionDataStore;
    }

    @Override
    public SessionHandler getSessionHandler() {
        return this;
    }

    @Override
    public SessionAgent newSessionAgent() {
        return new SessionAgent(this);
    }

    @Override
    protected void doInitialize() throws Exception {
        SessionScopeAdvisor sessionScopeAdvisor;
        if (this.getSessionIdGenerator() == null) {
            SessionIdGenerator sessionIdGenerator = new SessionIdGenerator(this.groupName);
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.getSessionCache() == null) {
            DefaultSessionCache sessionCache = new DefaultSessionCache(this);
            this.setSessionCache(sessionCache);
        }
        if (this.sessionDataStore != null) {
            this.getSessionCache().setSessionDataStore(this.sessionDataStore);
        }
        if (this.sessionConfig != null) {
            String storeType;
            SessionStoreType sessionStoreType;
            if (this.sessionConfig.hasTimeout()) {
                int timeout = this.sessionConfig.getTimeout();
                this.setDefaultMaxIdleSecs(timeout);
            }
            if (this.getSessionCache().getSessionDataStore() != null && (sessionStoreType = SessionStoreType.resolve(storeType = this.sessionConfig.getStoreType())) == SessionStoreType.FILE) {
                boolean deleteUnrestorableFiles;
                FileSessionDataStore fileSessionDataStore = new FileSessionDataStore();
                SessionFileStoreConfig fileStoreConfig = this.sessionConfig.getFileStoreConfig();
                String path = fileStoreConfig.getPath();
                if (StringUtils.hasText(path)) {
                    fileSessionDataStore.setStoreDir(new File(path));
                }
                if (deleteUnrestorableFiles = fileStoreConfig.isDeleteUnrestorableFiles()) {
                    fileSessionDataStore.setDeleteUnrestorableFiles(true);
                }
                fileSessionDataStore.initialize();
                this.getSessionCache().setSessionDataStore(fileSessionDataStore);
            }
        }
        if (this.context != null && (sessionScopeAdvisor = SessionScopeAdvisor.create(this.context)) != null) {
            this.addEventListener(new SessionListener(){

                @Override
                public void sessionCreated(Session session) {
                    sessionScopeAdvisor.executeBeforeAdvice();
                }

                @Override
                public void sessionDestroyed(Session session) {
                    sessionScopeAdvisor.executeAfterAdvice();
                }
            });
        }
        super.doInitialize();
    }

    @Override
    protected void doDestroy() throws Exception {
        this.getSessionCache().clear();
        super.doDestroy();
    }
}

