/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionDataStore;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.component.session.UnwritableSessionDataException;
import com.aspectran.core.util.CustomObjectInputStream;
import com.aspectran.core.util.MultiException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class FileSessionDataStore
extends AbstractSessionDataStore {
    private static final Log log = LogFactory.getLog(FileSessionDataStore.class);
    private final Map<String, String> sessionFileMap = new ConcurrentHashMap<String, String>();
    private File storeDir;
    private boolean deleteUnrestorableFiles;
    private long lastSweepTime;

    public File getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(File storeDir) {
        this.checkInitialized();
        this.storeDir = storeDir;
    }

    public boolean isDeleteUnrestorableFiles() {
        return this.deleteUnrestorableFiles;
    }

    public void setDeleteUnrestorableFiles(boolean deleteUnrestorableFiles) {
        this.checkInitialized();
        this.deleteUnrestorableFiles = deleteUnrestorableFiles;
    }

    @Override
    public boolean delete(String id) throws Exception {
        if (this.storeDir != null) {
            String filename = this.sessionFileMap.remove(id);
            if (filename == null) {
                return false;
            }
            return this.deleteFile(filename);
        }
        return false;
    }

    private boolean deleteFile(String filename) throws Exception {
        if (filename == null) {
            return false;
        }
        File file = new File(this.storeDir, filename);
        return Files.deleteIfExists(file.toPath());
    }

    @Override
    public Set<String> doGetExpired(Set<String> candidates) {
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        for (String filename : this.sessionFileMap.values()) {
            try {
                long expiry = this.getExpiryFromFilename(filename);
                if (expiry <= 0L || expiry >= now) continue;
                expired.add(this.getIdFromFilename(filename));
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }
        for (String c : candidates) {
            String filename;
            if (expired.contains(c) || (filename = this.sessionFileMap.get(c)) != null) continue;
            expired.add(c);
        }
        if (this.gracePeriodSec > 0 && (this.lastSweepTime == 0L || now - this.lastSweepTime >= 5L * TimeUnit.SECONDS.toMillis(this.gracePeriodSec))) {
            this.lastSweepTime = now;
            this.sweepDisk();
        }
        return expired;
    }

    @Override
    public SessionData load(String id) throws Exception {
        SessionData sessionData;
        String filename = this.sessionFileMap.get(id);
        if (filename == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unknown session " + id);
            }
            return null;
        }
        File file = new File(this.storeDir, filename);
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug("No such file " + filename);
            }
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            SessionData data = this.load(in, id);
            data.setLastSaved(file.lastModified());
            sessionData = data;
        }
        catch (Throwable data) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    data.addSuppressed(throwable);
                }
                throw data;
            }
            catch (UnreadableSessionDataException e) {
                if (this.isDeleteUnrestorableFiles() && file.exists() && file.getParentFile().equals(this.storeDir)) {
                    try {
                        this.delete(id);
                        log.warn("Deleted unrestorable file for session " + id);
                    }
                    catch (Exception x) {
                        log.warn("Unable to delete unrestorable file " + filename + " for session " + id, x);
                    }
                }
                throw e;
            }
        }
        in.close();
        return sessionData;
    }

    @Override
    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (this.storeDir != null) {
            this.delete(id);
            String filename = this.getIdWithExpiry(data);
            File file = new File(this.storeDir, filename);
            try (FileOutputStream fos = new FileOutputStream(file, false);){
                this.save(fos, id, data);
                this.sessionFileMap.put(id, filename);
            }
            catch (Exception e) {
                file.delete();
                throw new UnwritableSessionDataException(id, e);
            }
        }
    }

    @Override
    public boolean isPassivating() {
        return true;
    }

    @Override
    public boolean exists(String id) throws Exception {
        String filename = this.sessionFileMap.get(id);
        if (filename == null) {
            return false;
        }
        long expiry = this.getExpiryFromFilename(filename);
        if (expiry <= 0L) {
            return true;
        }
        return expiry > System.currentTimeMillis();
    }

    private String getIdWithExpiry(SessionData data) {
        return data.getId() + "_" + data.getExpiryTime();
    }

    private long getExpiryFromFilename(String filename) {
        if (!StringUtils.hasText(filename) || !filename.contains("_")) {
            throw new IllegalStateException("Invalid or missing filename");
        }
        String s = filename.substring(filename.lastIndexOf(95) + 1);
        return Long.parseLong(s);
    }

    private String getIdFromFilename(String filename) {
        if (!StringUtils.hasText(filename) || filename.indexOf(95) < 0) {
            return null;
        }
        return filename.substring(0, filename.lastIndexOf(95));
    }

    private boolean isSessionFilename(String filename) {
        if (!StringUtils.hasText(filename)) {
            return false;
        }
        String[] parts = filename.split("_");
        return parts.length >= 2;
    }

    public void sweepDisk() {
        long now = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Sweeping " + this.storeDir + " for old session files");
        }
        try {
            Files.walk(this.storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> this.isSessionFilename(p.getFileName().toString())).forEach(p -> {
                try {
                    this.sweepFile(now, (Path)p);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            });
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void sweepFile(long now, Path p) throws Exception {
        if (p == null) {
            return;
        }
        long expiry = this.getExpiryFromFilename(p.getFileName().toString());
        if (expiry > 0L && now - expiry >= 5L * TimeUnit.SECONDS.toMillis(this.gracePeriodSec)) {
            Files.deleteIfExists(p);
            if (log.isDebugEnabled()) {
                log.debug("Sweep deleted " + p.getFileName());
            }
        }
    }

    private void save(OutputStream os, String id, SessionData data) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF(id);
        out.writeLong(data.getCreationTime());
        out.writeLong(data.getAccessedTime());
        out.writeLong(data.getLastAccessedTime());
        out.writeLong(data.getExpiryTime());
        out.writeLong(data.getMaxInactiveInterval());
        ArrayList<String> keys = new ArrayList<String>(data.getKeys());
        out.writeInt(keys.size());
        ObjectOutputStream oos = new ObjectOutputStream(out);
        for (String name : keys) {
            oos.writeUTF(name);
            oos.writeObject(data.getAttribute(name));
        }
    }

    private SessionData load(InputStream is, String expectedId) throws Exception {
        try {
            DataInputStream di = new DataInputStream(is);
            String id = di.readUTF();
            long created = di.readLong();
            long accessed = di.readLong();
            long lastAccessed = di.readLong();
            long expiry = di.readLong();
            long maxIdle = di.readLong();
            SessionData data = this.newSessionData(id, created, accessed, lastAccessed, maxIdle);
            data.setExpiryTime(expiry);
            data.setMaxInactiveInterval(maxIdle);
            this.restoreAttributes(di, di.readInt(), data);
            return data;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(expectedId, e);
        }
    }

    private void restoreAttributes(InputStream is, int size, SessionData data) throws Exception {
        if (size > 0) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CustomObjectInputStream ois = new CustomObjectInputStream(is);
            for (int i = 0; i < size; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                attributes.put(key, value);
            }
            data.putAllAttributes(attributes);
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        super.doInitialize();
        this.initializeStore();
    }

    @Override
    protected void doDestroy() {
        this.sessionFileMap.clear();
        this.lastSweepTime = 0L;
        super.doDestroy();
    }

    private void initializeStore() throws Exception {
        if (this.storeDir == null) {
            throw new IllegalStateException("No file store specified");
        }
        if (!this.storeDir.exists()) {
            this.storeDir.mkdirs();
        } else {
            if (!(this.storeDir.isDirectory() && this.storeDir.canWrite() && this.storeDir.canRead())) {
                throw new IllegalStateException(this.storeDir.getAbsolutePath() + " must be readable/writable directory");
            }
            MultiException me = new MultiException();
            long now = System.currentTimeMillis();
            Files.walk(this.storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> this.isSessionFilename(p.getFileName().toString())).forEach(p -> {
                String existing;
                String filename;
                String sessionId;
                try {
                    this.sweepFile(now, (Path)p);
                }
                catch (Exception x) {
                    me.add(x);
                }
                if (Files.exists(p, new LinkOption[0]) && (sessionId = this.getIdFromFilename(filename = p.getFileName().toString())) != null && (existing = this.sessionFileMap.putIfAbsent(sessionId, filename)) != null) {
                    try {
                        long existingExpiry = this.getExpiryFromFilename(existing);
                        long thisExpiry = this.getExpiryFromFilename(filename);
                        if (thisExpiry > existingExpiry) {
                            Path existingPath = this.storeDir.toPath().resolve(existing);
                            this.sessionFileMap.put(sessionId, filename);
                            Files.delete(existingPath);
                            if (log.isDebugEnabled()) {
                                log.debug("Replaced " + existing + " with " + filename);
                            }
                        } else {
                            Files.delete(p);
                            if (log.isDebugEnabled()) {
                                log.debug("Deleted expired session file " + filename);
                            }
                        }
                    }
                    catch (IOException e) {
                        me.add(e);
                    }
                }
            });
            me.ifExceptionThrow();
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("storeDir", this.storeDir);
        tsb.append("deleteUnrestorableFiles", this.deleteUnrestorableFiles);
        return tsb.toString();
    }
}

