/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionInactivityTimer;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Locker;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Session {
    private static final Log log = LogFactory.getLog(Session.class);
    private final Locker locker = new Locker();
    private final SessionHandler sessionHandler;
    private final String id;
    private SessionData sessionData;
    private SessionInactivityTimer sessionInactivityTimer;
    private boolean newSession;
    private boolean resident;
    private int requests;
    private State state = State.VALID;

    protected Session(SessionHandler sessionHandler, SessionData sessionData) {
        this(sessionHandler, sessionData, false);
    }

    protected Session(SessionHandler sessionHandler, SessionData sessionData, boolean newSession) {
        this.sessionHandler = sessionHandler;
        this.id = sessionData.getId();
        this.sessionData = sessionData;
        this.newSession = newSession;
        if (newSession) {
            this.sessionData.setDirty(true);
            this.requests = 1;
        }
    }

    public String getId() {
        return this.id;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    protected SessionScope getSessionScope() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            SessionScope sessionScope = this.sessionData.getSessionScope();
            return sessionScope;
        }
    }

    public <T> T getAttribute(String name) {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            Object t = this.sessionData.getAttribute(name);
            return t;
        }
    }

    public void setAttribute(String name, Object value) {
        Object old;
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForWrite();
            old = this.sessionData.setAttribute(name, value);
        }
        if (value == null && old == null) {
            return;
        }
        this.sessionHandler.sessionAttributeChanged(this, name, old, value);
    }

    public Collection<String> getAttributeNames() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            Collection<String> collection = this.sessionData.getAttributeNames();
            return collection;
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public long getCreationTime() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            long l = this.sessionData.getCreationTime();
            return l;
        }
    }

    public long getLastAccessedTime() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            long l = this.sessionData.getLastAccessedTime();
            return l;
        }
    }

    public int getMaxInactiveInterval() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            if (this.sessionData.getMaxInactiveInterval() > 0L) {
                int n = (int)(this.sessionData.getMaxInactiveInterval() / 1000L);
                return n;
            }
            int n = -1;
            return n;
        }
    }

    public void setMaxInactiveInterval(int secs) {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.sessionData.setMaxInactiveInterval((long)secs * 1000L);
            this.sessionData.calcAndSetExpiryTime();
            this.sessionData.setDirty(true);
            this.updateInactivityTimer();
            if (log.isDebugEnabled()) {
                if (secs <= 0) {
                    log.debug("Session " + this.id + " is now immortal (maxInactiveInterval=" + secs + ")");
                } else {
                    log.debug("Session " + this.id + " maxInactiveInterval=" + secs);
                }
            }
        }
    }

    public void updateInactivityTimer() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            if (log.isDebugEnabled()) {
                log.debug("updateInactivityTimer");
            }
            long maxInactive = this.sessionData.getMaxInactiveInterval();
            int evictionPolicy = this.sessionHandler.getSessionCache().getEvictionPolicy();
            if (maxInactive <= 0L) {
                if (evictionPolicy < 1) {
                    this.setInactivityTimer(-1L);
                    if (log.isDebugEnabled()) {
                        log.debug("Session is immortal && no inactivity eviction: timer cancelled");
                    }
                } else {
                    this.setInactivityTimer(TimeUnit.SECONDS.toMillis(evictionPolicy));
                    if (log.isDebugEnabled()) {
                        log.debug("Session is immortal; evict after " + evictionPolicy + " sec inactivity");
                    }
                }
            } else if (evictionPolicy < 1) {
                this.setInactivityTimer(this.sessionData.getMaxInactiveInterval());
                if (log.isDebugEnabled()) {
                    log.debug("No inactive session eviction");
                }
            } else {
                this.setInactivityTimer(Math.min(maxInactive, TimeUnit.SECONDS.toMillis(evictionPolicy)));
                if (log.isDebugEnabled()) {
                    log.debug("Inactivity timer set to lesser of maxInactive=" + maxInactive + " and inactivityEvict=" + evictionPolicy);
                }
            }
        }
    }

    private void setInactivityTimer(long ms) {
        if (this.sessionInactivityTimer == null) {
            this.sessionInactivityTimer = new SessionInactivityTimer(this.sessionHandler.getScheduler(), this);
        }
        this.sessionInactivityTimer.setIdleTimeout(ms);
    }

    protected void stopInactivityTimer() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            if (this.sessionInactivityTimer != null) {
                this.sessionInactivityTimer.setIdleTimeout(-1L);
                this.sessionInactivityTimer = null;
                if (log.isDebugEnabled()) {
                    log.debug("Session inactivity timer stopped");
                }
            }
        }
    }

    public void invalidate() {
        this.sessionHandler.invalidate(this.id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean beginInvalidate() {
        boolean result = false;
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            switch (this.state) {
                case INVALID: {
                    throw new IllegalStateException();
                }
                case VALID: {
                    this.state = State.INVALIDATING;
                    result = true;
                    return result;
                }
                default: {
                    if (!log.isDebugEnabled()) return result;
                    log.debug("Session " + this.id + " already being invalidated");
                    return result;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishInvalidate() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Invalidate session " + this);
                }
                if (this.state == State.VALID || this.state == State.INVALIDATING) {
                    Set<String> keys;
                    SessionScope sessionScope = this.sessionData.getSessionScope();
                    sessionScope.destroy();
                    do {
                        keys = this.sessionData.getKeys();
                        for (String key : keys) {
                            Object old = this.sessionData.setAttribute(key, null);
                            if (old == null) continue;
                            this.sessionHandler.sessionAttributeChanged(this, key, old, null);
                        }
                    } while (!keys.isEmpty());
                }
            }
            finally {
                this.state = State.INVALID;
            }
        }
    }

    public boolean isNew() throws IllegalStateException {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            boolean bl = this.newSession;
            return bl;
        }
    }

    public boolean isValid() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            boolean bl = this.state == State.VALID;
            return bl;
        }
    }

    protected boolean isResident() {
        return this.resident;
    }

    protected void setResident(boolean resident) {
        this.resident = resident;
    }

    protected boolean isExpiredAt(long time) {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            this.checkValidForRead();
            boolean bl = this.sessionData.isExpiredAt(time);
            return bl;
        }
    }

    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            boolean bl = this.sessionData.getAccessedTime() + (long)(sec * 1000) <= now;
            return bl;
        }
    }

    protected void checkValidForWrite() throws IllegalStateException {
        this.checkLocked();
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: session " + this);
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: session " + this);
        }
    }

    protected void checkValidForRead() throws IllegalStateException {
        this.checkLocked();
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: session " + this);
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: session " + this);
        }
    }

    protected void checkLocked() throws IllegalStateException {
        if (!this.locker.isLocked()) {
            throw new IllegalStateException("Session not locked");
        }
    }

    public Locker.Lock lock() {
        return this.locker.lock();
    }

    public Locker.Lock lockIfNotHeld() {
        return this.locker.lockIfNotHeld();
    }

    protected boolean access(long time) {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            if (!this.isValid()) {
                boolean bl = false;
                return bl;
            }
            this.newSession = false;
            long lastAccessedTime = this.sessionData.getAccessedTime();
            if (this.sessionInactivityTimer != null) {
                this.sessionInactivityTimer.notIdle();
            }
            this.sessionData.setAccessedTime(time);
            this.sessionData.setLastAccessedTime(lastAccessedTime);
            this.sessionData.calcAndSetExpiryTime(time);
            if (this.isExpiredAt(time)) {
                this.invalidate();
                boolean bl = false;
                return bl;
            }
            ++this.requests;
            boolean bl = true;
            return bl;
        }
    }

    protected void complete() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            --this.requests;
        }
    }

    public long getRequests() {
        try (Locker.Lock ignored = this.locker.lockIfNotHeld();){
            long l = this.requests;
            return l;
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.getId());
        tsb.append("state", (Object)this.state);
        tsb.append("requests", this.requests);
        tsb.append("resident", this.resident);
        tsb.append("newSession", this.newSession);
        tsb.append("sessionData", this.sessionData);
        return tsb.toString();
    }

    public static enum State {
        VALID,
        INVALID,
        INVALIDATING;

    }
}

