/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionHandler;
import java.util.Collections;
import java.util.Enumeration;

public class SessionAgent {
    private final SessionHandler sessionHandler;
    private final String id;
    private Session session;

    public SessionAgent(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
        this.id = sessionHandler.newSessionId(this.hashCode());
    }

    public String getId() {
        return this.id;
    }

    public boolean isNew() {
        return this.getSession(true).isNew();
    }

    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int secs) {
        this.getSession(true).setMaxInactiveInterval(secs);
    }

    public Enumeration<String> getAttributeNames() {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return Collections.enumeration(session.getAttributeNames());
    }

    public <T> T getAttribute(String name) {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.getSession(true).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public void invalidate() {
        Session session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public SessionScope getSessionScope() {
        return this.getSession(true).getSessionScope();
    }

    public void access() {
        Session session = this.getSession(false);
        if (session == null) {
            return;
        }
        this.sessionHandler.access(session);
    }

    public void complete() {
        Session session = this.getSession(false);
        if (session == null) {
            return;
        }
        this.sessionHandler.complete(session);
    }

    public Session getSession(boolean create) {
        if (this.session != null) {
            if (!this.session.isValid()) {
                this.session = null;
            } else {
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        this.session = this.sessionHandler.newSession(this.id);
        return this.session;
    }
}

