/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.core.util.ToStringBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = -6253355753257200708L;
    private final String id;
    private final Map<String, Object> attributes;
    private final SessionScope sessionScope;
    private final long creationTime;
    private long accessedTime;
    private long lastAccessedTime;
    private long maxInactiveIntervalMS;
    private long expiryTime;
    private boolean dirty;
    private long lastSaved;

    public SessionData(String id, long creationTime, long accessedTime, long lastAccessedTime, long maxInactiveIntervalMS) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
        this.creationTime = creationTime;
        this.accessedTime = accessedTime;
        this.lastAccessedTime = lastAccessedTime;
        this.maxInactiveIntervalMS = maxInactiveIntervalMS;
        this.calcAndSetExpiryTime(creationTime);
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.sessionScope = new SessionScope();
    }

    public String getId() {
        return this.id;
    }

    public SessionScope getSessionScope() {
        return this.sessionScope;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public <T> T setAttribute(String name, Object value) {
        Object old = value == null ? this.attributes.remove(name) : this.attributes.put(name, value);
        if (value == null && old == null) {
            return null;
        }
        this.dirty = true;
        return (T)old;
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Map<String, Object> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void putAllAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public void clearAllAttributes() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getAccessedTime() {
        return this.accessedTime;
    }

    public void setAccessedTime(long accessedTime) {
        this.accessedTime = accessedTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getMaxInactiveInterval() {
        return this.maxInactiveIntervalMS;
    }

    public void setMaxInactiveInterval(long maxInactiveInterval) {
        this.maxInactiveIntervalMS = maxInactiveInterval;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long calcExpiryTime() {
        return this.calcExpiryTime(System.currentTimeMillis());
    }

    public long calcExpiryTime(long time) {
        return this.maxInactiveIntervalMS <= 0L ? 0L : time + this.maxInactiveIntervalMS;
    }

    public void calcAndSetExpiryTime() {
        this.setExpiryTime(this.calcExpiryTime());
    }

    public void calcAndSetExpiryTime(long time) {
        this.setExpiryTime(this.calcExpiryTime(time));
    }

    public boolean isExpiredAt(long time) {
        if (this.maxInactiveIntervalMS <= 0L) {
            return false;
        }
        return this.expiryTime <= time;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getLastSaved() {
        return this.lastSaved;
    }

    public void setLastSaved(long lastSaved) {
        this.lastSaved = lastSaved;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.getId());
        tsb.append("createdTime", this.getCreationTime());
        tsb.append("accessedTime", this.getLastAccessedTime());
        tsb.append("lastAccessedTime", this.getLastAccessedTime());
        tsb.append("maxInactiveInterval", this.getMaxInactiveInterval());
        tsb.append("expiryTime", this.getExpiryTime());
        return tsb.toString();
    }
}

