/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class SessionIdGenerator {
    private static final Log log = LogFactory.getLog(SessionIdGenerator.class);
    private static final AtomicLong counter = new AtomicLong();
    private final String groupName;
    private Random random;
    private boolean weakRandom;

    public SessionIdGenerator(String groupName) {
        this.groupName = groupName;
        this.initRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(long seedTerm) {
        Random random = this.random;
        synchronized (random) {
            long r1;
            long r0 = this.weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this.random.nextInt() ^ seedTerm << 32 : this.random.nextLong();
            if (r0 < 0L) {
                r0 = -r0;
            }
            if ((r1 = this.weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this.random.nextInt() ^ seedTerm << 32 : this.random.nextLong()) < 0L) {
                r1 = -r1;
            }
            StringBuilder id = new StringBuilder();
            if (!StringUtils.isEmpty(this.groupName)) {
                id.append(this.groupName);
            }
            id.append(Long.toString(r0, 36));
            id.append(Long.toString(r1, 36));
            id.append(counter.getAndIncrement());
            return id.toString();
        }
    }

    private void initRandom() {
        try {
            this.random = new SecureRandom();
        }
        catch (Exception e) {
            log.warn("Could not generate SecureRandom for session-id randomness", e);
            this.random = new Random();
            this.weakRandom = true;
        }
    }
}

