/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.IdleTimeout;
import com.aspectran.core.util.thread.Scheduler;

public class SessionInactivityTimer
extends IdleTimeout {
    private static final Log log = LogFactory.getLog(SessionInactivityTimer.class);
    private final Session session;

    public SessionInactivityTimer(Scheduler scheduler, Session session) {
        super(scheduler);
        this.session = session;
    }

    @Override
    public boolean isValid() {
        return this.session.isValid() && this.session.isResident();
    }

    @Override
    public void idleExpired() {
        if (this.session.getRequests() <= 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Timer expired for session " + this.session.getId());
            }
            this.session.invalidate();
        }
    }
}

