/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.template;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class TemplateRuleRegistry
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(TemplateRuleRegistry.class);
    private final Map<String, TemplateRule> templateRuleMap = new LinkedHashMap<String, TemplateRule>();
    private AssistantLocal assistantLocal;

    public void setAssistantLocal(AssistantLocal assistantLocal) {
        this.assistantLocal = assistantLocal;
    }

    public Collection<TemplateRule> getTemplateRules() {
        return this.templateRuleMap.values();
    }

    public TemplateRule getTemplateRule(String templateId) {
        return this.templateRuleMap.get(templateId);
    }

    public boolean contains(String templateId) {
        return this.templateRuleMap.containsKey(templateId);
    }

    public void addTemplateRule(TemplateRule templateRule) throws IllegalRuleException {
        DefaultSettings defaultSettings;
        if (templateRule.getEngine() == null && this.assistantLocal != null && (defaultSettings = this.assistantLocal.getDefaultSettings()) != null && defaultSettings.getDefaultTemplateEngineBean() != null) {
            templateRule.setEngineBeanId(defaultSettings.getDefaultTemplateEngineBean());
            templateRule.setTemplateSource(templateRule.getTemplateSource());
        }
        if (this.assistantLocal != null) {
            this.assistantLocal.getAssistant().resolveBeanClass(templateRule);
        }
        this.templateRuleMap.put(templateRule.getId(), templateRule);
        if (log.isTraceEnabled()) {
            log.trace("add TemplateRule " + templateRule);
        }
    }

    private void clear() {
        this.templateRuleMap.clear();
    }

    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doDestroy() {
        this.clear();
    }
}

