/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.DefaultActivity;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.ContextBeanRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.template.ContextTemplateRenderer;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.ContextEnvironment;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.support.i18n.message.DelegatingMessageSource;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;

public class AspectranActivityContext
extends AbstractComponent
implements ActivityContext {
    private static final Log log = LogFactory.getLog(AspectranActivityContext.class);
    private final ThreadLocal<Activity> currentActivityHolder = new ThreadLocal();
    private final ContextEnvironment contextEnvironment;
    private final Activity defaultActivity;
    private String description;
    private CoreService rootService;
    private AspectRuleRegistry aspectRuleRegistry;
    private ContextBeanRegistry contextBeanRegistry;
    private ContextTemplateRenderer contextTemplateRenderer;
    private ScheduleRuleRegistry scheduleRuleRegistry;
    private TransletRuleRegistry transletRuleRegistry;
    private MessageSource messageSource;

    public AspectranActivityContext(ContextEnvironment contextEnvironment) {
        this.contextEnvironment = contextEnvironment;
        this.defaultActivity = new DefaultActivity(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Environment getEnvironment() {
        return this.contextEnvironment;
    }

    @Override
    public CoreService getRootService() {
        return this.rootService;
    }

    @Override
    public void setRootService(CoreService rootService) {
        if (this.isInitialized()) {
            throw new IllegalStateException("ActivityContext is already initialized");
        }
        this.rootService = rootService;
    }

    @Override
    public AspectRuleRegistry getAspectRuleRegistry() {
        return this.aspectRuleRegistry;
    }

    public void setAspectRuleRegistry(AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
    }

    @Override
    public BeanRegistry getBeanRegistry() {
        return this.contextBeanRegistry;
    }

    public void setContextBeanRegistry(ContextBeanRegistry contextBeanRegistry) {
        this.contextBeanRegistry = contextBeanRegistry;
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.contextTemplateRenderer;
    }

    public void setContextTemplateRenderer(ContextTemplateRenderer contextTemplateRenderer) {
        this.contextTemplateRenderer = contextTemplateRenderer;
    }

    @Override
    public ScheduleRuleRegistry getScheduleRuleRegistry() {
        return this.scheduleRuleRegistry;
    }

    public void setScheduleRuleRegistry(ScheduleRuleRegistry scheduleRuleRegistry) {
        this.scheduleRuleRegistry = scheduleRuleRegistry;
    }

    @Override
    public TransletRuleRegistry getTransletRuleRegistry() {
        return this.transletRuleRegistry;
    }

    public void setTransletRuleRegistry(TransletRuleRegistry transletRuleRegistry) {
        this.transletRuleRegistry = transletRuleRegistry;
    }

    @Override
    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized");
        }
        return this.messageSource;
    }

    @Override
    public Activity getDefaultActivity() {
        return this.defaultActivity;
    }

    @Override
    public Activity getCurrentActivity() {
        Activity activity = this.currentActivityHolder.get();
        return activity != null ? activity : this.getDefaultActivity();
    }

    @Override
    public void setCurrentActivity(Activity activity) {
        this.currentActivityHolder.set(activity);
    }

    @Override
    public void removeCurrentActivity() {
        this.currentActivityHolder.remove();
    }

    private void initMessageSource() {
        if (this.contextBeanRegistry.containsBean("messageSource")) {
            this.messageSource = this.contextBeanRegistry.getBean("messageSource", MessageSource.class);
            if (log.isDebugEnabled()) {
                log.debug("Using MessageSource [" + this.messageSource + "]");
            }
        } else {
            this.messageSource = new DelegatingMessageSource();
            if (log.isDebugEnabled()) {
                log.debug("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]");
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.aspectRuleRegistry != null) {
            this.aspectRuleRegistry.initialize();
        }
        if (this.contextBeanRegistry != null) {
            this.contextBeanRegistry.initialize();
        }
        if (this.contextTemplateRenderer != null) {
            this.contextTemplateRenderer.initialize();
        }
        if (this.scheduleRuleRegistry != null) {
            this.scheduleRuleRegistry.initialize();
        }
        if (this.transletRuleRegistry != null) {
            this.transletRuleRegistry.initialize();
        }
        if (this.contextBeanRegistry != null) {
            this.initMessageSource();
        }
    }

    @Override
    protected void doDestroy() {
        if (this.transletRuleRegistry != null) {
            this.transletRuleRegistry.destroy();
            this.transletRuleRegistry = null;
        }
        if (this.scheduleRuleRegistry != null) {
            this.scheduleRuleRegistry.destroy();
            this.scheduleRuleRegistry = null;
        }
        if (this.contextTemplateRenderer != null) {
            this.contextTemplateRenderer.destroy();
            this.contextTemplateRenderer = null;
        }
        if (this.contextBeanRegistry != null) {
            this.contextBeanRegistry.destroy();
            this.contextBeanRegistry = null;
        }
        if (this.aspectRuleRegistry != null) {
            this.aspectRuleRegistry.destroy();
            this.aspectRuleRegistry = null;
        }
    }
}

