/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder;

import com.aspectran.core.adapter.BasicApplicationAdapter;
import com.aspectran.core.component.Component;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.builder.AbstractActivityContextBuilder;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.env.ContextEnvironment;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.parser.HybridActivityContextParser;
import com.aspectran.core.service.AbstractCoreService;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.ShutdownHooks;
import java.util.concurrent.atomic.AtomicBoolean;

public class HybridActivityContextBuilder
extends AbstractActivityContextBuilder {
    private static final Log log = LogFactory.getLog(HybridActivityContextBuilder.class);
    private final AbstractCoreService coreService;
    private ActivityContext activityContext;
    private final AtomicBoolean active = new AtomicBoolean();
    private final Object buildDestroyMonitor = new Object();
    private ShutdownHooks.Task shutdownTask;

    public HybridActivityContextBuilder() {
        super(new BasicApplicationAdapter());
        this.coreService = null;
    }

    public HybridActivityContextBuilder(AbstractCoreService coreService) {
        super(coreService.getApplicationAdapter());
        this.coreService = coreService;
        this.setServiceController(coreService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(AspectranParameters aspectranParameters) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setAspectranParameters(aspectranParameters);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(String rootFile) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setRootFile(rootFile);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build() throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            return this.doBuild();
        }
    }

    private ActivityContext doBuild() throws ActivityContextBuilderException {
        try {
            if (this.active.get()) {
                throw new IllegalStateException("An ActivityContext already activated");
            }
            String rootFile = this.getRootFile();
            AspectranParameters aspectranParameters = this.getAspectranParameters();
            if (rootFile != null) {
                log.info("Building ActivityContext with " + rootFile);
            } else if (aspectranParameters != null) {
                log.info("Building ActivityContext with specified AspectranParameters");
            } else {
                log.info("No rootFile or aspectranParameters specified");
            }
            if (this.getActiveProfiles() != null) {
                log.info("Activating profiles [" + StringUtils.joinCommaDelimitedList(this.getActiveProfiles()) + "]");
            }
            if (this.getDefaultProfiles() != null) {
                log.info("Default profiles [" + StringUtils.joinCommaDelimitedList(this.getDefaultProfiles()) + "]");
            }
            long startTime = System.currentTimeMillis();
            ContextEnvironment contextEnvironment = this.createContextEnvironment();
            ContextRuleAssistant assistant = new ContextRuleAssistant(contextEnvironment);
            assistant.ready();
            if (this.getBasePackages() != null) {
                BeanRuleRegistry beanRuleRegistry = assistant.getBeanRuleRegistry();
                beanRuleRegistry.scanConfigurableBeans(this.getBasePackages());
            }
            if (rootFile != null || aspectranParameters != null) {
                HybridActivityContextParser parser = new HybridActivityContextParser(assistant);
                parser.setEncoding(this.getEncoding());
                parser.setHybridLoad(this.isHybridLoad());
                if (rootFile != null) {
                    parser.parse(rootFile);
                } else {
                    parser.parse(aspectranParameters);
                }
                assistant = parser.getContextRuleAssistant();
                assistant.clearCurrentRuleAppender();
            }
            this.activityContext = this.createActivityContext(assistant);
            assistant.release();
            if (this.coreService != null) {
                this.coreService.setActivityContext(this.activityContext);
                this.activityContext.setRootService(this.coreService);
            }
            ((Component)((Object)this.activityContext)).initialize();
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.info("ActivityContext build completed in " + elapsedTime + " ms");
            if (this.coreService == null) {
                this.registerDestroyTask();
            } else {
                this.startReloadingTimer();
            }
            this.active.set(true);
            return this.activityContext;
        }
        catch (Exception e) {
            throw new ActivityContextBuilderException("Failed to build ActivityContext", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.doDestroy();
            this.removeDestroyTask();
        }
    }

    private void doDestroy() {
        if (this.active.get()) {
            this.stopReloadingTimer();
            this.getApplicationAdapter().getApplicationScope().destroy();
            if (this.activityContext != null) {
                ((Component)((Object)this.activityContext)).destroy();
                this.activityContext = null;
            }
            if (this.coreService != null) {
                this.coreService.setActivityContext(null);
            }
            this.active.set(false);
        }
    }

    private void registerDestroyTask() {
        if (this.shutdownTask == null) {
            this.shutdownTask = ShutdownHooks.add(() -> {
                Object object = this.buildDestroyMonitor;
                synchronized (object) {
                    this.doDestroy();
                    this.removeDestroyTask();
                }
            });
        }
    }

    private void removeDestroyTask() {
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
            this.shutdownTask = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }
}

