/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.config.SessionConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.ParameterDefinition;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AspectranConfig
extends AbstractParameters {
    public static final String BASE_PATH_PROPERTY_NAME = "aspectran.basePath";
    public static final String DEFAULT_ASPECTRAN_CONFIG_FILE = "aspectran-config.apon";
    public static final String DEFAULT_APP_CONFIG_ROOT_FILE = "classpath:app-config.xml";
    private static final ParameterDefinition context = new ParameterDefinition("context", ContextConfig.class);
    private static final ParameterDefinition session = new ParameterDefinition("session", SessionConfig.class);
    private static final ParameterDefinition scheduler = new ParameterDefinition("scheduler", SchedulerConfig.class);
    private static final ParameterDefinition daemon = new ParameterDefinition("daemon", DaemonConfig.class);
    private static final ParameterDefinition shell = new ParameterDefinition("shell", ShellConfig.class);
    private static final ParameterDefinition web = new ParameterDefinition("web", WebConfig.class);
    private static final ParameterDefinition[] parameterDefinitions = new ParameterDefinition[]{context, session, scheduler, daemon, shell, web};

    public AspectranConfig() {
        super(parameterDefinitions);
    }

    public AspectranConfig(String text) throws AponParseException {
        this();
        this.readFrom(text);
    }

    public AspectranConfig(File configFile) throws AponParseException {
        this();
        AponReader.parse(configFile, this);
    }

    public AspectranConfig(Reader reader) throws AponParseException {
        this();
        AponReader.parse(reader, this);
    }

    public ContextConfig getContextConfig() {
        return (ContextConfig)this.getParameters(context);
    }

    public ContextConfig newContextConfig() {
        return (ContextConfig)this.newParameters(context);
    }

    public ContextConfig touchContextConfig() {
        return (ContextConfig)this.touchParameters(context);
    }

    public boolean hasContextConfig() {
        return this.hasValue(context);
    }

    public SessionConfig getSessionConfig() {
        return (SessionConfig)this.getParameters(session);
    }

    public SessionConfig newSessionConfig() {
        return (SessionConfig)this.newParameters(session);
    }

    public SessionConfig touchSessionConfig() {
        return (SessionConfig)this.touchParameters(session);
    }

    public SchedulerConfig getSchedulerConfig() {
        return (SchedulerConfig)this.getParameters(scheduler);
    }

    public SchedulerConfig newSchedulerConfig() {
        return (SchedulerConfig)this.newParameters(scheduler);
    }

    public SchedulerConfig touchSchedulerConfig() {
        return (SchedulerConfig)this.touchParameters(scheduler);
    }

    public DaemonConfig getDaemonConfig() {
        return (DaemonConfig)this.getParameters(daemon);
    }

    public DaemonConfig newDaemonConfig() {
        return (DaemonConfig)this.newParameters(daemon);
    }

    public DaemonConfig touchDaemonConfig() {
        return (DaemonConfig)this.touchParameters(daemon);
    }

    public ShellConfig getShellConfig() {
        return (ShellConfig)this.getParameters(shell);
    }

    public ShellConfig newShellConfig() {
        return (ShellConfig)this.newParameters(shell);
    }

    public ShellConfig touchShellConfig() {
        return (ShellConfig)this.touchParameters(shell);
    }

    public WebConfig getWebConfig() {
        return (WebConfig)this.getParameters(web);
    }

    public WebConfig newWebConfig() {
        return (WebConfig)this.newParameters(web);
    }

    public WebConfig touchWebConfig() {
        return (WebConfig)this.touchParameters(web);
    }

    public static String determineBasePath(String[] args) {
        if (args == null || args.length < 2) {
            return SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
        }
        return args[0];
    }

    public static File determineAspectranConfigFile(String[] args) {
        File file;
        if (args == null || args.length == 0) {
            String baseDir = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            file = baseDir != null ? new File(baseDir, DEFAULT_ASPECTRAN_CONFIG_FILE) : new File(DEFAULT_ASPECTRAN_CONFIG_FILE);
        } else if (args.length == 1) {
            String baseDir = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            if (baseDir != null) {
                Path basePath = Paths.get(baseDir, new String[0]);
                Path filePath = Paths.get(args[0], new String[0]);
                file = filePath.startsWith(basePath) && filePath.isAbsolute() ? filePath.toFile() : new File(baseDir, args[0]);
            } else {
                file = new File(args[0]);
            }
        } else {
            file = new File(args[0], args[1]);
        }
        return file;
    }
}

