/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextAutoReloadConfig;
import com.aspectran.core.context.config.ContextProfilesConfig;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterDefinition;
import com.aspectran.core.util.apon.ParameterValueType;

public class ContextConfig
extends AbstractParameters {
    private static final ParameterDefinition base = new ParameterDefinition("base", ParameterValueType.STRING);
    private static final ParameterDefinition root = new ParameterDefinition("root", ParameterValueType.STRING);
    private static final ParameterDefinition encoding = new ParameterDefinition("encoding", ParameterValueType.STRING);
    private static final ParameterDefinition resources = new ParameterDefinition("resources", ParameterValueType.STRING, true);
    private static final ParameterDefinition scan = new ParameterDefinition("scan", ParameterValueType.STRING, true);
    private static final ParameterDefinition profiles = new ParameterDefinition("profiles", ContextProfilesConfig.class);
    private static final ParameterDefinition hybridLoad = new ParameterDefinition("hybridLoad", ParameterValueType.BOOLEAN);
    private static final ParameterDefinition autoReload = new ParameterDefinition("autoReload", ContextAutoReloadConfig.class);
    private static final ParameterDefinition singleton = new ParameterDefinition("singleton", ParameterValueType.BOOLEAN);
    private static final ParameterDefinition parameters = new ParameterDefinition("parameters", AspectranParameters.class);
    private static final ParameterDefinition[] parameterDefinitions = new ParameterDefinition[]{base, root, encoding, resources, scan, profiles, hybridLoad, autoReload, singleton, parameters};

    public ContextConfig() {
        super(parameterDefinitions);
    }

    public String getBasePath() {
        return this.getString(base);
    }

    public ContextConfig setBasePath(String basePath) {
        this.putValue(base, (Object)basePath);
        return this;
    }

    public String getRootFile() {
        return this.getString(root);
    }

    public ContextConfig setRootFile(String rootFile) {
        this.putValue(root, (Object)rootFile);
        return this;
    }

    public String getEncoding() {
        return this.getString(encoding);
    }

    public ContextConfig setEncoding(String encoding) {
        this.putValue(ContextConfig.encoding, (Object)encoding);
        return this;
    }

    public String[] getResourceLocations() {
        return this.getStringArray(resources);
    }

    public ContextConfig addResourceLocation(String resourceLocation) {
        this.putValue(resources, (Object)resourceLocation);
        return this;
    }

    public String[] getBasePackages() {
        return this.getStringArray(scan);
    }

    public ContextConfig addBasePackage(String basePackage) {
        this.putValue(scan, (Object)basePackage);
        return this;
    }

    public ContextProfilesConfig getProfilesConfig() {
        return (ContextProfilesConfig)this.getParameters(profiles);
    }

    public ContextProfilesConfig newProfilesConfig() {
        return (ContextProfilesConfig)this.newParameters(profiles);
    }

    public ContextProfilesConfig touchProfilesConfig() {
        return (ContextProfilesConfig)this.touchParameters(profiles);
    }

    public boolean hasProfilesConfig() {
        return this.hasValue(profiles);
    }

    public boolean isHybridLoad() {
        return this.getBoolean(hybridLoad, false);
    }

    public ContextConfig setHybridLoad(boolean hybridLoad) {
        this.putValue(ContextConfig.hybridLoad, (Object)hybridLoad);
        return this;
    }

    public ContextAutoReloadConfig getAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.getParameters(autoReload);
    }

    public ContextAutoReloadConfig newAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.newParameters(autoReload);
    }

    public ContextAutoReloadConfig touchAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.touchParameters(autoReload);
    }

    public boolean isSingleton() {
        return this.getBoolean(singleton, false);
    }

    public ContextConfig setSingleton(boolean singleton) {
        this.putValue(ContextConfig.singleton, (Object)singleton);
        return this;
    }

    public AspectranParameters getAspectranParameters() {
        return (AspectranParameters)this.getParameters(parameters);
    }

    public AspectranParameters newAspectranParameters() {
        return (AspectranParameters)this.newParameters(parameters);
    }

    public AspectranParameters touchAspectranParameters() {
        return (AspectranParameters)this.touchParameters(parameters);
    }

    public boolean hasAspectranParameters() {
        return this.hasValue(parameters);
    }
}

