/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterDefinition;
import com.aspectran.core.util.apon.ParameterValueType;

public class DaemonPollerConfig
extends AbstractParameters {
    private static final ParameterDefinition pollingInterval = new ParameterDefinition("pollingInterval", ParameterValueType.LONG);
    private static final ParameterDefinition maxThreads = new ParameterDefinition("maxThreads", ParameterValueType.INT);
    private static final ParameterDefinition inbound = new ParameterDefinition("inbound", ParameterValueType.STRING);
    private static final ParameterDefinition requeue = new ParameterDefinition("requeue", ParameterValueType.BOOLEAN);
    private static final ParameterDefinition[] parameterDefinitions = new ParameterDefinition[]{pollingInterval, maxThreads, inbound, requeue};

    public DaemonPollerConfig() {
        super(parameterDefinitions);
    }

    public long getPollingInterval(long defaultPollingInterval) {
        return this.getLong(pollingInterval, defaultPollingInterval);
    }

    public DaemonPollerConfig setPollingInterval(long pollingInterval) {
        this.putValue(DaemonPollerConfig.pollingInterval, (Object)pollingInterval);
        return this;
    }

    public int getMaxThreads(int defaultMaxThreads) {
        return this.getInt(maxThreads, defaultMaxThreads);
    }

    public DaemonPollerConfig setMaxThreads(int maxThreads) {
        this.putValue(DaemonPollerConfig.maxThreads, (Object)maxThreads);
        return this;
    }

    public String getInboundPath() {
        return this.getString(inbound);
    }

    public String getInboundPath(String defaultInboundPath) {
        return this.getString(inbound, defaultInboundPath);
    }

    public DaemonPollerConfig setInboundPath(String inboundPath) {
        this.putValue(inbound, (Object)inboundPath);
        return this;
    }

    public boolean isRequeue() {
        return this.getBoolean(requeue, false);
    }

    public DaemonPollerConfig setRequeue(boolean requeue) {
        this.putValue(DaemonPollerConfig.requeue, (Object)requeue);
        return this;
    }
}

