/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.context.env.AbstractEnvironment;
import com.aspectran.core.context.resource.AspectranClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public class ContextEnvironment
extends AbstractEnvironment {
    private final ApplicationAdapter applicationAdapter;
    private ClassLoader classLoader;
    private String basePath;

    public ContextEnvironment(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return AspectranClassLoader.getDefaultClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public String toRealPath(String filePath) throws IOException {
        File file = this.toRealPathAsFile(filePath);
        return file.getCanonicalPath();
    }

    @Override
    public File toRealPathAsFile(String filePath) throws IOException {
        File file;
        if (filePath.startsWith("file:")) {
            URI uri = URI.create(filePath);
            file = new File(uri);
        } else if (filePath.startsWith("classpath:")) {
            URL url = this.getClassLoader().getResource(filePath);
            if (url == null) {
                throw new IOException("Could not find the resource with the given name: " + filePath);
            }
            file = new File(url.getFile());
        } else {
            file = this.basePath != null ? new File(this.basePath, filePath) : new File(filePath);
        }
        return file;
    }
}

