/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.expr.ItemEvaluationException;
import com.aspectran.core.context.expr.ItemEvaluator;
import com.aspectran.core.context.expr.TokenExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.util.LinkedMultiValueMap;
import com.aspectran.core.util.MultiValueMap;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ItemExpression
extends TokenExpression
implements ItemEvaluator {
    public ItemExpression(Activity activity) {
        super(activity);
    }

    @Override
    public Map<String, Object> evaluate(ItemRuleMap itemRuleMap) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        this.evaluate(itemRuleMap, valueMap);
        return valueMap;
    }

    @Override
    public void evaluate(ItemRuleMap itemRuleMap, Map<String, Object> valueMap) {
        for (ItemRule itemRule : itemRuleMap.values()) {
            valueMap.put(itemRule.getName(), this.evaluate(itemRule));
        }
    }

    @Override
    public <T> T evaluate(ItemRule itemRule) {
        try {
            ItemType itemType = itemRule.getType();
            ItemValueType valueType = itemRule.getValueType();
            String name = itemRule.getName();
            Object value = null;
            if (itemType == ItemType.SINGLE) {
                Token[] tokens = itemRule.getTokens();
                value = this.evaluate(name, tokens, valueType);
                if (value == null) {
                    value = itemRule.getDefaultValue();
                }
            } else if (itemType == ItemType.ARRAY) {
                value = this.evaluateAsArray(name, itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.LIST) {
                value = this.evaluateAsList(name, itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.SET) {
                value = this.evaluateAsSet(name, itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.MAP) {
                value = this.evaluateAsMap(name, itemRule.getTokensMap(), valueType);
            } else if (itemType == ItemType.PROPERTIES) {
                value = this.evaluateAsProperties(name, itemRule.getTokensMap(), valueType);
            }
            return (T)value;
        }
        catch (Exception e) {
            throw new ItemEvaluationException(itemRule, (Throwable)e);
        }
    }

    @Override
    public MultiValueMap<String, String> evaluateAsMultiValueMap(ItemRuleMap itemRuleMap) {
        return this.evaluateAsMultiValueMap(itemRuleMap.values());
    }

    @Override
    public MultiValueMap<String, String> evaluateAsMultiValueMap(Collection<ItemRule> itemRules) {
        LinkedMultiValueMap<String, String> valueMap = new LinkedMultiValueMap<String, String>();
        for (ItemRule itemRule : itemRules) {
            String[] values = this.evaluateAsStringArray(itemRule);
            valueMap.put(itemRule.getName(), (String[])values);
        }
        return valueMap;
    }

    @Override
    public ParameterMap evaluateAsParameterMap(ItemRuleMap itemRuleMap) {
        return this.evaluateAsParameterMap(itemRuleMap.values());
    }

    @Override
    public ParameterMap evaluateAsParameterMap(Collection<ItemRule> itemRules) {
        ParameterMap params = new ParameterMap();
        for (ItemRule itemRule : itemRules) {
            String[] values = this.evaluateAsStringArray(itemRule);
            params.put(itemRule.getName(), values);
        }
        return params;
    }

    @Override
    public String[] evaluateAsStringArray(ItemRule itemRule) {
        try {
            Properties properties;
            ItemType itemType = itemRule.getType();
            ItemValueType valueType = itemRule.getValueType();
            String name = itemRule.getName();
            if (itemType == ItemType.SINGLE) {
                Token[] tokens = itemRule.getTokens();
                Object value = this.evaluate(name, tokens, valueType);
                if (value != null) {
                    if (value instanceof String[]) {
                        return (String[])value;
                    }
                    return new String[]{value.toString()};
                }
            } else if (itemType == ItemType.ARRAY) {
                Object[] values = this.evaluateAsArray(name, itemRule.getTokensList(), valueType);
                if (values != null) {
                    if (values instanceof String[]) {
                        return (String[])values;
                    }
                    return (String[])Arrays.stream(values).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.LIST) {
                List<Object> list = this.evaluateAsList(name, itemRule.getTokensList(), valueType);
                if (list != null) {
                    return (String[])Arrays.stream(list.toArray()).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.SET) {
                Set<Object> set = this.evaluateAsSet(name, itemRule.getTokensList(), valueType);
                if (set != null) {
                    return (String[])Arrays.stream(set.toArray()).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.MAP) {
                Map<String, Object> map = this.evaluateAsMap(name, itemRule.getTokensMap(), valueType);
                if (map != null) {
                    return new String[]{map.toString()};
                }
            } else if (itemType == ItemType.PROPERTIES && (properties = this.evaluateAsProperties(name, itemRule.getTokensMap(), valueType)) != null) {
                return new String[]{properties.toString()};
            }
            return null;
        }
        catch (Exception e) {
            throw new ItemEvaluationException(itemRule, (Throwable)e);
        }
    }

    private Object evaluate(String name, Token[] tokens, ItemValueType valueType) throws Exception {
        Object value = this.evaluate(name, tokens);
        return value == null || valueType == null ? value : this.valuelize(value, valueType);
    }

    private Object[] evaluateAsArray(String name, List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        List<Object> list = this.evaluateAsList(name, tokensList, valueType);
        if (list == null) {
            return null;
        }
        if (valueType == ItemValueType.STRING) {
            return list.toArray(new String[0]);
        }
        if (valueType == ItemValueType.INT) {
            return list.toArray(new Integer[0]);
        }
        if (valueType == ItemValueType.LONG) {
            return list.toArray(new Long[0]);
        }
        if (valueType == ItemValueType.FLOAT) {
            return list.toArray(new Float[0]);
        }
        if (valueType == ItemValueType.DOUBLE) {
            return list.toArray(new Double[0]);
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return list.toArray(new Boolean[0]);
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return list.toArray(new Parameters[0]);
        }
        if (valueType == ItemValueType.FILE) {
            return list.toArray(new File[0]);
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return list.toArray(new FileParameter[0]);
        }
        return list.toArray(new Object[0]);
    }

    private List<Object> evaluateAsList(String name, List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        if (tokensList == null || tokensList.isEmpty()) {
            return this.getParameterAsList(name, valueType);
        }
        ArrayList<Object> valueList = new ArrayList<Object>(tokensList.size());
        for (Token[] tokens : tokensList) {
            Object value = this.evaluate(name, tokens);
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueList.add(value);
        }
        return valueList;
    }

    private Set<Object> evaluateAsSet(String name, List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        if (tokensList == null || tokensList.isEmpty()) {
            return this.getParameterAsSet(name, valueType);
        }
        HashSet<Object> valueSet = new HashSet<Object>();
        for (Token[] tokens : tokensList) {
            Object value = this.evaluate(name, tokens);
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueSet.add(value);
        }
        return valueSet;
    }

    private Map<String, Object> evaluateAsMap(String name, Map<String, Token[]> tokensMap, ItemValueType valueType) throws Exception {
        if (tokensMap == null || tokensMap.isEmpty()) {
            Object value = this.getParameter(name, valueType);
            if (value == null) {
                return null;
            }
            if (valueType != null) {
                value = this.valuelize(value, valueType);
            }
            LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
            valueMap.put(name, value);
            return valueMap;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.evaluate(entry.getKey(), entry.getValue());
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueMap.put(entry.getKey(), value);
        }
        return valueMap;
    }

    private Properties evaluateAsProperties(String name, Map<String, Token[]> tokensMap, ItemValueType valueType) throws Exception {
        if (tokensMap == null || tokensMap.isEmpty()) {
            Object value = this.getParameter(name, valueType);
            if (value == null) {
                return null;
            }
            if (valueType != null) {
                value = this.valuelize(value, valueType);
            }
            Properties prop = new Properties();
            prop.put(name, value);
            return prop;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.evaluate(entry.getKey(), entry.getValue());
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            if (value == null) continue;
            prop.put(entry.getKey(), value);
        }
        return prop;
    }

    private Object getParameter(String name, ItemValueType valueType) {
        if (valueType == ItemValueType.MULTIPART_FILE || valueType == ItemValueType.FILE) {
            return super.getFileParameter(name);
        }
        return super.getParameter(name);
    }

    private Object[] getParameterValues(String name, ItemValueType valueType) {
        if (valueType == ItemValueType.MULTIPART_FILE || valueType == ItemValueType.FILE) {
            return super.getFileParameterValues(name);
        }
        return super.getParameterValues(name);
    }

    private List<Object> getParameterAsList(String name, ItemValueType valueType) throws Exception {
        Object[] values = this.getParameterValues(name, valueType);
        if (values == null) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>(values.length);
        for (Object value : values) {
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueList.add(value);
        }
        return valueList;
    }

    private Set<Object> getParameterAsSet(String name, ItemValueType valueType) throws Exception {
        Object[] values = this.getParameterValues(name, valueType);
        if (values == null) {
            return null;
        }
        LinkedHashSet<Object> valueSet = new LinkedHashSet<Object>(values.length);
        for (Object value : values) {
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueSet.add(value);
        }
        return valueSet;
    }

    private Object valuelize(Object value, ItemValueType valueType) throws Exception {
        if (valueType == ItemValueType.STRING) {
            return value.toString();
        }
        if (valueType == ItemValueType.INT) {
            return value instanceof Integer ? value : Integer.valueOf(value.toString());
        }
        if (valueType == ItemValueType.LONG) {
            return value instanceof Long ? value : Long.valueOf(value.toString());
        }
        if (valueType == ItemValueType.FLOAT) {
            return value instanceof Float ? value : Float.valueOf(value.toString());
        }
        if (valueType == ItemValueType.DOUBLE) {
            return value instanceof Double ? value : Double.valueOf(value.toString());
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return value instanceof Boolean ? value : Boolean.valueOf(value.toString());
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return new VariableParameters(value.toString());
        }
        if (valueType == ItemValueType.FILE) {
            return value instanceof FileParameter ? value : new File(value.toString());
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return value instanceof FileParameter ? value : new FileParameter(new File(value.toString()));
        }
        return value;
    }
}

