/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.process.action.AnnotatedMethodAction;
import com.aspectran.core.activity.process.action.BeanMethodAction;
import com.aspectran.core.activity.process.action.EchoAction;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.action.HeaderAction;
import com.aspectran.core.context.rule.AnnotatedMethodActionRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.Collection;

public class AspectAdviceRule
implements ActionRuleApplicable {
    private final AspectRule aspectRule;
    private final String aspectId;
    private final String adviceBeanId;
    private final Class<?> adviceBeanClass;
    private final AspectAdviceType aspectAdviceType;
    private Executable action;
    private ExceptionRule exceptionRule;
    private ExceptionThrownRule exceptionThrownRule;

    public AspectAdviceRule(AspectRule aspectRule, AspectAdviceType aspectAdviceType) {
        this.aspectRule = aspectRule;
        this.aspectId = aspectRule.getId();
        this.adviceBeanId = aspectRule.getAdviceBeanId();
        this.adviceBeanClass = aspectRule.getAdviceBeanClass();
        this.aspectAdviceType = aspectAdviceType;
    }

    public String getAspectId() {
        return this.aspectId;
    }

    public AspectRule getAspectRule() {
        return this.aspectRule;
    }

    public String getAdviceBeanId() {
        return this.adviceBeanId;
    }

    public Class<?> getAdviceBeanClass() {
        return this.adviceBeanClass;
    }

    public AspectAdviceType getAspectAdviceType() {
        return this.aspectAdviceType;
    }

    @Override
    public Executable applyActionRule(BeanMethodActionRule beanMethodActionRule) {
        BeanMethodAction action = new BeanMethodAction(beanMethodActionRule);
        if (beanMethodActionRule.getBeanId() == null) {
            action.setAspectAdviceRule(this);
        }
        this.action = action;
        return action;
    }

    @Override
    public Executable applyActionRule(AnnotatedMethodActionRule annotatedMethodActionRule) {
        throw new UnsupportedOperationException("Cannot apply the annotated method action Rule to the Aspect Advice Rule");
    }

    @Override
    public Executable applyActionRule(IncludeActionRule includeActionRule) {
        throw new UnsupportedOperationException("Cannot apply the include action rule to the Aspect Advice Rule; AspectAdvice is not support IncludeAction");
    }

    @Override
    public Executable applyActionRule(EchoActionRule echoActionRule) {
        EchoAction action = new EchoAction(echoActionRule);
        this.action = action;
        return action;
    }

    @Override
    public Executable applyActionRule(HeaderActionRule headerActionRule) {
        HeaderAction action = new HeaderAction(headerActionRule);
        this.action = action;
        return action;
    }

    @Override
    public void applyActionRule(Executable action) {
        this.action = action;
    }

    @Override
    public void applyActionRule(Collection<Executable> actionList) {
        throw new UnsupportedOperationException();
    }

    public Executable getExecutableAction() {
        return this.action;
    }

    public void setExecutableAction(AnnotatedMethodAction action) {
        this.action = action;
    }

    public ActionType getActionType() {
        return this.action != null ? this.action.getActionType() : null;
    }

    public ExceptionRule getExceptionRule() {
        return this.exceptionRule;
    }

    public ExceptionThrownRule getExceptionThrownRule() {
        return this.exceptionThrownRule;
    }

    public void setExceptionThrownRule(ExceptionThrownRule exceptionThrownRule) {
        ExceptionRule exceptionRule = new ExceptionRule();
        exceptionRule.putExceptionThrownRule(exceptionThrownRule);
        this.exceptionRule = exceptionRule;
        this.exceptionThrownRule = exceptionThrownRule;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean preventRecursive) {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("aspectId", this.aspectId);
        tsb.append("adviceBeanId", this.adviceBeanId);
        tsb.append("adviceBeanClass", this.adviceBeanClass);
        tsb.append("aspectAdviceType", (Object)this.aspectAdviceType);
        if (!preventRecursive) {
            tsb.append("action", this.action);
        }
        return tsb.toString();
    }

    public static AspectAdviceRule newInstance(AspectRule aspectRule, AspectAdviceType aspectAdviceType) {
        return new AspectAdviceRule(aspectRule, aspectAdviceType);
    }
}

