/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.JoinpointRule;
import com.aspectran.core.context.rule.PointcutRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;

public class AspectRule
implements BeanReferenceable {
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.ASPECT_RULE;
    private String id;
    private int order = Integer.MAX_VALUE;
    private Boolean isolated;
    private Boolean disabled;
    private JoinpointRule joinpointRule;
    private Pointcut pointcut;
    private String adviceBeanId;
    private Class<?> adviceBeanClass;
    private SettingsAdviceRule settingsAdviceRule;
    private List<AspectAdviceRule> aspectAdviceRuleList;
    private ExceptionRule exceptionRule;
    private boolean beanRelevant;
    private String description;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Boolean getIsolated() {
        return this.isolated;
    }

    public boolean isIsolated() {
        return BooleanUtils.toBoolean(this.isolated);
    }

    public void setIsolated(Boolean isolated) {
        this.isolated = isolated;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return BooleanUtils.toBoolean(this.disabled);
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public JoinpointRule getJoinpointRule() {
        return this.joinpointRule;
    }

    public void setJoinpointRule(JoinpointRule joinpointRule) {
        this.joinpointRule = joinpointRule;
    }

    public JoinpointTargetType getJoinpointTargetType() {
        return this.joinpointRule != null ? this.joinpointRule.getJoinpointTargetType() : null;
    }

    public MethodType[] getMethods() {
        return this.joinpointRule != null ? this.joinpointRule.getMethods() : null;
    }

    public String[] getHeaders() {
        return this.joinpointRule != null ? this.joinpointRule.getHeaders() : null;
    }

    public PointcutRule getPointcutRule() {
        return this.joinpointRule != null ? this.joinpointRule.getPointcutRule() : null;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public String getAdviceBeanId() {
        return this.adviceBeanId;
    }

    public void setAdviceBeanId(String adviceBeanId) {
        this.adviceBeanId = adviceBeanId;
    }

    public Class<?> getAdviceBeanClass() {
        return this.adviceBeanClass;
    }

    public void setAdviceBeanClass(Class<?> adviceBeanClass) {
        this.adviceBeanClass = adviceBeanClass;
    }

    public SettingsAdviceRule getSettingsAdviceRule() {
        return this.settingsAdviceRule;
    }

    public void setSettingsAdviceRule(SettingsAdviceRule settingsAdviceRule) {
        this.settingsAdviceRule = settingsAdviceRule;
    }

    public SettingsAdviceRule touchSettingsAdviceRule() {
        if (this.settingsAdviceRule == null) {
            this.settingsAdviceRule = new SettingsAdviceRule(this);
        }
        return this.settingsAdviceRule;
    }

    public List<AspectAdviceRule> getAspectAdviceRuleList() {
        return this.aspectAdviceRuleList;
    }

    public void setAspectAdviceRuleList(List<AspectAdviceRule> aspectAdviceRuleList) {
        this.aspectAdviceRuleList = aspectAdviceRuleList;
    }

    public AspectAdviceRule touchAspectAdviceRule(AspectAdviceType aspectAdviceType) {
        if (aspectAdviceType == null) {
            throw new IllegalArgumentException("aspectAdviceType must not be null");
        }
        AspectAdviceRule aspectAdviceRule = new AspectAdviceRule(this, aspectAdviceType);
        this.touchAspectAdviceRuleList().add(aspectAdviceRule);
        return aspectAdviceRule;
    }

    private List<AspectAdviceRule> touchAspectAdviceRuleList() {
        if (this.aspectAdviceRuleList == null) {
            this.aspectAdviceRuleList = new ArrayList<AspectAdviceRule>();
        }
        return this.aspectAdviceRuleList;
    }

    public ExceptionRule getExceptionRule() {
        return this.exceptionRule;
    }

    public void setExceptionRule(ExceptionRule exceptionRule) {
        this.exceptionRule = exceptionRule;
    }

    public void putExceptionThrownRule(ExceptionThrownRule exceptionThrownRule) {
        if (this.exceptionRule == null) {
            this.exceptionRule = new ExceptionRule();
        }
        this.exceptionRule.putExceptionThrownRule(exceptionThrownRule);
    }

    public boolean isBeanRelevant() {
        return this.beanRelevant;
    }

    public void setBeanRelevant(boolean beanRelevant) {
        this.beanRelevant = beanRelevant;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.id);
        if (this.order != Integer.MAX_VALUE) {
            tsb.append("order", this.order);
        }
        tsb.append("isolated", this.isolated);
        tsb.append("disabled", this.disabled);
        tsb.append("joinpoint", this.joinpointRule);
        tsb.append("adviceBean", this.adviceBeanId);
        tsb.append("settingsAdvice", this.settingsAdviceRule);
        tsb.append("aspectAdvices", this.aspectAdviceRuleList);
        tsb.append("exception", this.exceptionRule);
        tsb.appendForce("beanRelevant", this.beanRelevant);
        return tsb.toString();
    }

    public static AspectRule newInstance(String id, String order, Boolean isolated, Boolean disabled) throws IllegalRuleException {
        if (id == null) {
            throw new IllegalRuleException("The 'aspect' element requires an 'id' attribute");
        }
        AspectRule aspectRule = new AspectRule();
        aspectRule.setId(id);
        aspectRule.setIsolated(isolated);
        aspectRule.setDisabled(disabled);
        if (!StringUtils.isEmpty(order)) {
            try {
                aspectRule.setOrder(Integer.parseInt(order));
            }
            catch (NumberFormatException e) {
                throw new IllegalRuleException("The 'order' attribute of the 'aspect' element is not a valid integer");
            }
        }
        return aspectRule;
    }

    public static void updateJoinpoint(AspectRule aspectRule, String type, String text) throws IllegalRuleException {
        JoinpointRule joinpointRule = JoinpointRule.newInstance();
        JoinpointRule.updateJoinpointTargetType(joinpointRule, type);
        JoinpointRule.updateJoinpoint(joinpointRule, text);
        aspectRule.setJoinpointRule(joinpointRule);
    }

    public static void updateJoinpoint(AspectRule aspectRule, JoinpointParameters joinpointParameters) throws IllegalRuleException {
        JoinpointRule joinpointRule = JoinpointRule.newInstance();
        JoinpointRule.updateJoinpoint(joinpointRule, joinpointParameters);
        aspectRule.setJoinpointRule(joinpointRule);
    }
}

