/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChooseRule {
    private final int caseNo;
    private Map<Integer, ChooseWhenRule> chooseWhenRuleMap;

    public ChooseRule(int caseNo) {
        ChooseRule.checkCaseNo(caseNo);
        this.caseNo = caseNo;
    }

    public int getCaseNo() {
        return this.caseNo;
    }

    public ChooseWhenRule newChooseWhenRule() {
        int size = this.chooseWhenRuleMap != null ? this.chooseWhenRuleMap.size() : 0;
        return this.newChooseWhenRule(this.caseNo + size + 1);
    }

    public ChooseWhenRule newChooseWhenRule(int caseNo) {
        ChooseWhenRule choosehenRule = new ChooseWhenRule(caseNo);
        if (this.chooseWhenRuleMap == null) {
            this.chooseWhenRuleMap = new LinkedHashMap<Integer, ChooseWhenRule>();
        }
        this.chooseWhenRuleMap.put(caseNo, choosehenRule);
        return choosehenRule;
    }

    public ChooseWhenRule getChooseWhenRule(int caseNo) {
        return this.chooseWhenRuleMap != null ? this.chooseWhenRuleMap.get(caseNo) : null;
    }

    public Map<Integer, ChooseWhenRule> getChooseWhenRuleMap() {
        return this.chooseWhenRuleMap;
    }

    public void join(ActionRuleApplicable applicable) {
        if (this.chooseWhenRuleMap != null) {
            for (ChooseWhenRule chooseWhenRule : this.chooseWhenRuleMap.values()) {
                chooseWhenRule.join(applicable);
            }
        }
    }

    public static int toCaseGroupNo(int caseNo) {
        if (caseNo < 1000) {
            return caseNo * 1000;
        }
        ChooseRule.checkCaseNo(caseNo);
        return caseNo / 1000 * 1000;
    }

    public static void checkCaseNo(int caseNo) {
        if (caseNo < 1000 || caseNo > 999999) {
            throw new IllegalArgumentException("caseNo must be > 1000 and <= 999999");
        }
    }
}

