/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.ExceptionThrownRule;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExceptionRule {
    private final List<ExceptionThrownRule> exceptionThrownRuleList = new ArrayList<ExceptionThrownRule>();
    private final Map<String, ExceptionThrownRule> exceptionThrownRuleMap = new LinkedHashMap<String, ExceptionThrownRule>();
    private ExceptionThrownRule defaultExceptionThrownRule;
    private String description;

    public List<ExceptionThrownRule> getExceptionThrownRuleList() {
        return this.exceptionThrownRuleList;
    }

    public Map<String, ExceptionThrownRule> getExceptionThrownRuleMap() {
        return this.exceptionThrownRuleMap;
    }

    public ExceptionThrownRule getDefaultExceptionThrownRule() {
        return this.defaultExceptionThrownRule;
    }

    public void putExceptionThrownRule(ExceptionThrownRule exceptionThrownRule) {
        this.exceptionThrownRuleList.add(exceptionThrownRule);
        String[] exceptionTypes = exceptionThrownRule.getExceptionTypes();
        if (exceptionTypes != null) {
            for (String exceptionType : exceptionTypes) {
                if (exceptionType == null || this.exceptionThrownRuleMap.containsKey(exceptionType)) continue;
                this.exceptionThrownRuleMap.put(exceptionType, exceptionThrownRule);
            }
        } else {
            this.defaultExceptionThrownRule = exceptionThrownRule;
        }
    }

    public ExceptionThrownRule getExceptionThrownRule(Throwable ex) {
        ExceptionThrownRule exceptionThrownRule = null;
        int deepest = Integer.MAX_VALUE;
        for (Map.Entry<String, ExceptionThrownRule> entry : this.exceptionThrownRuleMap.entrySet()) {
            int depth = this.getMatchedDepth(entry.getKey(), ex);
            if (depth < 0 || depth >= deepest) continue;
            deepest = depth;
            exceptionThrownRule = entry.getValue();
        }
        return exceptionThrownRule != null ? exceptionThrownRule : this.defaultExceptionThrownRule;
    }

    private int getMatchedDepth(String exceptionType, Throwable ex) {
        Throwable t = ex.getCause();
        if (t != null) {
            return this.getMatchedDepth(exceptionType, t);
        }
        return this.getMatchedDepth(exceptionType, ex.getClass(), 0);
    }

    private int getMatchedDepth(String exceptionType, Class<?> exceptionClass, int depth) {
        if (exceptionClass.getName().equals(exceptionType)) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getMatchedDepth(exceptionType, exceptionClass.getSuperclass(), depth + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

