/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;

public class IncludeActionRule {
    private String actionId;
    private String transletName;
    private MethodType methodType;
    private ItemRuleMap parameterItemRuleMap;
    private ItemRuleMap attributeItemRuleMap;
    private Boolean hidden;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getTransletName() {
        return this.transletName;
    }

    public void setTransletName(String transletName) {
        this.transletName = transletName;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    public ItemRuleMap getParameterItemRuleMap() {
        return this.parameterItemRuleMap;
    }

    public void setParameterItemRuleMap(ItemRuleMap parameterItemRuleMap) {
        this.parameterItemRuleMap = parameterItemRuleMap;
    }

    public ItemRule newParameterItemRule(String parameterName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(parameterName);
        this.addParameterItemRule(itemRule);
        return itemRule;
    }

    public void addParameterItemRule(ItemRule parameterItemRule) {
        if (this.parameterItemRuleMap == null) {
            this.parameterItemRuleMap = new ItemRuleMap();
        }
        this.parameterItemRuleMap.putItemRule(parameterItemRule);
    }

    public ItemRuleMap getAttributeItemRuleMap() {
        return this.attributeItemRuleMap;
    }

    public void setAttributeItemRuleMap(ItemRuleMap attributeItemRuleMap) {
        this.attributeItemRuleMap = attributeItemRuleMap;
    }

    public ItemRule newAttributeItemRule(String attributeName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(attributeName);
        this.addAttributeItemRule(itemRule);
        return itemRule;
    }

    public void addAttributeItemRule(ItemRule attributeItemRule) {
        if (this.attributeItemRuleMap == null) {
            this.attributeItemRuleMap = new ItemRuleMap();
        }
        this.attributeItemRuleMap.putItemRule(attributeItemRule);
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean isHidden() {
        return BooleanUtils.toBoolean(this.hidden);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.actionId);
        tsb.append("translet", this.transletName);
        tsb.append("method", (Object)this.methodType);
        if (this.parameterItemRuleMap != null) {
            tsb.append("parameters", this.parameterItemRuleMap.keySet());
        }
        if (this.attributeItemRuleMap != null) {
            tsb.append("attributes", this.attributeItemRuleMap.keySet());
        }
        return tsb.toString();
    }

    public static IncludeActionRule newInstance(String id, String transletName, String method, Boolean hidden) throws IllegalRuleException {
        if (transletName == null) {
            throw new IllegalRuleException("The 'include' element requires a 'translet' attribute");
        }
        MethodType methodType = MethodType.resolve(method);
        if (method != null && methodType == null) {
            throw new IllegalRuleException("No request method type for '" + method + "'");
        }
        IncludeActionRule includeActionRule = new IncludeActionRule();
        includeActionRule.setActionId(id);
        includeActionRule.setTransletName(transletName);
        includeActionRule.setMethodType(methodType);
        includeActionRule.setHidden(hidden);
        return includeActionRule;
    }
}

