/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.component.bean.annotation.Attribute;
import com.aspectran.core.component.bean.annotation.Parameter;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.params.CallParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.Parameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ItemRule {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String MAP_SUFFIX = "{}";
    private ItemType type;
    private String name;
    private ItemValueType valueType;
    private String defaultValue;
    private Boolean tokenize;
    private Token[] tokens;
    private List<Token[]> tokensList;
    private Map<String, Token[]> tokensMap;
    private Boolean mandatory;
    private Boolean secret;
    private boolean autoNamed;

    public ItemType getType() {
        return this.type;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.endsWith(ARRAY_SUFFIX)) {
            this.name = name.substring(0, name.length() - 2);
            this.type = ItemType.ARRAY;
        } else if (name.endsWith(MAP_SUFFIX)) {
            this.name = name.substring(0, name.length() - 2);
            this.type = ItemType.MAP;
        } else {
            this.name = name;
            if (this.type == null) {
                this.type = ItemType.SINGLE;
            }
        }
    }

    public String getValue() {
        return TokenParser.toString(this.tokens);
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    public List<Token[]> getTokensList() {
        return this.tokensList;
    }

    public List<String> getValueList() {
        if (this.tokensList == null) {
            return null;
        }
        if (this.tokensList.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(this.tokensList.size());
        for (Token[] tokens : this.tokensList) {
            list.add(TokenParser.toString(tokens));
        }
        return list;
    }

    public Map<String, Token[]> getTokensMap() {
        return this.tokensMap;
    }

    public Map<String, String> getValueMap() {
        if (this.tokensMap == null) {
            return null;
        }
        if (this.tokensMap.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.tokensMap.size());
        for (Map.Entry<String, Token[]> entry : this.tokensMap.entrySet()) {
            map.put(entry.getKey(), TokenParser.toString(entry.getValue()));
        }
        return map;
    }

    public void setValue(String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.setValue(tokens);
    }

    public void setValue(Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.SINGLE;
        }
        if (this.type != ItemType.SINGLE) {
            throw new IllegalArgumentException("The type of this item must be 'single'");
        }
        this.tokens = tokens;
    }

    public void putValue(String name, String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.putValue(name, tokens);
    }

    public void putValue(String name, Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.MAP;
        }
        if (!this.isMappableType()) {
            throw new IllegalArgumentException("The type of this item must be 'map' or 'properties'");
        }
        if (this.tokensMap == null) {
            this.tokensMap = new LinkedHashMap<String, Token[]>();
        }
        this.tokensMap.put(name, tokens);
    }

    public void setValue(Map<String, Token[]> tokensMap) {
        if (this.type == null) {
            this.type = ItemType.MAP;
        }
        if (!this.isMappableType()) {
            throw new IllegalArgumentException("The type of this item must be 'map' or 'properties'");
        }
        this.tokensMap = tokensMap;
    }

    public void setValue(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (this.type == null) {
            this.type = ItemType.PROPERTIES;
        }
        if (!this.isMappableType()) {
            throw new IllegalArgumentException("The type of this item must be 'properties' or 'map'");
        }
        this.tokensMap = new LinkedHashMap<String, Token[]>();
        for (String key : properties.stringPropertyNames()) {
            Token[] tokens;
            Object o = properties.get(key);
            if (o instanceof Token[]) {
                this.tokensMap.put(key, (Token[])o);
                continue;
            }
            if (o instanceof Token) {
                tokens = new Token[]{(Token)o};
                this.tokensMap.put(key, tokens);
                continue;
            }
            tokens = TokenParser.makeTokens(o.toString(), this.isTokenize());
            this.putValue(this.name, tokens);
        }
    }

    public void addValue(String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.addValue(tokens);
    }

    public void addValue(Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.LIST;
        }
        if (!this.isListableType()) {
            throw new IllegalArgumentException("The type of this item must be 'array', 'list' or 'set'");
        }
        if (this.tokensList == null) {
            this.tokensList = new ArrayList<Token[]>();
        }
        this.tokensList.add(tokens);
    }

    public void setValue(List<Token[]> tokensList) {
        if (this.type == null) {
            this.type = ItemType.LIST;
        }
        if (!this.isListableType()) {
            throw new IllegalArgumentException("The item type must be 'array', 'list' or 'set' for this item " + this);
        }
        this.tokensList = tokensList;
    }

    public void setValue(Set<Token[]> tokensSet) {
        if (tokensSet == null) {
            throw new IllegalArgumentException("tokensSet must not be null");
        }
        if (this.type == null) {
            this.type = ItemType.SET;
        }
        if (!this.isListableType()) {
            throw new IllegalArgumentException("The type of this item must be 'set', 'array' or 'list'");
        }
        this.tokensList = new ArrayList<Token[]>(tokensSet);
    }

    public ItemValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ItemValueType valueType) {
        this.valueType = valueType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getTokenize() {
        return this.tokenize;
    }

    public boolean isTokenize() {
        return this.tokenize != Boolean.FALSE;
    }

    public void setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
    }

    public boolean isAutoNamed() {
        return this.autoNamed;
    }

    public void setAutoNamed(boolean autoNamed) {
        this.autoNamed = autoNamed;
    }

    public boolean isListableType() {
        return this.type == ItemType.ARRAY || this.type == ItemType.LIST || this.type == ItemType.SET;
    }

    public boolean isMappableType() {
        return this.type == ItemType.MAP || this.type == ItemType.PROPERTIES;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory == Boolean.TRUE;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Boolean getSecret() {
        return this.secret;
    }

    public boolean isSecret() {
        return this.secret == Boolean.TRUE;
    }

    public void setSecret(Boolean secret) {
        this.secret = secret;
    }

    public Token[] getAllTokens() {
        if (this.type == ItemType.SINGLE) {
            return this.tokens;
        }
        if (this.isListableType()) {
            if (this.tokensList == null || this.tokensList.isEmpty()) {
                return null;
            }
            if (this.tokensList.size() == 1) {
                return this.tokensList.get(0);
            }
            ArrayList list = new ArrayList();
            for (Token[] tokens : this.tokensList) {
                Collections.addAll(list, tokens);
            }
            return list.toArray(new Token[0]);
        }
        if (this.isMappableType()) {
            if (this.tokensMap == null || this.tokensMap.isEmpty()) {
                return null;
            }
            if (this.tokensMap.size() == 1) {
                Iterator<Token[]> it = this.tokensMap.values().iterator();
                if (it.hasNext()) {
                    return it.next();
                }
                return new Token[0];
            }
            ArrayList list = new ArrayList();
            for (Token[] tokens : this.tokensMap.values()) {
                Collections.addAll(list, tokens);
            }
            return list.toArray(new Token[0]);
        }
        return null;
    }

    public boolean containsToken(Token token) {
        Token[] allTokens = this.getAllTokens();
        if (allTokens != null) {
            for (Token t : allTokens) {
                if (t == null || !t.equals(token)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.type);
        tsb.append("name", this.name);
        tsb.append("valueType", (Object)this.valueType);
        if (this.type == ItemType.SINGLE) {
            tsb.append("value", this.tokens);
        } else if (this.isListableType()) {
            tsb.append("value", this.tokensList);
        } else if (this.isMappableType()) {
            tsb.append("value", this.tokensMap);
        }
        tsb.append("tokenize", this.tokenize);
        tsb.append("mandatory", this.mandatory);
        tsb.append("secret", this.secret);
        return tsb.toString();
    }

    public static Class<?> getPrototypeClass(ItemRule ir, Object value) {
        ItemValueType valueType = ir.getValueType();
        if (ir.getType() == ItemType.ARRAY) {
            if (valueType == ItemValueType.STRING) {
                return String[].class;
            }
            if (valueType == ItemValueType.INT) {
                return Integer[].class;
            }
            if (valueType == ItemValueType.LONG) {
                return Long[].class;
            }
            if (valueType == ItemValueType.FLOAT) {
                return Float[].class;
            }
            if (valueType == ItemValueType.DOUBLE) {
                return Double[].class;
            }
            if (valueType == ItemValueType.BOOLEAN) {
                return Boolean[].class;
            }
            if (valueType == ItemValueType.PARAMETERS) {
                return Parameters[].class;
            }
            if (valueType == ItemValueType.FILE) {
                return File[].class;
            }
            if (valueType == ItemValueType.MULTIPART_FILE) {
                return FileParameter[].class;
            }
            return value != null ? value.getClass() : String[].class;
        }
        if (ir.getType() == ItemType.LIST) {
            return value != null ? value.getClass() : List.class;
        }
        if (ir.getType() == ItemType.MAP) {
            return value != null ? value.getClass() : Map.class;
        }
        if (ir.getType() == ItemType.SET) {
            return value != null ? value.getClass() : Set.class;
        }
        if (ir.getType() == ItemType.PROPERTIES) {
            return value != null ? value.getClass() : Properties.class;
        }
        if (valueType == ItemValueType.STRING) {
            return String.class;
        }
        if (valueType == ItemValueType.INT) {
            return Integer.class;
        }
        if (valueType == ItemValueType.LONG) {
            return Long.class;
        }
        if (valueType == ItemValueType.FLOAT) {
            return Float.class;
        }
        if (valueType == ItemValueType.DOUBLE) {
            return Double.class;
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return Boolean.class;
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return Parameters.class;
        }
        if (valueType == ItemValueType.FILE) {
            return File.class;
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return FileParameter.class;
        }
        return value != null ? value.getClass() : String.class;
    }

    public static ItemRule newInstance(String type, String name, String valueType, String defaultValue, Boolean tokenize, Boolean mandatory, Boolean secret) throws IllegalRuleException {
        ItemRule itemRule = new ItemRule();
        ItemType itemType = ItemType.resolve(type);
        if (type != null && itemType == null) {
            throw new IllegalRuleException("No item type for '" + type + "'");
        }
        if (itemType != null) {
            itemRule.setType(itemType);
        } else {
            itemRule.setType(ItemType.SINGLE);
        }
        if (!StringUtils.isEmpty(name)) {
            itemRule.setName(name);
        } else {
            itemRule.setAutoNamed(true);
        }
        if (tokenize != null) {
            itemRule.setTokenize(tokenize);
        }
        if (valueType != null) {
            ItemValueType itemValueType = ItemValueType.resolve(valueType);
            if (itemValueType == null) {
                throw new IllegalRuleException("No item value type for '" + valueType + "'");
            }
            itemRule.setValueType(itemValueType);
        }
        if (defaultValue != null) {
            itemRule.setDefaultValue(defaultValue);
        }
        if (mandatory != null) {
            itemRule.setMandatory(mandatory);
        }
        if (secret != null) {
            itemRule.setSecret(secret);
        }
        return itemRule;
    }

    public static Token makeReferenceToken(String bean, String template, String parameter, String attribute, String property) {
        Token token = bean != null ? new Token(TokenType.BEAN, bean) : (template != null ? new Token(TokenType.TEMPLATE, template) : (parameter != null ? new Token(TokenType.PARAMETER, parameter) : (attribute != null ? new Token(TokenType.ATTRIBUTE, attribute) : (property != null ? new Token(TokenType.PROPERTY, property) : null))));
        return token;
    }

    public static Iterator<Token[]> tokenIterator(final ItemRule itemRule) {
        Iterator<Token[]> it = null;
        if (itemRule.isListableType()) {
            List<Token[]> list = itemRule.getTokensList();
            if (list != null) {
                it = list.iterator();
            }
        } else if (itemRule.isMappableType()) {
            Map<String, Token[]> map = itemRule.getTokensMap();
            if (map != null) {
                it = map.values().iterator();
            }
        } else {
            return new Iterator<Token[]>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count++ < 1;
                }

                @Override
                public Token[] next() {
                    return itemRule.getTokens();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove an element of an array");
                }
            };
        }
        return it;
    }

    public static ItemRuleMap toItemRuleMap(List<ItemParameters> itemParametersList) throws IllegalRuleException {
        if (itemParametersList == null || itemParametersList.isEmpty()) {
            return null;
        }
        ItemRuleMap itemRuleMap = new ItemRuleMap();
        for (ItemParameters parameters : itemParametersList) {
            itemRuleMap.putItemRule(ItemRule.toItemRule(parameters));
        }
        return itemRuleMap;
    }

    public static ItemRuleList toItemRuleList(List<ItemParameters> itemParametersList) throws IllegalRuleException {
        ItemRuleList itemRuleList = new ItemRuleList();
        for (ItemParameters parameters : itemParametersList) {
            itemRuleList.add(ItemRule.toItemRule(parameters));
        }
        return itemRuleList;
    }

    public static ItemRule toItemRule(ItemParameters itemParameters) throws IllegalRuleException {
        String type = itemParameters.getString(ItemParameters.type);
        String name = itemParameters.getString(ItemParameters.name);
        String valueType = itemParameters.getString(ItemParameters.valueType);
        String defaultValue = itemParameters.getString(ItemParameters.defaultValue);
        Boolean tokenize = itemParameters.getBoolean(ItemParameters.tokenize);
        Boolean mandatory = itemParameters.getBoolean(ItemParameters.mandatory);
        Boolean secret = itemParameters.getBoolean(ItemParameters.secret);
        Object callParameters = itemParameters.getParameters(ItemParameters.call);
        ItemRule itemRule = ItemRule.newInstance(type, name, valueType, defaultValue, tokenize, mandatory, secret);
        if (callParameters != null) {
            String property;
            String attribute;
            String parameter;
            String template;
            String bean = StringUtils.emptyToNull(callParameters.getString(CallParameters.bean));
            Token t = ItemRule.makeReferenceToken(bean, template = StringUtils.emptyToNull(callParameters.getString(CallParameters.template)), parameter = StringUtils.emptyToNull(callParameters.getString(CallParameters.parameter)), attribute = StringUtils.emptyToNull(callParameters.getString(CallParameters.attribute)), property = StringUtils.emptyToNull(callParameters.getString(CallParameters.property)));
            if (t != null) {
                Token[] tokens = new Token[]{t};
                if (itemRule.isListableType()) {
                    itemRule.addValue(tokens);
                } else {
                    itemRule.setValue(tokens);
                }
            }
        } else if (itemRule.isListableType()) {
            List<String> stringList = itemParameters.getStringList(ItemParameters.value);
            if (stringList != null) {
                for (String text : stringList) {
                    itemRule.addValue(text);
                }
            }
        } else if (itemRule.isMappableType()) {
            Set<String> parametersNames;
            Object parameters = itemParameters.getParameters(ItemParameters.value);
            if (parameters != null && (parametersNames = parameters.getParameterNameSet()) != null) {
                for (String valueName : parametersNames) {
                    String text = parameters.getString(valueName);
                    itemRule.putValue(valueName, text);
                }
            }
        } else {
            String text = itemParameters.getString(ItemParameters.value);
            itemRule.setValue(text);
        }
        return itemRule;
    }

    public static ItemRuleMap toItemRuleMap(Parameter[] parameters) throws IllegalRuleException {
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        ItemRuleMap itemRuleMap = new ItemRuleMap();
        for (Parameter parameter : parameters) {
            itemRuleMap.putItemRule(ItemRule.toItemRule(parameter));
        }
        return itemRuleMap;
    }

    public static ItemRule toItemRule(Parameter parameter) throws IllegalRuleException {
        String name = parameter.name();
        String value = parameter.value();
        String defaultValue = parameter.defaultValue();
        boolean tokenize = parameter.tokenize();
        boolean mandatory = parameter.mandatory();
        boolean secret = parameter.secret();
        ItemRule itemRule = ItemRule.newInstance(null, name, null, defaultValue, tokenize, mandatory, secret);
        itemRule.setValue(value);
        return itemRule;
    }

    public static ItemRuleMap toItemRuleMap(Attribute[] attributes) throws IllegalRuleException {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        ItemRuleMap itemRuleMap = new ItemRuleMap();
        for (Attribute attribute : attributes) {
            itemRuleMap.putItemRule(ItemRule.toItemRule(attribute));
        }
        return itemRuleMap;
    }

    public static ItemRule toItemRule(Attribute attribute) throws IllegalRuleException {
        String name = attribute.name();
        String value = attribute.value();
        String defaultValue = attribute.defaultValue();
        boolean tokenize = attribute.tokenize();
        boolean mandatory = attribute.mandatory();
        boolean secret = attribute.secret();
        ItemRule itemRule = ItemRule.newInstance(null, name, null, defaultValue, tokenize, mandatory, secret);
        itemRule.setValue(value);
        return itemRule;
    }
}

