/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.PointcutRule;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.PointcutParameters;
import com.aspectran.core.context.rule.params.PointcutQualifierParameters;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AponParseException;
import java.util.ArrayList;
import java.util.List;

public class JoinpointRule {
    private JoinpointTargetType joinpointTargetType;
    private MethodType[] methods;
    private String[] headers;
    private PointcutRule pointcutRule;
    private JoinpointParameters joinpointParameters;

    public JoinpointTargetType getJoinpointTargetType() {
        return this.joinpointTargetType;
    }

    public void setJoinpointTargetType(JoinpointTargetType joinpointTargetType) {
        this.joinpointTargetType = joinpointTargetType;
        if (this.joinpointParameters != null) {
            if (joinpointTargetType != null) {
                this.joinpointParameters.putValue(JoinpointParameters.target, (Object)joinpointTargetType.toString());
            } else {
                this.joinpointParameters.putValue(JoinpointParameters.target, null);
            }
        }
    }

    public MethodType[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodType[] methods) {
        this.methods = methods;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public PointcutRule getPointcutRule() {
        return this.pointcutRule;
    }

    public void setPointcutRule(PointcutRule pointcutRule) {
        this.pointcutRule = pointcutRule;
    }

    public JoinpointParameters getJoinpointParameters() {
        return this.joinpointParameters;
    }

    private void setJoinpointParameters(JoinpointParameters joinpointParameters) {
        this.joinpointParameters = joinpointParameters;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("target", (Object)this.joinpointTargetType);
        tsb.append("methods", this.methods);
        tsb.append("headers", this.headers);
        tsb.append("pointcut", this.pointcutRule);
        return tsb.toString();
    }

    public static JoinpointRule newInstance() {
        return new JoinpointRule();
    }

    public static void updateJoinpoint(JoinpointRule joinpointRule, String text) throws IllegalRuleException {
        if (StringUtils.hasText(text)) {
            JoinpointParameters joinpointParameters;
            try {
                joinpointParameters = new JoinpointParameters(text);
            }
            catch (AponParseException e) {
                throw new IllegalRuleException("Joinpoint parameter can not be parsed", e);
            }
            JoinpointRule.updateJoinpoint(joinpointRule, joinpointParameters);
        }
    }

    public static void updateJoinpoint(JoinpointRule joinpointRule, JoinpointParameters joinpointParameters) throws IllegalRuleException {
        if (joinpointRule.getJoinpointTargetType() == null) {
            String type = joinpointParameters.getString(JoinpointParameters.target);
            JoinpointRule.updateJoinpointTargetType(joinpointRule, type);
        }
        JoinpointRule.updateMethods(joinpointRule, joinpointParameters.getStringArray(JoinpointParameters.methods));
        JoinpointRule.updateHeaders(joinpointRule, joinpointParameters.getStringArray(JoinpointParameters.headers));
        JoinpointRule.updatePointcutRule(joinpointRule, (PointcutParameters)joinpointParameters.getParameters(JoinpointParameters.pointcut));
        joinpointRule.setJoinpointParameters(joinpointParameters);
    }

    public static void updateJoinpointTargetType(JoinpointRule joinpointRule, String type) {
        JoinpointTargetType joinpointTargetType;
        if (type != null) {
            joinpointTargetType = JoinpointTargetType.resolve(type);
            if (joinpointTargetType == null) {
                throw new IllegalArgumentException("No joinpoint target type for '" + type + "'");
            }
        } else {
            joinpointTargetType = JoinpointTargetType.TRANSLET;
        }
        joinpointRule.setJoinpointTargetType(joinpointTargetType);
    }

    public static void updateMethods(JoinpointRule joinpointRule, String[] methods) {
        MethodType[] methods2 = null;
        if (methods != null && methods.length > 0) {
            ArrayList<MethodType> methodTypes = new ArrayList<MethodType>(methods.length);
            for (String method : methods) {
                MethodType methodType = MethodType.resolve(method);
                if (methodType == null) {
                    throw new IllegalArgumentException("No request method type for '" + method + "'");
                }
                methodTypes.add(methodType);
            }
            methods2 = methodTypes.toArray(new MethodType[0]);
        }
        joinpointRule.setMethods(methods2);
    }

    public static void updateHeaders(JoinpointRule joinpointRule, String[] headers) {
        String[] headers2 = null;
        if (headers != null && headers.length > 0) {
            ArrayList<String> headerList = new ArrayList<String>(headers.length);
            for (String header : headers) {
                if (!StringUtils.hasText(header)) continue;
                headerList.add(header);
            }
            headers2 = headerList.toArray(new String[0]);
        }
        joinpointRule.setHeaders(headers2);
    }

    public static void updatePointcutRule(JoinpointRule joinpointRule, PointcutParameters pointcutParameters) throws IllegalRuleException {
        PointcutRule pointcutRule = null;
        if (pointcutParameters != null) {
            int qualifierParametersSize;
            List<String> plusPatternStringList = pointcutParameters.getStringList(PointcutParameters.plus);
            List<String> minusPatternStringList = pointcutParameters.getStringList(PointcutParameters.minus);
            List includeQualifierParametersList = pointcutParameters.getParametersList(PointcutParameters.include);
            List excludeQualifierParametersList = pointcutParameters.getParametersList(PointcutParameters.exclude);
            int patternStringSize = plusPatternStringList != null ? plusPatternStringList.size() : 0;
            int n = qualifierParametersSize = includeQualifierParametersList != null ? includeQualifierParametersList.size() : 0;
            if (patternStringSize > 0 || qualifierParametersSize > 0) {
                PointcutPatternRule pointcutPatternRule;
                pointcutRule = PointcutRule.newInstance(pointcutParameters.getString(PointcutParameters.type));
                pointcutRule.newPointcutPatternRuleList(patternStringSize + qualifierParametersSize);
                if (patternStringSize > 0) {
                    ArrayList<PointcutPatternRule> minusPointcutPatternRuleList = null;
                    if (minusPatternStringList != null && !minusPatternStringList.isEmpty()) {
                        minusPointcutPatternRuleList = new ArrayList<PointcutPatternRule>(minusPatternStringList.size());
                        for (String patternString : minusPatternStringList) {
                            pointcutPatternRule = PointcutPatternRule.parsePattern(patternString);
                            minusPointcutPatternRuleList.add(pointcutPatternRule);
                        }
                    }
                    for (String patternString : plusPatternStringList) {
                        pointcutPatternRule = PointcutPatternRule.parsePattern(patternString);
                        pointcutRule.addPointcutPatternRule(pointcutPatternRule, minusPointcutPatternRuleList);
                    }
                }
                if (qualifierParametersSize > 0) {
                    ArrayList<PointcutPatternRule> excludePointcutPatternRuleList = null;
                    if (excludeQualifierParametersList != null && !excludeQualifierParametersList.isEmpty()) {
                        excludePointcutPatternRuleList = new ArrayList<PointcutPatternRule>(excludeQualifierParametersList.size());
                        for (PointcutQualifierParameters excludeTargetParameters : excludeQualifierParametersList) {
                            pointcutPatternRule = JoinpointRule.createPointcutPatternRule(excludeTargetParameters);
                            if (pointcutPatternRule == null) continue;
                            excludePointcutPatternRuleList.add(pointcutPatternRule);
                        }
                    }
                    for (PointcutQualifierParameters includeTargetParameters : includeQualifierParametersList) {
                        pointcutPatternRule = JoinpointRule.createPointcutPatternRule(includeTargetParameters);
                        pointcutRule.addPointcutPatternRule(pointcutPatternRule, excludePointcutPatternRuleList);
                    }
                }
            }
        }
        joinpointRule.setPointcutRule(pointcutRule);
    }

    private static PointcutPatternRule createPointcutPatternRule(PointcutQualifierParameters pointcutQualifierParameters) {
        PointcutPatternRule pointcutPatternRule = null;
        String translet = pointcutQualifierParameters.getString(PointcutQualifierParameters.translet);
        String bean = pointcutQualifierParameters.getString(PointcutQualifierParameters.bean);
        String method = pointcutQualifierParameters.getString(PointcutQualifierParameters.method);
        if (StringUtils.hasLength(translet) || StringUtils.hasLength(bean) || StringUtils.hasLength(method)) {
            pointcutPatternRule = PointcutPatternRule.newInstance(translet, bean, method);
        }
        return pointcutPatternRule;
    }
}

