/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.ToStringBuilder;
import java.nio.charset.Charset;

public class RequestRule {
    public static final String CHARACTER_ENCODING_SETTING_NAME = "characterEncoding";
    public static final String LOCALE_RESOLVER_SETTING_NAME = "localeResolver";
    public static final String LOCALE_CHANGE_INTERCEPTOR_SETTING_NAME = "localeChangeInterceptor";
    private final boolean explicit;
    private String encoding;
    private MethodType allowedMethod;
    private ItemRuleMap parameterItemRuleMap;
    private ItemRuleMap attributeItemRuleMap;

    public RequestRule(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public MethodType getAllowedMethod() {
        return this.allowedMethod;
    }

    public void setAllowedMethod(MethodType allowedMethod) {
        this.allowedMethod = allowedMethod;
    }

    public ItemRuleMap getParameterItemRuleMap() {
        return this.parameterItemRuleMap;
    }

    public void setParameterItemRuleMap(ItemRuleMap parameterItemRuleMap) {
        this.parameterItemRuleMap = parameterItemRuleMap;
    }

    public ItemRule newParameterItemRule(String parameterName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(parameterName);
        this.addParameterItemRule(itemRule);
        return itemRule;
    }

    public void addParameterItemRule(ItemRule parameterItemRule) {
        if (this.parameterItemRuleMap == null) {
            this.parameterItemRuleMap = new ItemRuleMap();
        }
        this.parameterItemRuleMap.putItemRule(parameterItemRule);
    }

    public ItemRuleMap getAttributeItemRuleMap() {
        return this.attributeItemRuleMap;
    }

    public void setAttributeItemRuleMap(ItemRuleMap attributeItemRuleMap) {
        this.attributeItemRuleMap = attributeItemRuleMap;
    }

    public ItemRule newAttributeItemRule(String attributeName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(attributeName);
        this.addAttributeItemRule(itemRule);
        return itemRule;
    }

    public void addAttributeItemRule(ItemRule attributeItemRule) {
        if (this.attributeItemRuleMap == null) {
            this.attributeItemRuleMap = new ItemRuleMap();
        }
        this.attributeItemRuleMap.putItemRule(attributeItemRule);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("method", (Object)this.allowedMethod);
        tsb.append("encoding", this.encoding);
        tsb.append("parameters", this.parameterItemRuleMap);
        tsb.append("attributes", this.attributeItemRuleMap);
        return tsb.toString();
    }

    public static RequestRule newInstance(boolean explicit) {
        return new RequestRule(explicit);
    }

    public static RequestRule newInstance(String allowedMethod, String encoding) throws IllegalRuleException {
        MethodType allowedMethodType = null;
        if (allowedMethod != null && (allowedMethodType = MethodType.resolve(allowedMethod)) == null) {
            throw new IllegalRuleException("No request method type for '" + allowedMethod + "'");
        }
        if (encoding != null) {
            try {
                Charset.forName(encoding);
            }
            catch (Exception e) {
                throw new IllegalRuleException("Unsupported character encoding name: " + encoding, e);
            }
        }
        RequestRule requestRule = new RequestRule(true);
        requestRule.setAllowedMethod(allowedMethodType);
        requestRule.setEncoding(encoding);
        return requestRule;
    }
}

