/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.RedirectResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.transform.TransformResponseFactory;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.ability.ResponseRuleApplicable;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.ToStringBuilder;
import java.nio.charset.Charset;

public class ResponseRule
implements ResponseRuleApplicable,
Replicable<ResponseRule> {
    private final boolean explicit;
    private String name;
    private String encoding;
    private Response response;

    public ResponseRule(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public ResponseType getResponseType() {
        return this.response != null ? this.response.getResponseType() : null;
    }

    @Override
    public Response applyResponseRule(TransformRule transformRule) {
        Response response;
        this.response = response = TransformResponseFactory.createTransformResponse(transformRule);
        return response;
    }

    @Override
    public Response applyResponseRule(DispatchRule dispatchRule) {
        DispatchResponse response = new DispatchResponse(dispatchRule);
        this.response = response;
        return response;
    }

    @Override
    public Response applyResponseRule(ForwardRule forwardRule) {
        ForwardResponse response = new ForwardResponse(forwardRule);
        this.response = response;
        return response;
    }

    @Override
    public Response applyResponseRule(RedirectRule redirectRule) {
        RedirectResponse response = new RedirectResponse(redirectRule);
        this.response = response;
        return response;
    }

    @Override
    public ResponseRule replicate() {
        return ResponseRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("encoding", this.encoding);
        tsb.append("response", this.response);
        return tsb.toString();
    }

    public static ResponseRule newInstance(String name, String encoding) throws IllegalRuleException {
        if (encoding != null) {
            try {
                Charset.forName(encoding);
            }
            catch (Exception e) {
                throw new IllegalRuleException("Unsupported character encoding name: " + encoding, e);
            }
        }
        ResponseRule responseRule = new ResponseRule(true);
        responseRule.setName(name);
        responseRule.setEncoding(encoding);
        return responseRule;
    }

    public static ResponseRule newInstance(DispatchRule dispatchRule) {
        ResponseRule responseRule = new ResponseRule(false);
        responseRule.applyResponseRule(dispatchRule);
        return responseRule;
    }

    public static ResponseRule newInstance(TransformRule transformRule) {
        ResponseRule responseRule = new ResponseRule(false);
        responseRule.applyResponseRule(transformRule);
        return responseRule;
    }

    public static ResponseRule newInstance(ForwardRule forwardRule) {
        ResponseRule responseRule = new ResponseRule(false);
        responseRule.applyResponseRule(forwardRule);
        return responseRule;
    }

    public static ResponseRule newInstance(RedirectRule redirectRule) {
        ResponseRule responseRule = new ResponseRule(false);
        responseRule.applyResponseRule(redirectRule);
        return responseRule;
    }

    public static ResponseRule replicate(ResponseRule responseRule) {
        ResponseRule newResponseRule = new ResponseRule(responseRule.isExplicit());
        newResponseRule.setName(responseRule.getName());
        newResponseRule.setEncoding(responseRule.getEncoding());
        Response response = responseRule.getResponse();
        if (response != null) {
            Response newResponse = response.replicate();
            newResponseRule.setResponse(newResponse);
        }
        return newResponseRule;
    }
}

