/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.context.rule.type.TriggerType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AponParseException;
import java.util.ArrayList;
import java.util.List;

public class ScheduleRule
implements BeanReferenceable {
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.SCHEDULE_RULE;
    private String id;
    private TriggerType triggerType;
    private TriggerParameters triggerParameters;
    private String schedulerBeanId;
    private Class<?> schedulerBeanClass;
    private List<ScheduledJobRule> scheduledJobRuleList = new ArrayList<ScheduledJobRule>();
    private String description;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public TriggerParameters getTriggerParameters() {
        return this.triggerParameters;
    }

    public void setTriggerParameters(TriggerParameters triggerParameters) {
        this.triggerParameters = triggerParameters;
    }

    public String getSchedulerBeanId() {
        return this.schedulerBeanId;
    }

    public void setSchedulerBeanId(String schedulerBeanId) {
        this.schedulerBeanId = schedulerBeanId;
    }

    public Class<?> getSchedulerBeanClass() {
        return this.schedulerBeanClass;
    }

    public void setSchedulerBeanClass(Class<?> schedulerBeanClass) {
        this.schedulerBeanClass = schedulerBeanClass;
    }

    public List<ScheduledJobRule> getScheduledJobRuleList() {
        return this.scheduledJobRuleList;
    }

    public void setScheduledJobRuleList(List<ScheduledJobRule> scheduledJobRuleList) {
        this.scheduledJobRuleList = scheduledJobRuleList;
    }

    public void addScheduledJobRule(ScheduledJobRule scheduledJobRule) {
        this.scheduledJobRuleList.add(scheduledJobRule);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.id);
        tsb.append("scheduler", this.schedulerBeanId);
        tsb.append("trigger", this.triggerParameters);
        tsb.append("jobs", this.scheduledJobRuleList);
        return tsb.toString();
    }

    public static ScheduleRule newInstance(String id) throws IllegalRuleException {
        if (id == null) {
            throw new IllegalRuleException("The 'schedule' element requires an 'id' attribute");
        }
        ScheduleRule scheduleRule = new ScheduleRule();
        scheduleRule.setId(id);
        return scheduleRule;
    }

    public static void updateTrigger(ScheduleRule scheduleRule, String type, String text) throws IllegalRuleException {
        ScheduleRule.updateTriggerType(scheduleRule, type);
        ScheduleRule.updateTrigger(scheduleRule, text);
    }

    public static void updateTrigger(ScheduleRule scheduleRule, String text) throws IllegalRuleException {
        if (StringUtils.hasText(text)) {
            TriggerParameters triggerParameters;
            try {
                triggerParameters = new TriggerParameters(text);
            }
            catch (AponParseException e) {
                throw new IllegalRuleException("Trigger parameter can not be parsed", e);
            }
            ScheduleRule.updateTrigger(scheduleRule, triggerParameters);
        }
    }

    public static void updateTrigger(ScheduleRule scheduleRule, TriggerParameters triggerParameters) {
        if (scheduleRule.getTriggerType() == null) {
            String type = triggerParameters.getString(TriggerParameters.type);
            ScheduleRule.updateTriggerType(scheduleRule, type);
        }
        if (scheduleRule.getTriggerType() == TriggerType.SIMPLE) {
            Long intervalInMilliseconds = triggerParameters.getLong(TriggerParameters.intervalInMilliseconds);
            Integer intervalInSeconds = triggerParameters.getInt(TriggerParameters.intervalInSeconds);
            Integer intervalInMinutes = triggerParameters.getInt(TriggerParameters.intervalInMinutes);
            Integer intervalInHours = triggerParameters.getInt(TriggerParameters.intervalInHours);
            if (intervalInMilliseconds == null && intervalInSeconds == null && intervalInMinutes == null && intervalInHours == null) {
                throw new IllegalArgumentException("Must specify the interval between execution times for simple trigger. (Specifiable time interval types: intervalInMilliseconds, intervalInSeconds, intervalInMinutes, intervalInHours)");
            }
            scheduleRule.setTriggerParameters(triggerParameters);
        } else {
            String expression = triggerParameters.getString(TriggerParameters.expression);
            Object[] fields = StringUtils.tokenize(expression, " ");
            if (fields.length != 6) {
                throw new IllegalArgumentException(String.format("Cron expression must consist of 6 fields (found %d in %s)", fields.length, expression));
            }
            triggerParameters.putValue(TriggerParameters.expression, (Object)StringUtils.toDelimitedString(fields, " "));
            scheduleRule.setTriggerParameters(triggerParameters);
        }
    }

    public static void updateTriggerType(ScheduleRule scheduleRule, String type) {
        TriggerType triggerType;
        if (type != null) {
            triggerType = TriggerType.resolve(type);
            if (triggerType == null) {
                throw new IllegalArgumentException("Unknown trigger type '" + type + "'; Trigger type for Scheduler must be 'cron' or 'simple'");
            }
        } else {
            triggerType = TriggerType.CRON;
        }
        scheduleRule.setTriggerType(triggerType);
    }
}

