/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.VariableParameters;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SettingsAdviceRule {
    private final AspectRule aspectRule;
    private Map<String, Object> settings;

    public SettingsAdviceRule(AspectRule aspectRule) {
        this.aspectRule = aspectRule;
    }

    public String getAspectId() {
        return this.aspectRule.getId();
    }

    public AspectRule getAspectRule() {
        return this.aspectRule;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public <T> T getSetting(String name) {
        return (T)this.settings.get(name);
    }

    public void putSetting(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Setting name can not be null");
        }
        if (this.settings == null) {
            this.settings = new LinkedHashMap<String, Object>();
        }
        this.settings.put(name, value);
    }

    public static SettingsAdviceRule newInstance(AspectRule aspectRule) {
        return new SettingsAdviceRule(aspectRule);
    }

    public static SettingsAdviceRule newInstance(AspectRule aspectRule, String text) throws AponParseException {
        if (StringUtils.hasText(text)) {
            VariableParameters settingsParameters = new VariableParameters(text);
            return SettingsAdviceRule.newInstance(aspectRule, settingsParameters);
        }
        return SettingsAdviceRule.newInstance(aspectRule, (Parameters)null);
    }

    public static SettingsAdviceRule newInstance(AspectRule aspectRule, Parameters settingsParameters) {
        SettingsAdviceRule sar = new SettingsAdviceRule(aspectRule);
        SettingsAdviceRule.updateSettingsAdviceRule(sar, settingsParameters);
        return sar;
    }

    public static void updateSettingsAdviceRule(SettingsAdviceRule sar, String text) throws IllegalRuleException {
        if (StringUtils.hasText(text)) {
            VariableParameters settingsParameters;
            try {
                settingsParameters = new VariableParameters(text);
            }
            catch (AponParseException e) {
                throw new IllegalRuleException("Settings parameter can not be parsed", e);
            }
            SettingsAdviceRule.updateSettingsAdviceRule(sar, settingsParameters);
        }
    }

    public static void updateSettingsAdviceRule(SettingsAdviceRule sar, Parameters settingsParameters) {
        Set<String> parametersNames;
        if (settingsParameters != null && (parametersNames = settingsParameters.getParameterNameSet()) != null) {
            for (String name : parametersNames) {
                sar.putSetting(name, settingsParameters.getString(name));
            }
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        if (this.aspectRule != null) {
            tsb.append("aspectId", this.aspectRule.getId());
        }
        tsb.append("settings", this.settings);
        return tsb.toString();
    }
}

