/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.AbstractResponseRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TransformType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;

public class TransformRule
extends AbstractResponseRule
implements Replicable<TransformRule> {
    public static final ResponseType RESPONSE_TYPE = ResponseType.TRANSFORM;
    private TransformType transformType;
    private String contentType;
    private String encoding;
    private Boolean pretty;
    private String templateId;
    private TemplateRule templateRule;

    public TransformType getTransformType() {
        return this.transformType;
    }

    public void setTransformType(TransformType transformType) {
        this.transformType = transformType;
        if (this.contentType == null && transformType != null) {
            if (transformType == TransformType.TEXT) {
                this.contentType = ContentType.TEXT_PLAIN.toString();
            } else if (transformType == TransformType.JSON) {
                this.contentType = ContentType.TEXT_JSON.toString();
            } else if (transformType == TransformType.XML) {
                this.contentType = ContentType.TEXT_XML.toString();
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getPretty() {
        return this.pretty;
    }

    public boolean isPretty() {
        return BooleanUtils.toBoolean(this.pretty);
    }

    public void setPretty(Boolean pretty) {
        this.pretty = pretty;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public TemplateRule getTemplateRule() {
        return this.templateRule;
    }

    public void setTemplateRule(TemplateRule templateRule) {
        this.templateRule = templateRule;
        if (templateRule != null) {
            if (this.transformType == null) {
                this.setTransformType(TransformType.TEXT);
            }
            if (templateRule.getEncoding() != null && this.encoding == null) {
                this.encoding = templateRule.getEncoding();
            }
        }
    }

    @Override
    public TransformRule replicate() {
        return TransformRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("responseType", (Object)RESPONSE_TYPE);
        tsb.appendForce("transformType", (Object)this.transformType);
        tsb.append("contentType", this.contentType);
        tsb.append("encoding", this.encoding);
        tsb.append("default", this.getDefaultResponse());
        tsb.append("pretty", this.pretty);
        tsb.append("template", this.templateId);
        tsb.append("template", this.templateRule);
        return tsb.toString();
    }

    public static TransformRule newInstance(String type, String contentType, String encoding, Boolean defaultResponse, Boolean pretty) {
        TransformType transformType = TransformType.resolve(type);
        if (transformType == null && contentType != null) {
            transformType = TransformType.resolve(ContentType.resolve(contentType));
        }
        TransformRule tr = new TransformRule();
        tr.setTransformType(transformType);
        if (contentType != null) {
            tr.setContentType(contentType);
        }
        tr.setEncoding(encoding);
        tr.setDefaultResponse(defaultResponse);
        tr.setPretty(pretty);
        return tr;
    }

    public static TransformRule newInstance(TransformType transformType, String contentType, String encoding, Boolean defaultResponse, Boolean pretty) {
        if (transformType == null && contentType != null) {
            transformType = TransformType.resolve(ContentType.resolve(contentType));
        }
        TransformRule tr = new TransformRule();
        tr.setTransformType(transformType);
        if (contentType != null) {
            tr.setContentType(contentType);
        }
        tr.setEncoding(encoding);
        tr.setDefaultResponse(defaultResponse);
        tr.setPretty(pretty);
        return tr;
    }

    public static void updateTemplateId(TransformRule transformRule, String templateId) throws IllegalRuleException {
        if (templateId == null) {
            throw new IllegalRuleException("The 'call' element of 'transform' must have a 'template' attribute");
        }
        transformRule.setTemplateId(templateId);
    }

    public static TransformRule replicate(TransformRule transformRule) {
        TransformRule tr = new TransformRule();
        tr.setTransformType(transformRule.getTransformType());
        tr.setContentType(transformRule.getContentType());
        tr.setEncoding(transformRule.getEncoding());
        tr.setDefaultResponse(transformRule.getDefaultResponse());
        tr.setPretty(transformRule.getPretty());
        tr.setActionList(transformRule.getActionList());
        TemplateRule templateRule = transformRule.getTemplateRule();
        if (templateRule != null) {
            tr.setTemplateRule(templateRule.replicate());
        }
        return tr;
    }
}

