/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.appender.AbstractAppendHandler;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.assistant.ShallowContextRuleAssistant;
import com.aspectran.core.context.rule.converter.ParamsToRuleConverter;
import com.aspectran.core.context.rule.converter.RuleToParamsConverter;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.AppendedFileFormatType;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.AponWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class HybridRuleAppendHandler
extends AbstractAppendHandler {
    private final String encoding;
    private final boolean hybridLoad;
    private AspectranNodeParser aspectranNodeParser;
    private ParamsToRuleConverter ruleConverter;

    public HybridRuleAppendHandler(ContextRuleAssistant assistant, String encoding, boolean hybridLoad) {
        super(assistant);
        this.encoding = encoding;
        this.hybridLoad = hybridLoad;
    }

    @Override
    public void handle(RuleAppender appender) throws Exception {
        this.setCurrentRuleAppender(appender);
        AssistantLocal assistantLocal = this.getContextRuleAssistant().backupAssistantLocal();
        boolean hybridon = false;
        if (appender != null) {
            if (appender.getAppenderType() == AppenderType.PARAMETERS) {
                AspectranParameters aspectranParameters = appender.getAppendRule().getAspectranParameters();
                RootParameters rootParameters = new RootParameters(aspectranParameters);
                this.getRuleConverter().convertAsRule(rootParameters);
            } else if (appender.getAppendedFileFormatType() == AppendedFileFormatType.APON) {
                RootParameters rootParameters = AponReader.parse(appender.getReader(this.encoding), new RootParameters());
                this.getRuleConverter().convertAsRule(rootParameters);
            } else {
                if (this.hybridLoad && appender.getAppenderType() == AppenderType.FILE) {
                    File aponFile = this.makeAponFile((FileRuleAppender)appender);
                    if (appender.getLastModified() == aponFile.lastModified()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rapid configuration loading with an APON file: " + aponFile);
                        }
                        hybridon = true;
                        RootParameters rootParameters = AponReader.parse(aponFile, this.encoding, new RootParameters());
                        this.getRuleConverter().convertAsRule(rootParameters);
                    }
                }
                if (!hybridon) {
                    if (this.aspectranNodeParser == null) {
                        this.aspectranNodeParser = new AspectranNodeParser(this.getContextRuleAssistant());
                    }
                    this.aspectranNodeParser.parse(appender);
                }
            }
        }
        super.handle();
        if (assistantLocal.getReplicatedCount() > 0) {
            this.getContextRuleAssistant().restoreAssistantLocal(assistantLocal);
        }
        if (appender != null && !hybridon && this.hybridLoad && appender.getAppenderType() == AppenderType.FILE && appender.getAppendedFileFormatType() == AppendedFileFormatType.XML) {
            this.saveAsAponFile((FileRuleAppender)appender);
        }
    }

    private ParamsToRuleConverter getRuleConverter() {
        if (this.ruleConverter == null) {
            this.ruleConverter = new ParamsToRuleConverter(this.getContextRuleAssistant());
        }
        return this.ruleConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsAponFile(FileRuleAppender fileRuleAppender) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Save as APON file: " + fileRuleAppender);
        }
        File aponFile = null;
        try {
            AponWriter aponWriter;
            aponFile = this.makeAponFile(fileRuleAppender);
            if (this.encoding != null) {
                FileOutputStream outputStream = new FileOutputStream(aponFile);
                aponWriter = new AponWriter(new OutputStreamWriter((OutputStream)outputStream, this.encoding));
            } else {
                aponWriter = new AponWriter(new FileWriter(aponFile));
            }
            aponWriter.setIndentString("  ");
            try {
                ShallowContextRuleAssistant assistant = new ShallowContextRuleAssistant();
                ((ContextRuleAssistant)assistant).ready();
                AspectranNodeParser parser = new AspectranNodeParser(assistant, false, false);
                parser.parse(fileRuleAppender);
                RuleToParamsConverter paramsConverter = new RuleToParamsConverter(assistant);
                RootParameters rootParameters = paramsConverter.toRootParameters();
                aponWriter.comment(aponFile.getAbsolutePath());
                aponWriter.write(rootParameters);
                ((ContextRuleAssistant)assistant).release();
            }
            finally {
                try {
                    aponWriter.close();
                }
                catch (IOException e) {
                    this.log.error("Exception during closing file " + aponFile, e);
                }
            }
            aponFile.setLastModified(fileRuleAppender.getLastModified());
        }
        catch (Exception e) {
            this.log.error("Failed to save file converted to APON format: " + aponFile, e);
        }
    }

    private File makeAponFile(FileRuleAppender fileRuleAppender) {
        String basePath = fileRuleAppender.getBasePath();
        String filePath = fileRuleAppender.getFilePath() + "." + AppendedFileFormatType.APON.toString();
        return new File(basePath, filePath);
    }
}

