/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.core.util.ToStringBuilder;
import java.io.IOException;
import java.io.InputStream;

public class ResourceRuleAppender
extends AbstractRuleAppender {
    private final String resource;
    private final ClassLoader classLoader;

    public ResourceRuleAppender(String resource) {
        this(resource, null);
    }

    public ResourceRuleAppender(String resource, ClassLoader classLoader) {
        super(AppenderType.RESOURCE);
        this.resource = resource;
        this.classLoader = classLoader;
        this.setLastModified(System.currentTimeMillis());
    }

    @Override
    public String getQualifiedName() {
        return this.resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream = this.classLoader != null ? this.classLoader.getResourceAsStream(this.resource) : this.getClass().getResourceAsStream(this.resource);
            if (inputStream == null) {
                throw new IllegalArgumentException("No resource found");
            }
            return inputStream;
        }
        catch (Exception e) {
            throw new IOException("Failed to create input stream from rule resource: " + this.resource, e);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.getAppenderType());
        tsb.append("resource", this.resource);
        tsb.append("format", (Object)this.getAppendedFileFormatType());
        tsb.append("profile", this.getProfiles());
        return tsb.toString();
    }
}

