/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.component.bean.BeanRuleAnalyzer;
import com.aspectran.core.component.bean.BeanRuleException;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.BeanReferenceException;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.nodelet.NodeTracker;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BeanReferenceInspector {
    private static final Log log = LogFactory.getLog(BeanReferenceInspector.class);
    private final Map<RefererKey, Set<RefererInfo>> refererInfoMap = new LinkedHashMap<RefererKey, Set<RefererInfo>>(256);

    public void reserve(String beanId, Class<?> beanClass, BeanReferenceable referenceable, RuleAppender ruleAppender) {
        RefererKey key = new RefererKey(beanClass, beanId);
        Set<RefererInfo> refererInfoSet = this.refererInfoMap.get(key);
        if (refererInfoSet == null) {
            refererInfoSet = new LinkedHashSet<RefererInfo>();
            refererInfoSet.add(new RefererInfo(referenceable, ruleAppender));
            this.refererInfoMap.put(key, refererInfoSet);
        } else {
            refererInfoSet.add(new RefererInfo(referenceable, ruleAppender));
        }
    }

    public void inspect(BeanRuleRegistry beanRuleRegistry) throws BeanReferenceException, BeanRuleException {
        LinkedHashSet<Object> brokenReferences = new LinkedHashSet<Object>();
        for (Map.Entry<RefererKey, Set<RefererInfo>> entry : this.refererInfoMap.entrySet()) {
            BeanRule[] beanRules;
            BeanRule beanRule;
            Set<RefererInfo> refererInfoSet;
            Class<?> beanClass;
            String beanId;
            RefererKey refererKey;
            block16: {
                block12: {
                    block13: {
                        block14: {
                            block15: {
                                refererKey = entry.getKey();
                                beanId = refererKey.getQualifier();
                                beanClass = refererKey.getType();
                                refererInfoSet = entry.getValue();
                                beanRule = null;
                                beanRules = null;
                                if (beanClass == null) break block12;
                                beanRules = beanRuleRegistry.getBeanRules(beanClass);
                                if (beanRules == null) break block13;
                                if (beanRules.length != 1) break block14;
                                if (beanId == null) break block15;
                                if (!beanId.equals(beanRules[0].getId())) break block13;
                                beanRule = beanRules[0];
                                break block13;
                            }
                            beanRule = beanRules[0];
                            break block13;
                        }
                        if (beanId != null) {
                            for (BeanRule br : beanRules) {
                                if (!beanId.equals(br.getId())) continue;
                                beanRule = br;
                                break;
                            }
                        }
                    }
                    if (beanRule == null && beanRules == null) {
                        beanRule = beanRuleRegistry.getBeanRuleForConfig(beanClass);
                    }
                    break block16;
                }
                if (beanId != null) {
                    beanRule = beanRuleRegistry.getBeanRule(beanId);
                }
            }
            if (beanRule == null) {
                if (beanRules != null && beanRules.length > 1) {
                    for (RefererInfo refererInfo : refererInfoSet) {
                        if (beanId != null) {
                            log.error("Cannot resolve reference to bean " + refererKey + "; Referer: " + refererInfo);
                            continue;
                        }
                        log.error("No unique bean of type [" + beanClass + "] is defined: expected single matching bean but found " + beanRules.length + ": [" + NoUniqueBeanException.getBeanDescriptions(beanRules) + "]; Referer: " + refererInfo);
                    }
                    brokenReferences.add(refererKey);
                    continue;
                }
                int count = 0;
                for (RefererInfo refererInfo : refererInfoSet) {
                    if (this.isStaticMethodReference(refererInfo)) continue;
                    ++count;
                    log.error("Cannot resolve reference to bean " + refererKey + "; Referer: " + refererInfo);
                }
                if (count <= 0) continue;
                brokenReferences.add(refererKey);
                continue;
            }
            for (RefererInfo refererInfo : refererInfoSet) {
                if (refererInfo.getBeanRefererType() != BeanRefererType.BEAN_METHOD_ACTION_RULE) continue;
                this.checkTransletActionParameter((BeanMethodActionRule)refererInfo.getReferenceable(), beanRule, refererInfo);
            }
        }
        if (!brokenReferences.isEmpty()) {
            throw new BeanReferenceException(brokenReferences);
        }
    }

    private boolean isStaticMethodReference(RefererInfo refererInfo) {
        Token t;
        if (refererInfo.getBeanRefererType() == BeanRefererType.TOKEN && (t = (Token)refererInfo.getReferenceable()).getAlternativeValue() != null && t.getGetterName() != null) {
            return BeanUtils.hasReadableProperty((Class)t.getAlternativeValue(), t.getGetterName());
        }
        return false;
    }

    private void checkTransletActionParameter(BeanMethodActionRule beanMethodActionRule, BeanRule beanRule, RefererInfo refererInfo) throws BeanRuleException {
        if (beanMethodActionRule.getArgumentItemRuleMap() == null) {
            String methodName;
            Class<?> beanClass = beanRule.getTargetBeanClass();
            Method m1 = MethodUtils.getAccessibleMethod(beanClass, methodName = beanMethodActionRule.getMethodName(), BeanRuleAnalyzer.TRANSLET_ACTION_PARAMETER_TYPES);
            if (m1 != null) {
                beanMethodActionRule.setMethod(m1);
                beanMethodActionRule.setRequiresTranslet(true);
            } else {
                Method m2 = MethodUtils.getAccessibleMethod(beanClass, methodName);
                if (m2 == null) {
                    throw new BeanRuleException("No such bean method " + methodName + "() on bean " + beanClass + " in " + refererInfo, beanRule);
                }
                beanMethodActionRule.setMethod(m2);
                beanMethodActionRule.setRequiresTranslet(false);
            }
        }
    }

    private class RefererInfo {
        private final BeanReferenceable referenceable;
        private final RuleAppender ruleAppender;
        private final NodeTracker nodeTracker;

        RefererInfo(BeanReferenceable referenceable, RuleAppender ruleAppender) {
            NodeTracker nodeTracker;
            this.referenceable = referenceable;
            this.ruleAppender = ruleAppender;
            this.nodeTracker = ruleAppender != null ? ((nodeTracker = ruleAppender.getNodeTracker()) != null ? nodeTracker.getClonedNodeTracker() : null) : null;
        }

        BeanReferenceable getReferenceable() {
            return this.referenceable;
        }

        RuleAppender getRuleAppender() {
            return this.ruleAppender;
        }

        BeanRefererType getBeanRefererType() {
            return this.referenceable.getBeanRefererType();
        }

        NodeTracker getNodeTracker() {
            return this.nodeTracker;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ruleAppender != null) {
                sb.append(this.ruleAppender.getQualifiedName());
                if (this.nodeTracker != null) {
                    sb.append(" ");
                    sb.append(this.nodeTracker.toString());
                }
                sb.append(" ");
            }
            sb.append((Object)this.referenceable.getBeanRefererType());
            sb.append(" ");
            sb.append(this.referenceable);
            return sb.toString();
        }
    }

    private class RefererKey {
        private final Class<?> type;
        private final String qualifier;
        private volatile int hashCode;

        RefererKey(Class<?> type, String qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }

        Class<?> getType() {
            return this.type;
        }

        String getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            RefererKey key = (RefererKey)obj;
            return Objects.equals(this.type, key.type) && Objects.equals(this.qualifier, key.qualifier);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.hashCode;
            if (result == 0) {
                if (this.type != null) {
                    result = 31 * result + this.type.hashCode();
                }
                if (this.qualifier != null) {
                    result = 31 * result + this.qualifier.hashCode();
                }
                this.hashCode = result;
            }
            return result;
        }

        public String toString() {
            ToStringBuilder tsb = new ToStringBuilder();
            tsb.append("type", this.type);
            tsb.append("qualifier", this.qualifier);
            return tsb.toString();
        }
    }
}

