/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.template.TemplateRuleRegistry;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.env.ContextEnvironment;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.BeanReferenceInspector;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.context.rule.type.AutowireTargetType;
import com.aspectran.core.context.rule.type.DefaultSettingType;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextRuleAssistant {
    private final ContextEnvironment contextEnvironment;
    private final ApplicationAdapter applicationAdapter;
    private final String basePath;
    private final ClassLoader classLoader;
    private Map<DefaultSettingType, String> settings;
    private List<EnvironmentRule> environmentRules;
    private Map<String, String> typeAliases;
    private AspectRuleRegistry aspectRuleRegistry;
    private BeanRuleRegistry beanRuleRegistry;
    private ScheduleRuleRegistry scheduleRuleRegistry;
    private TransletRuleRegistry transletRuleRegistry;
    private TemplateRuleRegistry templateRuleRegistry;
    private BeanReferenceInspector beanReferenceInspector;
    private AssistantLocal assistantLocal;
    private RuleAppendHandler ruleAppendHandler;

    protected ContextRuleAssistant() {
        this(null);
    }

    public ContextRuleAssistant(ContextEnvironment contextEnvironment) {
        if (contextEnvironment != null) {
            this.contextEnvironment = contextEnvironment;
            this.applicationAdapter = contextEnvironment.getApplicationAdapter();
            this.basePath = contextEnvironment.getBasePath();
            this.classLoader = contextEnvironment.getClassLoader();
        } else {
            this.contextEnvironment = null;
            this.applicationAdapter = null;
            this.basePath = null;
            this.classLoader = null;
        }
    }

    public void ready() {
        this.settings = new HashMap<DefaultSettingType, String>();
        this.environmentRules = new LinkedList<EnvironmentRule>();
        this.typeAliases = new HashMap<String, String>();
        this.assistantLocal = new AssistantLocal(this);
        if (this.contextEnvironment != null) {
            this.aspectRuleRegistry = new AspectRuleRegistry();
            this.beanRuleRegistry = new BeanRuleRegistry(this.classLoader);
            this.transletRuleRegistry = new TransletRuleRegistry(this.contextEnvironment);
            this.transletRuleRegistry.setAssistantLocal(this.assistantLocal);
            this.scheduleRuleRegistry = new ScheduleRuleRegistry();
            this.scheduleRuleRegistry.setAssistantLocal(this.assistantLocal);
            this.templateRuleRegistry = new TemplateRuleRegistry();
            this.templateRuleRegistry.setAssistantLocal(this.assistantLocal);
            this.beanReferenceInspector = new BeanReferenceInspector();
        }
    }

    public void release() {
        this.settings = null;
        this.environmentRules = null;
        this.typeAliases = null;
        this.assistantLocal = null;
        if (this.contextEnvironment != null) {
            this.scheduleRuleRegistry.setAssistantLocal(null);
            this.transletRuleRegistry.setAssistantLocal(null);
            this.templateRuleRegistry.setAssistantLocal(null);
            this.aspectRuleRegistry = null;
            this.beanRuleRegistry = null;
            this.scheduleRuleRegistry = null;
            this.transletRuleRegistry = null;
            this.templateRuleRegistry = null;
            this.beanReferenceInspector = null;
        }
    }

    public ContextEnvironment getContextEnvironment() {
        return this.contextEnvironment;
    }

    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<DefaultSettingType, String> getSettings() {
        return this.settings;
    }

    public Object getSetting(DefaultSettingType settingType) {
        return this.settings.get((Object)settingType);
    }

    public void putSetting(String name, String value) throws IllegalRuleException {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalRuleException("Default setting name can not be null");
        }
        DefaultSettingType settingType = DefaultSettingType.resolve(name);
        if (settingType == null) {
            throw new IllegalRuleException("No such default setting name as '" + name + "'");
        }
        this.settings.put(settingType, value);
    }

    public void applySettings() {
        DefaultSettings defaultSettings = this.assistantLocal.touchDefaultSettings();
        defaultSettings.apply(this.getSettings());
    }

    public List<EnvironmentRule> getEnvironmentRules() {
        return this.environmentRules;
    }

    public void addEnvironmentRule(EnvironmentRule environmentRule) {
        this.environmentRules.add(environmentRule);
    }

    public Map<String, String> getTypeAliases() {
        return this.typeAliases;
    }

    public void addTypeAlias(String alias, String type) {
        this.typeAliases.put(alias, type);
    }

    public String getAliasedType(String alias) {
        return this.typeAliases.get(alias);
    }

    public String resolveAliasType(String alias) {
        String type = this.getAliasedType(alias);
        return type == null ? alias : type;
    }

    public String applyTransletNamePattern(String transletName) {
        if (transletName == null) {
            return null;
        }
        return this.transletRuleRegistry.applyTransletNamePattern(transletName, true);
    }

    public AssistantLocal getAssistantLocal() {
        return this.assistantLocal;
    }

    private void setAssistantLocal(AssistantLocal newAssistantLocal) {
        this.assistantLocal = newAssistantLocal;
        this.scheduleRuleRegistry.setAssistantLocal(newAssistantLocal);
        this.transletRuleRegistry.setAssistantLocal(newAssistantLocal);
        this.templateRuleRegistry.setAssistantLocal(newAssistantLocal);
    }

    public AssistantLocal backupAssistantLocal() {
        AssistantLocal oldAssistantLocal = this.assistantLocal;
        AssistantLocal newAssistantLocal = this.assistantLocal.replicate();
        this.setAssistantLocal(newAssistantLocal);
        return oldAssistantLocal;
    }

    public void restoreAssistantLocal(AssistantLocal oldAssistantLocal) {
        this.setAssistantLocal(oldAssistantLocal);
    }

    public boolean isPointcutPatternVerifiable() {
        DefaultSettings defaultSettings = this.assistantLocal.getDefaultSettings();
        return defaultSettings != null && defaultSettings.isPointcutPatternVerifiable();
    }

    public void resolveAdviceBeanClass(AspectRule aspectRule) throws IllegalRuleException {
        String beanIdOrClass = aspectRule.getAdviceBeanId();
        if (beanIdOrClass != null) {
            Class<?> beanClass = this.resolveBeanClass(beanIdOrClass, (Object)aspectRule);
            if (beanClass != null) {
                aspectRule.setAdviceBeanClass(beanClass);
                this.reserveBeanReference(beanClass, (BeanReferenceable)aspectRule);
            } else {
                this.reserveBeanReference(beanIdOrClass, (BeanReferenceable)aspectRule);
            }
        }
    }

    public void resolveActionBeanClass(BeanMethodActionRule beanMethodActionRule) throws IllegalRuleException {
        String beanIdOrClass = beanMethodActionRule.getBeanId();
        if (beanIdOrClass != null) {
            Class<?> beanClass = this.resolveBeanClass(beanIdOrClass, (Object)beanMethodActionRule);
            if (beanClass != null) {
                beanMethodActionRule.setBeanClass(beanClass);
                this.reserveBeanReference(beanClass, (BeanReferenceable)beanMethodActionRule);
            } else {
                this.reserveBeanReference(beanIdOrClass, (BeanReferenceable)beanMethodActionRule);
            }
        }
    }

    public void resolveFactoryBeanClass(BeanRule beanRule) throws IllegalRuleException {
        String beanIdOrClass = beanRule.getFactoryBeanId();
        if (beanRule.isFactoryOffered() && beanIdOrClass != null) {
            Class<?> beanClass = this.resolveBeanClass(beanIdOrClass, (Object)beanRule);
            if (beanClass != null) {
                beanRule.setFactoryBeanClass(beanClass);
                this.reserveBeanReference(beanClass, (BeanReferenceable)beanRule);
            } else {
                this.reserveBeanReference(beanIdOrClass, (BeanReferenceable)beanRule);
            }
        }
    }

    public void resolveBeanClass(ItemRule itemRule) throws IllegalRuleException {
        Iterator<Token[]> it = ItemRule.tokenIterator(itemRule);
        if (it != null) {
            while (it.hasNext()) {
                Token[] tokens = it.next();
                if (tokens == null) continue;
                for (Token token : tokens) {
                    this.resolveBeanClass(token);
                }
            }
        }
    }

    public void resolveBeanClass(Token[] tokens) throws IllegalRuleException {
        if (tokens != null) {
            for (Token token : tokens) {
                this.resolveBeanClass(token);
            }
        }
    }

    public void resolveBeanClass(Token token) throws IllegalRuleException {
        this.resolveBeanClass(token, token);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveBeanClass(Token token, BeanReferenceable referenceable) throws IllegalRuleException {
        if (token == null || token.getType() != TokenType.BEAN) return;
        if (token.getDirectiveType() == TokenDirectiveType.FIELD) {
            if (token.getGetterName() == null) {
                throw new IllegalRuleException("Target field name is unspecified token " + token);
            }
            Class<?> cls = this.loadClass(token.getValue(), token);
            try {
                Field field = cls.getField(token.getGetterName());
                token.setAlternativeValue(field);
                if (Modifier.isStatic(field.getModifiers())) return;
                this.reserveBeanReference(cls, referenceable);
                return;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalRuleException("Could not access field: " + token.getGetterName() + " on " + this.ruleAppendHandler.getCurrentRuleAppender().getQualifiedName() + " " + token, e);
            }
        } else if (token.getDirectiveType() == TokenDirectiveType.METHOD) {
            if (token.getGetterName() == null) {
                throw new IllegalRuleException("Target method name is unspecified token " + token);
            }
            Class<?> cls = this.loadClass(token.getValue(), token);
            try {
                Method method = cls.getMethod(token.getGetterName(), new Class[0]);
                token.setAlternativeValue(method);
                if (Modifier.isStatic(method.getModifiers())) return;
                this.reserveBeanReference(cls, referenceable);
                return;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalRuleException("Could not access method: " + token.getGetterName() + " on " + this.ruleAppendHandler.getCurrentRuleAppender().getQualifiedName() + " " + token, e);
            }
        } else if (token.getDirectiveType() == TokenDirectiveType.CLASS) {
            Class<?> cls = this.loadClass(token.getValue(), token);
            token.setAlternativeValue(cls);
            this.reserveBeanReference(cls, referenceable);
            return;
        } else {
            this.reserveBeanReference(token.getName(), referenceable);
        }
    }

    public void resolveBeanClass(AutowireRule autowireRule) throws IllegalRuleException {
        if (autowireRule.getTargetType() == AutowireTargetType.FIELD) {
            if (autowireRule.isRequired()) {
                Class<?>[] types = autowireRule.getTypes();
                String[] qualifiers = autowireRule.getQualifiers();
                this.reserveBeanReference(qualifiers[0], types[0], autowireRule);
            }
        } else if (autowireRule.getTargetType() == AutowireTargetType.FIELD_VALUE) {
            Token token = autowireRule.getToken();
            this.resolveBeanClass(token, autowireRule);
        } else if ((autowireRule.getTargetType() == AutowireTargetType.METHOD || autowireRule.getTargetType() == AutowireTargetType.CONSTRUCTOR) && autowireRule.isRequired()) {
            Class<?>[] types = autowireRule.getTypes();
            String[] qualifiers = autowireRule.getQualifiers();
            for (int i = 0; i < types.length; ++i) {
                this.reserveBeanReference(qualifiers[i], types[i], autowireRule);
            }
        }
    }

    public void resolveBeanClass(ScheduleRule scheduleRule) throws IllegalRuleException {
        String beanId = scheduleRule.getSchedulerBeanId();
        if (beanId != null) {
            Class<?> beanClass = this.resolveBeanClass(beanId, (Object)scheduleRule);
            if (beanClass != null) {
                scheduleRule.setSchedulerBeanClass(beanClass);
                this.reserveBeanReference(beanClass, (BeanReferenceable)scheduleRule);
            } else {
                this.reserveBeanReference(beanId, (BeanReferenceable)scheduleRule);
            }
        }
    }

    public void resolveBeanClass(TemplateRule templateRule) throws IllegalRuleException {
        String beanId = templateRule.getEngineBeanId();
        if (beanId != null) {
            Class<?> beanClass = this.resolveBeanClass(beanId, (Object)templateRule);
            if (beanClass != null) {
                templateRule.setEngineBeanClass(beanClass);
                this.reserveBeanReference(beanClass, (BeanReferenceable)templateRule);
            } else {
                this.reserveBeanReference(beanId, (BeanReferenceable)templateRule);
            }
        } else {
            this.resolveBeanClass(templateRule.getTemplateTokens());
        }
    }

    private Class<?> resolveBeanClass(String beanIdOrClass, Object referer) throws IllegalRuleException {
        if (beanIdOrClass != null && beanIdOrClass.startsWith("class:")) {
            String className = beanIdOrClass.substring("class:".length());
            return this.loadClass(className, referer);
        }
        return null;
    }

    private Class<?> loadClass(String className, Object referer) throws IllegalRuleException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalRuleException("Unable to load class: " + className + " on " + this.ruleAppendHandler.getCurrentRuleAppender().getQualifiedName() + " " + referer, e);
        }
    }

    public void reserveBeanReference(String beanId, BeanReferenceable referenceable) {
        this.reserveBeanReference(beanId, null, referenceable);
    }

    public void reserveBeanReference(Class<?> beanClass, BeanReferenceable referenceable) {
        this.reserveBeanReference(null, beanClass, referenceable);
    }

    public void reserveBeanReference(String beanId, Class<?> beanClass, BeanReferenceable referenceable) {
        this.beanReferenceInspector.reserve(beanId, beanClass, referenceable, this.ruleAppendHandler.getCurrentRuleAppender());
    }

    public BeanReferenceInspector getBeanReferenceInspector() {
        return this.beanReferenceInspector;
    }

    public void addAspectRule(AspectRule aspectRule) throws IllegalRuleException {
        this.aspectRuleRegistry.addAspectRule(aspectRule);
    }

    public void addBeanRule(BeanRule beanRule) throws IllegalRuleException {
        this.beanRuleRegistry.addBeanRule(beanRule);
    }

    public void addScheduleRule(ScheduleRule scheduleRule) throws IllegalRuleException {
        this.scheduleRuleRegistry.addScheduleRule(scheduleRule);
    }

    public void addTransletRule(TransletRule transletRule) throws IllegalRuleException {
        this.transletRuleRegistry.addTransletRule(transletRule);
    }

    public void addTemplateRule(TemplateRule templateRule) throws IllegalRuleException {
        this.templateRuleRegistry.addTemplateRule(templateRule);
    }

    public AspectRuleRegistry getAspectRuleRegistry() {
        return this.aspectRuleRegistry;
    }

    public BeanRuleRegistry getBeanRuleRegistry() {
        return this.beanRuleRegistry;
    }

    public ScheduleRuleRegistry getScheduleRuleRegistry() {
        return this.scheduleRuleRegistry;
    }

    public TransletRuleRegistry getTransletRuleRegistry() {
        return this.transletRuleRegistry;
    }

    public TemplateRuleRegistry getTemplateRuleRegistry() {
        return this.templateRuleRegistry;
    }

    public Collection<AspectRule> getAspectRules() {
        return this.aspectRuleRegistry.getAspectRules();
    }

    public Collection<BeanRule> getBeanRules() {
        Collection<BeanRule> idBasedBeanRules = this.beanRuleRegistry.getIdBasedBeanRules();
        Collection<Set<BeanRule>> typeBasedBeanRules = this.beanRuleRegistry.getTypeBasedBeanRules();
        Collection<BeanRule> configurableBeanRules = this.beanRuleRegistry.getConfigurableBeanRules();
        int capacity = idBasedBeanRules.size();
        for (Set<BeanRule> brs : typeBasedBeanRules) {
            capacity += brs.size();
        }
        capacity += configurableBeanRules.size();
        capacity = (int)((float)capacity / 0.9f) + 1;
        HashSet<BeanRule> beanRuleSet = new HashSet<BeanRule>(capacity, 0.9f);
        beanRuleSet.addAll(idBasedBeanRules);
        for (Set<BeanRule> brs : typeBasedBeanRules) {
            beanRuleSet.addAll(brs);
        }
        beanRuleSet.addAll(configurableBeanRules);
        return beanRuleSet;
    }

    public Collection<ScheduleRule> getScheduleRules() {
        return this.scheduleRuleRegistry.getScheduleRules();
    }

    public Collection<TransletRule> getTransletRules() {
        return this.transletRuleRegistry.getTransletRules();
    }

    public Collection<TemplateRule> getTemplateRules() {
        return this.templateRuleRegistry.getTemplateRules();
    }

    public RuleAppendHandler getRuleAppendHandler() {
        return this.ruleAppendHandler;
    }

    public void setRuleAppendHandler(RuleAppendHandler ruleAppendHandler) {
        this.ruleAppendHandler = ruleAppendHandler;
    }

    public void clearCurrentRuleAppender() {
        if (this.ruleAppendHandler != null) {
            this.ruleAppendHandler.setCurrentRuleAppender(null);
        }
    }

    public ItemRuleMap profiling(ItemRuleMap irm, ItemRuleMap presentIrm) {
        if (irm.getProfile() != null && this.getContextEnvironment() != null) {
            String[] profiles = StringUtils.splitCommaDelimitedString(irm.getProfile());
            if (this.getContextEnvironment().acceptsProfiles(profiles)) {
                if (presentIrm == null) {
                    return irm;
                }
                if (presentIrm.getCandidates() == null) {
                    irm.addCandidate(presentIrm);
                    irm.addCandidate(irm);
                    return irm;
                }
                irm.setCandidates(presentIrm.getCandidates());
                if (!presentIrm.isDummy()) {
                    presentIrm.setCandidates(null);
                    irm.addCandidate(presentIrm);
                }
                irm.addCandidate(irm);
                return irm;
            }
            if (presentIrm == null) {
                ItemRuleMap dummyIrm = new ItemRuleMap();
                dummyIrm.setDummy(true);
                dummyIrm.addCandidate(irm);
                return dummyIrm;
            }
            presentIrm.addCandidate(irm);
            return presentIrm;
        }
        if (presentIrm == null) {
            return irm;
        }
        if (presentIrm.getCandidates() == null) {
            irm.addCandidate(presentIrm);
            irm.addCandidate(irm);
            return irm;
        }
        irm.setCandidates(presentIrm.getCandidates());
        irm.addCandidate(irm);
        presentIrm.setCandidates(null);
        return irm;
    }
}

