/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.context.rule.type.DefaultSettingType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.PrefixSuffixPattern;
import java.util.Map;

public class DefaultSettings {
    private String transletNamePattern;
    private String transletNamePrefix;
    private String transletNameSuffix;
    private String beanProxifier;
    private Boolean pointcutPatternVerifiable;
    private String defaultTemplateEngineBean;
    private String defaultSchedulerBean;

    public DefaultSettings() {
    }

    public DefaultSettings(DefaultSettings ds) {
        this.transletNamePattern = ds.getTransletNamePattern();
        this.transletNamePrefix = ds.getTransletNamePrefix();
        this.transletNameSuffix = ds.getTransletNameSuffix();
        this.beanProxifier = ds.getBeanProxifier();
        this.pointcutPatternVerifiable = ds.getPointcutPatternVerifiable();
        this.defaultTemplateEngineBean = ds.getDefaultTemplateEngineBean();
        this.defaultSchedulerBean = ds.getDefaultSchedulerBean();
    }

    public String getTransletNamePattern() {
        return this.transletNamePattern;
    }

    public void setTransletNamePattern(String transletNamePattern) {
        PrefixSuffixPattern prefixSuffixPattern;
        this.transletNamePattern = transletNamePattern;
        if (transletNamePattern != null && (prefixSuffixPattern = new PrefixSuffixPattern()).split(transletNamePattern)) {
            this.transletNamePrefix = prefixSuffixPattern.getPrefix();
            this.transletNameSuffix = prefixSuffixPattern.getSuffix();
        }
    }

    public void setTransletNamePattern(String transletNamePrefix, String transletNameSuffix) {
        this.transletNamePattern = transletNamePrefix + '*' + transletNameSuffix;
        this.transletNamePrefix = transletNamePrefix;
        this.transletNameSuffix = transletNameSuffix;
    }

    public void setTransletNamePrefix(String transletNamePrefix) {
        if (this.transletNameSuffix != null) {
            this.setTransletNamePattern(transletNamePrefix, this.transletNameSuffix);
        } else {
            this.transletNamePrefix = transletNamePrefix;
        }
    }

    public void setTransletNameSuffix(String transletNameSuffix) {
        if (this.transletNamePrefix != null) {
            this.setTransletNamePattern(this.transletNamePrefix, transletNameSuffix);
        } else {
            this.transletNameSuffix = transletNameSuffix;
        }
    }

    public String getTransletNamePrefix() {
        return this.transletNamePrefix;
    }

    public String getTransletNameSuffix() {
        return this.transletNameSuffix;
    }

    public String getBeanProxifier() {
        return this.beanProxifier;
    }

    public void setBeanProxifier(String beanProxifier) {
        this.beanProxifier = beanProxifier;
    }

    public boolean isPointcutPatternVerifiable() {
        return BooleanUtils.toBoolean(this.pointcutPatternVerifiable, false);
    }

    public Boolean getPointcutPatternVerifiable() {
        return this.pointcutPatternVerifiable;
    }

    public void setPointcutPatternVerifiable(boolean pointcutPatternVerifiable) {
        this.pointcutPatternVerifiable = pointcutPatternVerifiable;
    }

    public String getDefaultTemplateEngineBean() {
        return this.defaultTemplateEngineBean;
    }

    public void setDefaultTemplateEngineBean(String defaultTemplateEngineBean) {
        this.defaultTemplateEngineBean = defaultTemplateEngineBean;
    }

    public String getDefaultSchedulerBean() {
        return this.defaultSchedulerBean;
    }

    public void setDefaultSchedulerBean(String defaultSchedulerBean) {
        this.defaultSchedulerBean = defaultSchedulerBean;
    }

    public void apply(Map<DefaultSettingType, String> settings) {
        if (settings.get((Object)DefaultSettingType.TRANSLET_NAME_PATTERN) != null) {
            this.setTransletNamePattern(settings.get((Object)DefaultSettingType.TRANSLET_NAME_PATTERN));
        }
        if (settings.get((Object)DefaultSettingType.TRANSLET_NAME_PREFIX) != null) {
            this.setTransletNamePrefix(settings.get((Object)DefaultSettingType.TRANSLET_NAME_PREFIX));
        }
        if (settings.get((Object)DefaultSettingType.TRANSLET_NAME_SUFFIX) != null) {
            this.setTransletNameSuffix(settings.get((Object)DefaultSettingType.TRANSLET_NAME_SUFFIX));
        }
        if (settings.get((Object)DefaultSettingType.BEAN_PROXIFIER) != null) {
            this.beanProxifier = settings.get((Object)DefaultSettingType.BEAN_PROXIFIER);
        }
        if (settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE) != null) {
            this.pointcutPatternVerifiable = settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE) == null || Boolean.parseBoolean(settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE));
        }
        if (settings.get((Object)DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN) != null) {
            this.defaultTemplateEngineBean = settings.get((Object)DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN);
        }
        if (settings.get((Object)DefaultSettingType.DEFAULT_SCHEDULER_BEAN) != null) {
            this.defaultSchedulerBean = settings.get((Object)DefaultSettingType.DEFAULT_SCHEDULER_BEAN);
        }
    }
}

