/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.converter;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseRuleMap;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.ability.ResponseRuleApplicable;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.params.ActionParameters;
import com.aspectran.core.context.rule.params.AdviceActionParameters;
import com.aspectran.core.context.rule.params.AdviceParameters;
import com.aspectran.core.context.rule.params.AppendParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.BeanParameters;
import com.aspectran.core.context.rule.params.CallParameters;
import com.aspectran.core.context.rule.params.ChooseParameters;
import com.aspectran.core.context.rule.params.ChooseWhenParameters;
import com.aspectran.core.context.rule.params.ConstructorParameters;
import com.aspectran.core.context.rule.params.ContentParameters;
import com.aspectran.core.context.rule.params.ContentsParameters;
import com.aspectran.core.context.rule.params.DefaultSettingsParameters;
import com.aspectran.core.context.rule.params.DispatchParameters;
import com.aspectran.core.context.rule.params.EnvironmentParameters;
import com.aspectran.core.context.rule.params.ExceptionParameters;
import com.aspectran.core.context.rule.params.ExceptionThrownParameters;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.params.ForwardParameters;
import com.aspectran.core.context.rule.params.ItemHolderParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.RedirectParameters;
import com.aspectran.core.context.rule.params.RequestParameters;
import com.aspectran.core.context.rule.params.ResponseParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.ScheduledJobParameters;
import com.aspectran.core.context.rule.params.SchedulerParameters;
import com.aspectran.core.context.rule.params.TemplateParameters;
import com.aspectran.core.context.rule.params.TransformParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.Parameters;
import java.util.Iterator;
import java.util.List;

public class ParamsToRuleConverter {
    private final ContextRuleAssistant assistant;

    public ParamsToRuleConverter(ContextRuleAssistant assistant) {
        this.assistant = assistant;
    }

    public void convertAsRule(RootParameters rootParameters) throws IllegalRuleException {
        if (rootParameters == null) {
            throw new IllegalArgumentException("rootParameters must not be null");
        }
        AspectranParameters aspectranParameters = (AspectranParameters)rootParameters.getParameters(RootParameters.aspectran);
        this.convertAsRule(aspectranParameters);
    }

    public void convertAsRule(AspectranParameters aspectranParameters) throws IllegalRuleException {
        List appendParametersList;
        List templateParametersList;
        List transletParametersList;
        List scheduleParametersList;
        List beanParametersList;
        List aspectParametersList;
        List environmentParametersList;
        Object typeAliasParameters;
        DefaultSettingsParameters defaultSettingsParameters;
        if (aspectranParameters == null) {
            throw new IllegalArgumentException("aspectranParameters must not be null");
        }
        String description = aspectranParameters.getString(AspectranParameters.description);
        if (description != null) {
            this.assistant.getAssistantLocal().setDescription(description);
        }
        if ((defaultSettingsParameters = (DefaultSettingsParameters)aspectranParameters.getParameters(AspectranParameters.settings)) != null) {
            this.convertAsDefaultSettings(defaultSettingsParameters);
        }
        if ((typeAliasParameters = aspectranParameters.getParameters(AspectranParameters.typeAlias)) != null) {
            this.convertAsTypeAlias((Parameters)typeAliasParameters);
        }
        if ((environmentParametersList = aspectranParameters.getParametersList(AspectranParameters.environment)) != null) {
            for (Object environmentParameters : environmentParametersList) {
                this.convertAsEnvironmentRule((EnvironmentParameters)environmentParameters);
            }
        }
        if ((aspectParametersList = aspectranParameters.getParametersList(AspectranParameters.aspect)) != null) {
            for (Object aspectParameters : aspectParametersList) {
                this.convertAsAspectRule((AspectParameters)aspectParameters);
            }
        }
        if ((beanParametersList = aspectranParameters.getParametersList(AspectranParameters.bean)) != null) {
            for (Object beanParameters : beanParametersList) {
                this.convertAsBeanRule((BeanParameters)beanParameters);
            }
        }
        if ((scheduleParametersList = aspectranParameters.getParametersList(AspectranParameters.schedule)) != null) {
            for (Object scheduleParameters : scheduleParametersList) {
                this.convertAsScheduleRule((ScheduleParameters)scheduleParameters);
            }
        }
        if ((transletParametersList = aspectranParameters.getParametersList(AspectranParameters.translet)) != null) {
            for (Object transletParameters : transletParametersList) {
                this.convertAsTransletRule((TransletParameters)transletParameters);
            }
        }
        if ((templateParametersList = aspectranParameters.getParametersList(AspectranParameters.template)) != null) {
            for (TemplateParameters templateParameters : templateParametersList) {
                this.convertAsTemplateRule(templateParameters);
            }
        }
        if ((appendParametersList = aspectranParameters.getParametersList(AspectranParameters.append)) != null) {
            for (AppendParameters appendParameters : appendParametersList) {
                this.convertAsPendingAppender(appendParameters);
            }
        }
    }

    private void convertAsPendingAppender(AppendParameters appendParameters) throws IllegalRuleException {
        RuleAppendHandler appendHandler = this.assistant.getRuleAppendHandler();
        if (appendHandler != null) {
            AspectranParameters aspectran = (AspectranParameters)appendParameters.getParameters(AppendParameters.aspectran);
            String profile = appendParameters.getString(AppendParameters.profile);
            if (aspectran != null) {
                AppendRule appendRule = AppendRule.newInstance(aspectran, profile);
                appendHandler.pending(appendRule);
            } else {
                String file = appendParameters.getString(AppendParameters.file);
                String resource = appendParameters.getString(AppendParameters.resource);
                String url = appendParameters.getString(AppendParameters.url);
                String format = appendParameters.getString(AppendParameters.format);
                AppendRule appendRule = AppendRule.newInstance(file, resource, url, format, profile);
                appendHandler.pending(appendRule);
            }
        }
    }

    private void convertAsDefaultSettings(DefaultSettingsParameters defaultSettingsParameters) throws IllegalRuleException {
        if (defaultSettingsParameters == null) {
            return;
        }
        for (String name : defaultSettingsParameters.getParameterNameSet()) {
            this.assistant.putSetting(name, defaultSettingsParameters.getString(name));
        }
        this.assistant.applySettings();
    }

    private void convertAsEnvironmentRule(EnvironmentParameters environmentParameters) throws IllegalRuleException {
        if (environmentParameters != null) {
            String description = environmentParameters.getString(EnvironmentParameters.description);
            String profile = StringUtils.emptyToNull(environmentParameters.getString(EnvironmentParameters.profile));
            List propertyItemHolderParametersList = environmentParameters.getParametersList(EnvironmentParameters.properties);
            EnvironmentRule environmentRule = EnvironmentRule.newInstance(profile);
            if (description != null) {
                environmentRule.setDescription(description);
            }
            if (propertyItemHolderParametersList != null) {
                for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                    ItemRuleMap propertyItemRuleMap = this.convertAsItemRuleMap(itemHolderParameters);
                    environmentRule.addPropertyItemRuleMap(propertyItemRuleMap);
                }
            }
            this.assistant.addEnvironmentRule(environmentRule);
        }
    }

    private void convertAsTypeAlias(Parameters parameters) {
        if (parameters != null) {
            for (String alias : parameters.getParameterNameSet()) {
                this.assistant.addTypeAlias(alias, parameters.getString(alias));
            }
        }
    }

    private void convertAsAspectRule(AspectParameters aspectParameters) throws IllegalRuleException {
        ExceptionParameters exceptionParameters;
        AdviceParameters adviceParameters;
        Object settingsParameters;
        JoinpointParameters joinpointParameters;
        String description = aspectParameters.getString(AspectParameters.description);
        String id = StringUtils.emptyToNull(aspectParameters.getString(AspectParameters.id));
        String order = aspectParameters.getString(AspectParameters.order);
        Boolean isolated = aspectParameters.getBoolean(AspectParameters.isolated);
        Boolean disabled = aspectParameters.getBoolean(AspectParameters.disabled);
        AspectRule aspectRule = AspectRule.newInstance(id, order, isolated, disabled);
        if (description != null) {
            aspectRule.setDescription(description);
        }
        if ((joinpointParameters = (JoinpointParameters)aspectParameters.getParameters(AspectParameters.joinpoint)) != null) {
            AspectRule.updateJoinpoint(aspectRule, joinpointParameters);
        }
        if ((settingsParameters = aspectParameters.getParameters(AspectParameters.settings)) != null) {
            SettingsAdviceRule settingsAdviceRule = SettingsAdviceRule.newInstance(aspectRule, settingsParameters);
            aspectRule.setSettingsAdviceRule(settingsAdviceRule);
        }
        if ((adviceParameters = (AdviceParameters)aspectParameters.getParameters(AspectParameters.advice)) != null) {
            AdviceActionParameters finallyAdviceParameters;
            AspectAdviceRule aspectAdviceRule;
            AdviceActionParameters aroundAdviceParameters;
            AdviceActionParameters afterAdviceParameters;
            AdviceActionParameters beforeAdviceParameters;
            String adviceBeanId = adviceParameters.getString(AdviceParameters.bean);
            if (!StringUtils.isEmpty(adviceBeanId)) {
                aspectRule.setAdviceBeanId(adviceBeanId);
            }
            if ((beforeAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.beforeAdvice)) != null) {
                ActionParameters actionParameters = (ActionParameters)beforeAdviceParameters.getParameters(AdviceActionParameters.action);
                AspectAdviceRule aspectAdviceRule2 = aspectRule.touchAspectAdviceRule(AspectAdviceType.BEFORE);
                this.convertAsActionRule(actionParameters, aspectAdviceRule2);
            }
            if ((afterAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.afterAdvice)) != null) {
                ActionParameters actionParameters = (ActionParameters)afterAdviceParameters.getParameters(AdviceActionParameters.action);
                AspectAdviceRule aspectAdviceRule3 = aspectRule.touchAspectAdviceRule(AspectAdviceType.AFTER);
                this.convertAsActionRule(actionParameters, aspectAdviceRule3);
            }
            if ((aroundAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.aroundAdvice)) != null) {
                ActionParameters actionParameters = (ActionParameters)aroundAdviceParameters.getParameters(AdviceActionParameters.action);
                aspectAdviceRule = aspectRule.touchAspectAdviceRule(AspectAdviceType.AROUND);
                this.convertAsActionRule(actionParameters, aspectAdviceRule);
            }
            if ((finallyAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.finallyAdvice)) != null) {
                ExceptionThrownParameters etParameters;
                aspectAdviceRule = aspectRule.touchAspectAdviceRule(AspectAdviceType.FINALLY);
                ActionParameters actionParameters = (ActionParameters)finallyAdviceParameters.getParameters(AdviceActionParameters.action);
                if (actionParameters != null) {
                    this.convertAsActionRule(actionParameters, aspectAdviceRule);
                }
                if ((etParameters = (ExceptionThrownParameters)finallyAdviceParameters.getParameters(AdviceActionParameters.thrown)) != null) {
                    ExceptionThrownRule etr = this.convertAsExceptionThrownRule(etParameters, aspectAdviceRule);
                    aspectAdviceRule.setExceptionThrownRule(etr);
                }
            }
        }
        if ((exceptionParameters = (ExceptionParameters)aspectParameters.getParameters(AspectParameters.exception)) != null) {
            ExceptionRule exceptionRule = new ExceptionRule();
            exceptionRule.setDescription(exceptionParameters.getString(ExceptionParameters.description));
            List etParametersList = exceptionParameters.getParametersList(ExceptionParameters.thrown);
            if (etParametersList != null) {
                for (ExceptionThrownParameters etParameters : etParametersList) {
                    ExceptionThrownRule etr = this.convertAsExceptionThrownRule(etParameters, null);
                    exceptionRule.putExceptionThrownRule(etr);
                }
            }
            aspectRule.setExceptionRule(exceptionRule);
        }
        this.assistant.resolveAdviceBeanClass(aspectRule);
        this.assistant.addAspectRule(aspectRule);
    }

    private void convertAsBeanRule(BeanParameters beanParameters) throws IllegalRuleException {
        List argumentItemHolderParametersList;
        String description = beanParameters.getString(BeanParameters.description);
        String id = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.id));
        String className = StringUtils.emptyToNull(this.assistant.resolveAliasType(beanParameters.getString(BeanParameters.className)));
        String scan = beanParameters.getString(BeanParameters.scan);
        String mask = beanParameters.getString(BeanParameters.mask);
        String scope = beanParameters.getString(BeanParameters.scope);
        Boolean singleton = beanParameters.getBoolean(BeanParameters.singleton);
        String factoryBean = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryBean));
        String factoryMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryMethod));
        String initMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.initMethod));
        String destroyMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.destroyMethod));
        Boolean lazyInit = beanParameters.getBoolean(BeanParameters.lazyInit);
        Boolean important = beanParameters.getBoolean(BeanParameters.important);
        ConstructorParameters constructorParameters = (ConstructorParameters)beanParameters.getParameters(BeanParameters.constructor);
        List propertyItemHolderParametersList = beanParameters.getParametersList(BeanParameters.properties);
        FilterParameters filterParameters = (FilterParameters)beanParameters.getParameters(BeanParameters.filter);
        BeanRule beanRule = className == null && scan == null && factoryBean != null ? BeanRule.newOfferedFactoryBeanInstance(id, factoryBean, factoryMethod, initMethod, destroyMethod, scope, singleton, lazyInit, important) : BeanRule.newInstance(id, className, scan, mask, initMethod, destroyMethod, factoryMethod, scope, singleton, lazyInit, important);
        if (description != null) {
            beanRule.setDescription(description);
        }
        if (filterParameters != null) {
            beanRule.setFilterParameters(filterParameters);
        }
        if (constructorParameters != null && (argumentItemHolderParametersList = constructorParameters.getParametersList(ConstructorParameters.arguments)) != null) {
            for (ItemHolderParameters itemHolderParameters : argumentItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getConstructorArgumentItemRuleMap());
                beanRule.setConstructorArgumentItemRuleMap(irm);
            }
        }
        if (propertyItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getPropertyItemRuleMap());
                beanRule.setPropertyItemRuleMap(irm);
            }
        }
        this.assistant.resolveFactoryBeanClass(beanRule);
        this.assistant.addBeanRule(beanRule);
    }

    private void convertAsScheduleRule(ScheduleParameters scheduleParameters) throws IllegalRuleException {
        SchedulerParameters schedulerParameters;
        String description = scheduleParameters.getString(AspectParameters.description);
        String id = StringUtils.emptyToNull(scheduleParameters.getString(AspectParameters.id));
        ScheduleRule scheduleRule = ScheduleRule.newInstance(id);
        if (description != null) {
            scheduleRule.setDescription(description);
        }
        if ((schedulerParameters = (SchedulerParameters)scheduleParameters.getParameters(ScheduleParameters.scheduler)) != null) {
            List jobParametersList;
            TriggerParameters triggerParameters;
            String schedulerBeanId = schedulerParameters.getString(SchedulerParameters.bean);
            if (!StringUtils.isEmpty(schedulerBeanId)) {
                scheduleRule.setSchedulerBeanId(schedulerBeanId);
            }
            if ((triggerParameters = (TriggerParameters)schedulerParameters.getParameters(SchedulerParameters.trigger)) != null) {
                ScheduleRule.updateTrigger(scheduleRule, triggerParameters);
            }
            if ((jobParametersList = scheduleParameters.getParametersList(ScheduleParameters.job)) != null) {
                for (ScheduledJobParameters jobParameters : jobParametersList) {
                    String translet = StringUtils.emptyToNull(jobParameters.getString(ScheduledJobParameters.translet));
                    Boolean disabled = jobParameters.getBoolean(ScheduledJobParameters.disabled);
                    translet = this.assistant.applyTransletNamePattern(translet);
                    ScheduledJobRule scheduledJobRule = ScheduledJobRule.newInstance(scheduleRule, translet, disabled);
                    scheduleRule.addScheduledJobRule(scheduledJobRule);
                }
            }
        }
        this.assistant.addScheduleRule(scheduleRule);
    }

    private void convertAsTransletRule(TransletParameters transletParameters) throws IllegalRuleException {
        List chooseParametersList;
        RedirectParameters redirectParameters;
        ForwardParameters forwardParameters;
        DispatchParameters dispatchParameters;
        TransformParameters transformParameters;
        List actionParametersList;
        ExceptionParameters exceptionParameters;
        List responseParametersList;
        List contentParametersList;
        ContentsParameters contentsParameters;
        List attributeItemHolderParametersList;
        List parameterItemHolderParametersList;
        RequestParameters requestParameters;
        String description = transletParameters.getString(TransletParameters.description);
        String name = StringUtils.emptyToNull(transletParameters.getString(TransletParameters.name));
        String scan = transletParameters.getString(TransletParameters.scan);
        String mask = transletParameters.getString(TransletParameters.mask);
        String method = transletParameters.getString(TransletParameters.method);
        TransletRule transletRule = TransletRule.newInstance(name, mask, scan, method);
        if (description != null) {
            transletRule.setDescription(description);
        }
        if ((requestParameters = (RequestParameters)transletParameters.getParameters(TransletParameters.request)) != null) {
            RequestRule requestRule = this.convertAsRequestRule(requestParameters);
            transletRule.setRequestRule(requestRule);
        }
        if ((parameterItemHolderParametersList = transletParameters.getParametersList(TransletParameters.parameters)) != null) {
            for (Object itemHolderParameters : parameterItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap((ItemHolderParameters)itemHolderParameters);
                RequestRule requestRule = transletRule.touchRequestRule(false);
                irm = this.assistant.profiling(irm, requestRule.getParameterItemRuleMap());
                requestRule.setParameterItemRuleMap(irm);
            }
        }
        if ((attributeItemHolderParametersList = transletParameters.getParametersList(TransletParameters.attributes)) != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                Iterator requestRule = transletRule.touchRequestRule(false);
                irm = this.assistant.profiling(irm, ((RequestRule)((Object)requestRule)).getAttributeItemRuleMap());
                ((RequestRule)((Object)requestRule)).setAttributeItemRuleMap(irm);
            }
        }
        if ((contentsParameters = (ContentsParameters)transletParameters.getParameters(TransletParameters.contents)) != null) {
            ContentList contentList = this.convertAsContentList(contentsParameters);
            transletRule.setContentList(contentList);
        }
        if ((contentParametersList = transletParameters.getParametersList(TransletParameters.content)) != null) {
            ContentList contentList = new ContentList(false);
            for (ContentParameters contentParameters : contentParametersList) {
                ActionList actionList = this.convertAsActionList(contentParameters);
                contentList.addActionList(actionList);
            }
            transletRule.setContentList(contentList);
        }
        if ((responseParametersList = transletParameters.getParametersList(TransletParameters.response)) != null) {
            for (ResponseParameters responseParameters : responseParametersList) {
                ResponseRule responseRule = this.convertAsResponseRule(responseParameters);
                transletRule.addResponseRule(responseRule);
            }
        }
        if ((exceptionParameters = (ExceptionParameters)transletParameters.getParameters(TransletParameters.exception)) != null) {
            ExceptionRule exceptionRule = new ExceptionRule();
            exceptionRule.setDescription(exceptionParameters.getString(ExceptionParameters.description));
            List etParametersList = exceptionParameters.getParametersList(ExceptionParameters.thrown);
            if (etParametersList != null) {
                for (Object etParameters : etParametersList) {
                    ExceptionThrownRule etr = this.convertAsExceptionThrownRule((ExceptionThrownParameters)etParameters, null);
                    exceptionRule.putExceptionThrownRule(etr);
                }
            }
            transletRule.setExceptionRule(exceptionRule);
        }
        if ((actionParametersList = transletParameters.getParametersList(TransletParameters.action)) != null) {
            ContentList contentList = new ContentList(false);
            ActionList actionList = new ActionList(false);
            contentList.addActionList(actionList);
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
            transletRule.setContentList(contentList);
        }
        if ((transformParameters = (TransformParameters)transletParameters.getParameters(TransletParameters.transform)) != null) {
            TransformRule transformRule = this.convertAsTransformRule(transformParameters);
            transletRule.applyResponseRule(transformRule);
        }
        if ((dispatchParameters = (DispatchParameters)transletParameters.getParameters(TransletParameters.dispatch)) != null) {
            DispatchRule dispatchRule = this.convertAsDispatchRule(dispatchParameters);
            transletRule.applyResponseRule(dispatchRule);
        }
        if ((forwardParameters = (ForwardParameters)transletParameters.getParameters(TransletParameters.forward)) != null) {
            ForwardRule forwardRule = this.convertAsForwardRule(forwardParameters);
            transletRule.applyResponseRule(forwardRule);
        }
        if ((redirectParameters = (RedirectParameters)transletParameters.getParameters(TransletParameters.redirect)) != null) {
            RedirectRule redirectRule = this.convertAsRedirectRule(redirectParameters);
            transletRule.applyResponseRule(redirectRule);
        }
        if ((chooseParametersList = transletParameters.getParametersList(TransletParameters.choose)) != null) {
            ChooseRuleMap chooseRuleMap = transletRule.touchChooseRuleMap();
            for (ChooseParameters chooseParameters : chooseParametersList) {
                int caseNo = chooseParameters.getInt(ChooseParameters.caseNo);
                ChooseRule chooseRule = chooseRuleMap.newChooseRule(caseNo);
                List chooseWhenParametersList = chooseParameters.getParametersList(ChooseParameters.when);
                Iterator iterator = chooseWhenParametersList.iterator();
                while (iterator.hasNext()) {
                    ChooseWhenParameters chooseWhenParameters = (ChooseWhenParameters)iterator.next();
                    caseNo = chooseWhenParameters.getInt(ChooseWhenParameters.caseNo);
                    ChooseWhenRule chooseWhenRule = chooseRule.newChooseWhenRule(caseNo);
                    chooseWhenRule.setExpression(chooseWhenParameters.getString(ChooseWhenParameters.test));
                    transformParameters = (TransformParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.transform);
                    if (transformParameters != null) {
                        TransformRule transformRule = this.convertAsTransformRule(transformParameters);
                        chooseWhenRule.applyResponseRule(transformRule);
                    }
                    if ((dispatchParameters = (DispatchParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.dispatch)) != null) {
                        DispatchRule dispatchRule = this.convertAsDispatchRule(dispatchParameters);
                        chooseWhenRule.applyResponseRule(dispatchRule);
                    }
                    if ((redirectParameters = (RedirectParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.redirect)) != null) {
                        RedirectRule redirectRule = this.convertAsRedirectRule(redirectParameters);
                        chooseWhenRule.applyResponseRule(redirectRule);
                    }
                    if ((forwardParameters = (ForwardParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.forward)) == null) continue;
                    ForwardRule forwardRule = this.convertAsForwardRule(forwardParameters);
                    chooseWhenRule.applyResponseRule(forwardRule);
                }
                ChooseWhenParameters caseOtherwiseParameters = (ChooseWhenParameters)chooseParameters.getParameters(ChooseParameters.otherwise);
                if (caseOtherwiseParameters == null) continue;
                caseNo = caseOtherwiseParameters.getInt(ChooseWhenParameters.caseNo);
                ChooseWhenRule chooseWhenRule = chooseRule.newChooseWhenRule(caseNo);
                transformParameters = (TransformParameters)caseOtherwiseParameters.getParameters(ChooseWhenParameters.transform);
                if (transformParameters != null) {
                    TransformRule transformRule = this.convertAsTransformRule(transformParameters);
                    chooseWhenRule.applyResponseRule(transformRule);
                }
                if ((dispatchParameters = (DispatchParameters)caseOtherwiseParameters.getParameters(ChooseWhenParameters.dispatch)) != null) {
                    DispatchRule dispatchRule = this.convertAsDispatchRule(dispatchParameters);
                    chooseWhenRule.applyResponseRule(dispatchRule);
                }
                if ((forwardParameters = (ForwardParameters)caseOtherwiseParameters.getParameters(ChooseWhenParameters.forward)) != null) {
                    ForwardRule forwardRule = this.convertAsForwardRule(forwardParameters);
                    chooseWhenRule.applyResponseRule(forwardRule);
                }
                if ((redirectParameters = (RedirectParameters)caseOtherwiseParameters.getParameters(ChooseWhenParameters.redirect)) == null) continue;
                RedirectRule redirectRule = this.convertAsRedirectRule(redirectParameters);
                chooseWhenRule.applyResponseRule(redirectRule);
            }
            for (ChooseRule chooseRule : chooseRuleMap.values()) {
                if (chooseRule.getChooseWhenRuleMap() == null) continue;
                for (ChooseWhenRule chooseWhenRule : chooseRule.getChooseWhenRuleMap().values()) {
                    Response response;
                    if (transletRule.getContentList() != null) {
                        for (ActionList actionList : transletRule.getContentList()) {
                            this.checkActionList(chooseRule, chooseWhenRule, actionList);
                        }
                    }
                    if (transletRule.getResponseRule() == null || (response = transletRule.getResponseRule().getResponse()) == null || response.getActionList() == null) continue;
                    this.checkActionList(chooseRule, chooseWhenRule, response.getActionList());
                }
            }
        }
        this.assistant.addTransletRule(transletRule);
    }

    private void checkActionList(ChooseRule chooseRule, ChooseWhenRule chooseWhenRule, ActionList actionList) throws IllegalRuleException {
        Executable prev = null;
        for (Executable action : actionList) {
            if (action.getCaseNo() == chooseWhenRule.getCaseNo()) {
                if (prev != null) {
                    prev.setLastInChooseWhen(false);
                }
                action.setLastInChooseWhen(true);
                prev = action;
                continue;
            }
            prev = null;
            if (action.getCaseNo() <= 0 || chooseRule.getChooseWhenRule(action.getCaseNo()) != null) continue;
            throw new IllegalRuleException("No matching case number: " + action.getCaseNo());
        }
    }

    private RequestRule convertAsRequestRule(RequestParameters requestParameters) throws IllegalRuleException {
        ItemRuleMap irm;
        String allowedMethod = requestParameters.getString(RequestParameters.method);
        String encoding = requestParameters.getString(RequestParameters.encoding);
        List parameterItemHolderParametersList = requestParameters.getParametersList(RequestParameters.parameters);
        List attributeItemHolderParametersList = requestParameters.getParametersList(RequestParameters.attributes);
        RequestRule requestRule = RequestRule.newInstance(allowedMethod, encoding);
        if (parameterItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : parameterItemHolderParametersList) {
                irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, requestRule.getParameterItemRuleMap());
                requestRule.setParameterItemRuleMap(irm);
            }
        }
        if (attributeItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, requestRule.getAttributeItemRuleMap());
                requestRule.setAttributeItemRuleMap(irm);
            }
        }
        return requestRule;
    }

    private ResponseRule convertAsResponseRule(ResponseParameters responseParameters) throws IllegalRuleException {
        RedirectParameters redirectParameters;
        ForwardParameters forwardParameters;
        DispatchParameters dispatchParameters;
        String name = responseParameters.getString(ResponseParameters.name);
        String encoding = responseParameters.getString(ResponseParameters.encoding);
        ResponseRule responseRule = ResponseRule.newInstance(name, encoding);
        TransformParameters transformParameters = (TransformParameters)responseParameters.getParameters(ResponseParameters.transform);
        if (transformParameters != null) {
            responseRule.applyResponseRule(this.convertAsTransformRule(transformParameters));
        }
        if ((dispatchParameters = (DispatchParameters)responseParameters.getParameters(ResponseParameters.dispatch)) != null) {
            responseRule.applyResponseRule(this.convertAsDispatchRule(dispatchParameters));
        }
        if ((forwardParameters = (ForwardParameters)responseParameters.getParameters(ResponseParameters.forward)) != null) {
            responseRule.applyResponseRule(this.convertAsForwardRule(forwardParameters));
        }
        if ((redirectParameters = (RedirectParameters)responseParameters.getParameters(ResponseParameters.redirect)) != null) {
            responseRule.applyResponseRule(this.convertAsRedirectRule(redirectParameters));
        }
        return responseRule;
    }

    private ContentList convertAsContentList(ContentsParameters contentsParameters) throws IllegalRuleException {
        String name = contentsParameters.getString(ContentsParameters.name);
        List contentParametersList = contentsParameters.getParametersList(ContentsParameters.content);
        ContentList contentList = ContentList.newInstance(name);
        if (contentParametersList != null) {
            for (ContentParameters contentParameters : contentParametersList) {
                ActionList actionList = this.convertAsActionList(contentParameters);
                contentList.addActionList(actionList);
            }
        }
        return contentList;
    }

    private ActionList convertAsActionList(ContentParameters contentParameters) throws IllegalRuleException {
        String name = contentParameters.getString(ContentParameters.name);
        List actionParametersList = contentParameters.getParametersList(ContentParameters.action);
        ActionList actionList = ActionList.newInstance(name);
        if (actionParametersList != null) {
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
        }
        return actionList;
    }

    private void convertAsActionRule(ActionParameters actionParameters, ActionRuleApplicable actionRuleApplicable) throws IllegalRuleException {
        String id = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.id));
        String method = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.method));
        String include = actionParameters.getString(ActionParameters.include);
        ItemHolderParameters echoItemHolderParameters = (ItemHolderParameters)actionParameters.getParameters(ActionParameters.echo);
        ItemHolderParameters headerItemHolderParameters = (ItemHolderParameters)actionParameters.getParameters(ActionParameters.headers);
        Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
        Integer caseNo = actionParameters.getInt(ActionParameters.caseNo);
        Executable action = null;
        if (include != null) {
            List attributeItemHolderParametersList;
            include = this.assistant.applyTransletNamePattern(include);
            IncludeActionRule includeActionRule = IncludeActionRule.newInstance(id, include, method, hidden);
            List parameterItemHolderParametersList = actionParameters.getParametersList(ActionParameters.parameters);
            if (parameterItemHolderParametersList != null) {
                for (Object itemHolderParameters : parameterItemHolderParametersList) {
                    ItemRuleMap irm = this.convertAsItemRuleMap((ItemHolderParameters)itemHolderParameters);
                    irm = this.assistant.profiling(irm, includeActionRule.getParameterItemRuleMap());
                    includeActionRule.setParameterItemRuleMap(irm);
                }
            }
            if ((attributeItemHolderParametersList = actionParameters.getParametersList(ActionParameters.attributes)) != null) {
                for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                    ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                    irm = this.assistant.profiling(irm, includeActionRule.getAttributeItemRuleMap());
                    includeActionRule.setAttributeItemRuleMap(irm);
                }
            }
            action = actionRuleApplicable.applyActionRule(includeActionRule);
        } else if (method != null) {
            List propertyItemHolderParametersList;
            String beanIdOrClass = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.bean));
            BeanMethodActionRule beanMethodActionRule = BeanMethodActionRule.newInstance(id, beanIdOrClass, method, hidden);
            List argumentItemHolderParametersList = actionParameters.getParametersList(ActionParameters.arguments);
            if (argumentItemHolderParametersList != null) {
                for (ItemHolderParameters itemHolderParameters : argumentItemHolderParametersList) {
                    ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                    irm = this.assistant.profiling(irm, beanMethodActionRule.getArgumentItemRuleMap());
                    beanMethodActionRule.setArgumentItemRuleMap(irm);
                }
            }
            if ((propertyItemHolderParametersList = actionParameters.getParametersList(ActionParameters.properties)) != null) {
                for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                    ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                    irm = this.assistant.profiling(irm, beanMethodActionRule.getPropertyItemRuleMap());
                    beanMethodActionRule.setPropertyItemRuleMap(irm);
                }
            }
            this.assistant.resolveActionBeanClass(beanMethodActionRule);
            action = actionRuleApplicable.applyActionRule(beanMethodActionRule);
        } else if (echoItemHolderParameters != null) {
            EchoActionRule echoActionRule = EchoActionRule.newInstance(id, hidden);
            ItemRuleMap attributeItemRuleMap = this.convertAsItemRuleMap(echoItemHolderParameters);
            echoActionRule.setAttributeItemRuleMap(attributeItemRuleMap);
            action = actionRuleApplicable.applyActionRule(echoActionRule);
        } else if (headerItemHolderParameters != null) {
            HeaderActionRule headerActionRule = HeaderActionRule.newInstance(id, hidden);
            ItemRuleMap headerItemRuleMap = this.convertAsItemRuleMap(headerItemHolderParameters);
            headerActionRule.setHeaderItemRuleMap(headerItemRuleMap);
            action = actionRuleApplicable.applyActionRule(headerActionRule);
        }
        if (action != null && caseNo != null) {
            action.setCaseNo(caseNo);
        }
    }

    private ExceptionThrownRule convertAsExceptionThrownRule(ExceptionThrownParameters exceptionThrownParameters, AspectAdviceRule aspectAdviceRule) throws IllegalRuleException {
        List<RedirectParameters> redirectParametersList;
        List<DispatchParameters> dispatchParametersList;
        List<TransformParameters> transformParametersList;
        ExceptionThrownRule exceptionThrownRule = new ExceptionThrownRule(aspectAdviceRule);
        String[] exceptionTypes = exceptionThrownParameters.getStringArray(ExceptionThrownParameters.type);
        exceptionThrownRule.setExceptionTypes(exceptionTypes);
        ActionParameters actionParameters = (ActionParameters)exceptionThrownParameters.getParameters(ExceptionThrownParameters.action);
        if (actionParameters != null) {
            this.convertAsActionRule(actionParameters, exceptionThrownRule);
        }
        if ((transformParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.transform)) != null && !transformParametersList.isEmpty()) {
            this.convertAsTransformRule(transformParametersList, exceptionThrownRule);
        }
        if ((dispatchParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.dispatch)) != null && !dispatchParametersList.isEmpty()) {
            this.convertAsDispatchRule(dispatchParametersList, exceptionThrownRule);
        }
        if ((redirectParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.redirect)) != null && !redirectParametersList.isEmpty()) {
            this.convertAsRedirectRule(redirectParametersList, exceptionThrownRule);
        }
        return exceptionThrownRule;
    }

    private void convertAsTransformRule(List<TransformParameters> transformParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (TransformParameters transformParameters : transformParametersList) {
            TransformRule transformRule = this.convertAsTransformRule(transformParameters);
            responseRuleApplicable.applyResponseRule(transformRule);
        }
    }

    private TransformRule convertAsTransformRule(TransformParameters transformParameters) throws IllegalRuleException {
        String transformType = transformParameters.getString(TransformParameters.type);
        String contentType = transformParameters.getString(TransformParameters.contentType);
        String encoding = transformParameters.getString(TransformParameters.encoding);
        List actionParametersList = transformParameters.getParametersList(TransformParameters.action);
        Boolean defaultResponse = transformParameters.getBoolean(TransformParameters.defaultResponse);
        Boolean pretty = transformParameters.getBoolean(TransformParameters.pretty);
        TemplateParameters templateParameters = (TemplateParameters)transformParameters.getParameters(TransformParameters.template);
        CallParameters callParameters = (CallParameters)transformParameters.getParameters(TransformParameters.call);
        TransformRule transformRule = TransformRule.newInstance(transformType, contentType, encoding, defaultResponse, pretty);
        if (actionParametersList != null && !actionParametersList.isEmpty()) {
            ActionList actionList = new ActionList(false);
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
            transformRule.setActionList(actionList);
        }
        if (callParameters != null) {
            String templateId = StringUtils.emptyToNull(callParameters.getString(CallParameters.template));
            TransformRule.updateTemplateId(transformRule, templateId);
        }
        if (templateParameters != null) {
            String engine = templateParameters.getString(TemplateParameters.engine);
            String name = templateParameters.getString(TemplateParameters.name);
            String file = templateParameters.getString(TemplateParameters.file);
            String resource = templateParameters.getString(TemplateParameters.resource);
            String url = templateParameters.getString(TemplateParameters.url);
            String content = templateParameters.getString(TemplateParameters.content);
            String style = templateParameters.getString(TemplateParameters.style);
            String encoding2 = templateParameters.getString(TemplateParameters.encoding);
            Boolean noCache = templateParameters.getBoolean(TemplateParameters.noCache);
            TemplateRule templateRule = TemplateRule.newInstanceForBuiltin(engine, name, file, resource, url, content, style, encoding2, noCache);
            transformRule.setTemplateRule(templateRule);
            this.assistant.resolveBeanClass(templateRule.getTemplateTokens());
        }
        return transformRule;
    }

    private void convertAsDispatchRule(List<DispatchParameters> dispatchParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (DispatchParameters dispatchParameters : dispatchParametersList) {
            DispatchRule dispatchRule = this.convertAsDispatchRule(dispatchParameters);
            responseRuleApplicable.applyResponseRule(dispatchRule);
        }
    }

    private DispatchRule convertAsDispatchRule(DispatchParameters dispatchParameters) throws IllegalRuleException {
        String name = dispatchParameters.getString(DispatchParameters.name);
        String dispatcherName = dispatchParameters.getString(DispatchParameters.dispatcher);
        String contentType = dispatchParameters.getString(DispatchParameters.contentType);
        String encoding = dispatchParameters.getString(DispatchParameters.encoding);
        List actionParametersList = dispatchParameters.getParametersList(DispatchParameters.action);
        Boolean defaultResponse = dispatchParameters.getBoolean(DispatchParameters.defaultResponse);
        DispatchRule dispatchRule = DispatchRule.newInstance(name, dispatcherName, contentType, encoding, defaultResponse);
        if (actionParametersList != null && !actionParametersList.isEmpty()) {
            ActionList actionList = new ActionList(false);
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
            dispatchRule.setActionList(actionList);
        }
        return dispatchRule;
    }

    private ForwardRule convertAsForwardRule(ForwardParameters forwardParameters) throws IllegalRuleException {
        String contentType = forwardParameters.getString(ForwardParameters.contentType);
        String translet = StringUtils.emptyToNull(forwardParameters.getString(ForwardParameters.translet));
        String method = StringUtils.emptyToNull(forwardParameters.getString(ForwardParameters.method));
        List attributeItemHolderParametersList = (List)forwardParameters.getParameters(ForwardParameters.attributes);
        List actionParametersList = forwardParameters.getParametersList(ForwardParameters.action);
        Boolean defaultResponse = forwardParameters.getBoolean(ForwardParameters.defaultResponse);
        translet = this.assistant.applyTransletNamePattern(translet);
        ForwardRule forwardRule = ForwardRule.newInstance(contentType, translet, method, defaultResponse);
        if (attributeItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, forwardRule.getAttributeItemRuleMap());
                forwardRule.setAttributeItemRuleMap(irm);
            }
        }
        if (actionParametersList != null && !actionParametersList.isEmpty()) {
            ActionList actionList = new ActionList(false);
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
            forwardRule.setActionList(actionList);
        }
        return forwardRule;
    }

    private void convertAsRedirectRule(List<RedirectParameters> redirectParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (RedirectParameters redirectParameters : redirectParametersList) {
            RedirectRule redirectRule = this.convertAsRedirectRule(redirectParameters);
            responseRuleApplicable.applyResponseRule(redirectRule);
        }
    }

    private RedirectRule convertAsRedirectRule(RedirectParameters redirectParameters) throws IllegalRuleException {
        String contentType = redirectParameters.getString(RedirectParameters.contentType);
        String path = redirectParameters.getString(RedirectParameters.path);
        List parameterItemHolderParametersList = redirectParameters.getParametersList(RedirectParameters.parameters);
        String encoding = redirectParameters.getString(RedirectParameters.encoding);
        Boolean excludeNullParameters = redirectParameters.getBoolean(RedirectParameters.excludeNullParameters);
        Boolean excludeEmptyParameters = redirectParameters.getBoolean(RedirectParameters.excludeEmptyParameters);
        Boolean defaultResponse = redirectParameters.getBoolean(RedirectParameters.defaultResponse);
        List actionParametersList = redirectParameters.getParametersList(RedirectParameters.action);
        RedirectRule redirectRule = RedirectRule.newInstance(contentType, path, encoding, excludeNullParameters, excludeEmptyParameters, defaultResponse);
        if (parameterItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : parameterItemHolderParametersList) {
                ItemRuleMap irm = this.convertAsItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, redirectRule.getParameterItemRuleMap());
                redirectRule.setParameterItemRuleMap(irm);
            }
        }
        if (actionParametersList != null && !actionParametersList.isEmpty()) {
            ActionList actionList = new ActionList(false);
            for (ActionParameters actionParameters : actionParametersList) {
                this.convertAsActionRule(actionParameters, actionList);
            }
            redirectRule.setActionList(actionList);
        }
        return redirectRule;
    }

    private ItemRuleMap convertAsItemRuleMap(ItemHolderParameters itemHolderParameters) throws IllegalRuleException {
        String profile = itemHolderParameters.getProfile();
        List<ItemParameters> itemParametersList = itemHolderParameters.getParametersList();
        ItemRuleMap itemRuleMap = ItemRule.toItemRuleMap(itemParametersList);
        if (itemRuleMap != null) {
            itemRuleMap.setProfile(profile);
            for (ItemRule itemRule : itemRuleMap.values()) {
                this.assistant.resolveBeanClass(itemRule);
            }
        }
        return itemRuleMap;
    }

    private void convertAsTemplateRule(TemplateParameters templateParameters) throws IllegalRuleException {
        String id = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.id));
        String engine = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.engine));
        String name = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.name));
        String file = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.file));
        String resource = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.resource));
        String url = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.url));
        String content = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.content));
        String style = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.style));
        String encoding = templateParameters.getString(TemplateParameters.encoding);
        Boolean noCache = templateParameters.getBoolean(TemplateParameters.noCache);
        TemplateRule templateRule = TemplateRule.newInstance(id, engine, name, file, resource, url, content, style, encoding, noCache);
        this.assistant.addTemplateRule(templateRule);
    }
}

