/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.converter;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.RedirectResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseMap;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.context.rule.AnnotatedMethodActionRule;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.context.rule.params.ActionParameters;
import com.aspectran.core.context.rule.params.AdviceActionParameters;
import com.aspectran.core.context.rule.params.AdviceParameters;
import com.aspectran.core.context.rule.params.AppendParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.BeanParameters;
import com.aspectran.core.context.rule.params.CallParameters;
import com.aspectran.core.context.rule.params.ChooseParameters;
import com.aspectran.core.context.rule.params.ChooseWhenParameters;
import com.aspectran.core.context.rule.params.ConstructorParameters;
import com.aspectran.core.context.rule.params.ContentParameters;
import com.aspectran.core.context.rule.params.ContentsParameters;
import com.aspectran.core.context.rule.params.DefaultSettingsParameters;
import com.aspectran.core.context.rule.params.DispatchParameters;
import com.aspectran.core.context.rule.params.EnvironmentParameters;
import com.aspectran.core.context.rule.params.ExceptionParameters;
import com.aspectran.core.context.rule.params.ExceptionThrownParameters;
import com.aspectran.core.context.rule.params.ForwardParameters;
import com.aspectran.core.context.rule.params.ItemHolderParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.RedirectParameters;
import com.aspectran.core.context.rule.params.RequestParameters;
import com.aspectran.core.context.rule.params.ResponseParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.ScheduledJobParameters;
import com.aspectran.core.context.rule.params.SchedulerParameters;
import com.aspectran.core.context.rule.params.TemplateParameters;
import com.aspectran.core.context.rule.params.TransformParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.core.util.TextStyler;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterDefinition;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.VariableParameters;
import java.util.List;
import java.util.Map;

public class RuleToParamsConverter {
    private final ContextRuleAssistant assistant;

    public RuleToParamsConverter(ContextRuleAssistant assistant) {
        this.assistant = assistant;
    }

    public RootParameters toRootParameters() {
        RootParameters rootParameters = new RootParameters();
        rootParameters.putValue(RootParameters.aspectran, (Object)this.toAspectranParameters());
        return rootParameters;
    }

    private AspectranParameters toAspectranParameters() {
        Map<String, String> typeAliases;
        List<EnvironmentRule> environmentRules;
        AspectranParameters aspectranParameters = new AspectranParameters();
        AssistantLocal assistantLocal = this.assistant.getAssistantLocal();
        aspectranParameters.putValueNonNull(AspectranParameters.description, (Object)assistantLocal.getDescription());
        DefaultSettings defaultSettings = assistantLocal.getDefaultSettings();
        if (defaultSettings != null) {
            DefaultSettingsParameters settingParameters = (DefaultSettingsParameters)aspectranParameters.newParameters(AspectranParameters.settings);
            if (defaultSettings.getTransletNamePattern() != null) {
                settingParameters.putValue(DefaultSettingsParameters.transletNamePattern, (Object)defaultSettings.getTransletNamePattern());
            } else {
                settingParameters.putValueNonNull(DefaultSettingsParameters.transletNamePrefix, (Object)defaultSettings.getTransletNamePrefix());
                settingParameters.putValueNonNull(DefaultSettingsParameters.transletNameSuffix, (Object)defaultSettings.getTransletNameSuffix());
            }
            settingParameters.putValueNonNull(DefaultSettingsParameters.beanProxifier, (Object)defaultSettings.getBeanProxifier());
            settingParameters.putValueNonNull(DefaultSettingsParameters.pointcutPatternVerifiable, (Object)defaultSettings.getPointcutPatternVerifiable());
            settingParameters.putValueNonNull(DefaultSettingsParameters.defaultTemplateEngineBean, (Object)defaultSettings.getDefaultTemplateEngineBean());
            settingParameters.putValueNonNull(DefaultSettingsParameters.defaultSchedulerBean, (Object)defaultSettings.getDefaultSchedulerBean());
        }
        if (!(environmentRules = this.assistant.getEnvironmentRules()).isEmpty()) {
            for (EnvironmentRule environmentRule : environmentRules) {
                EnvironmentParameters p2 = RuleToParamsConverter.toEnvironmentParameters(environmentRule);
                aspectranParameters.putValue(AspectranParameters.environment, (Object)p2);
            }
        }
        if (!(typeAliases = this.assistant.getTypeAliases()).isEmpty()) {
            Object typeAliasParameters = aspectranParameters.newParameters(AspectranParameters.typeAlias);
            for (Map.Entry entry : typeAliases.entrySet()) {
                typeAliasParameters.putValue((String)entry.getKey(), entry.getValue());
            }
        }
        for (AspectRule aspectRule : this.assistant.getAspectRules()) {
            AspectParameters aspectParameters = RuleToParamsConverter.toAspectParameters(aspectRule);
            aspectranParameters.putValue(AspectranParameters.aspect, (Object)aspectParameters);
        }
        for (BeanRule beanRule : this.assistant.getBeanRules()) {
            BeanParameters beanParameters = RuleToParamsConverter.toBeanParameters(beanRule);
            aspectranParameters.putValue(AspectranParameters.bean, (Object)beanParameters);
        }
        for (ScheduleRule scheduleRule : this.assistant.getScheduleRules()) {
            ScheduleParameters scheduleParameters = RuleToParamsConverter.toScheduleParameters(scheduleRule);
            aspectranParameters.putValue(AspectranParameters.schedule, (Object)scheduleParameters);
        }
        for (TransletRule transletRule : this.assistant.getTransletRules()) {
            TransletParameters transletParameters = RuleToParamsConverter.toTransletParameters(transletRule);
            aspectranParameters.putValue(AspectranParameters.translet, (Object)transletParameters);
        }
        for (TemplateRule templateRule : this.assistant.getTemplateRules()) {
            TemplateParameters templateParameters = RuleToParamsConverter.toTemplateParameters(templateRule);
            aspectranParameters.putValue(AspectranParameters.template, (Object)templateParameters);
        }
        List<RuleAppender> appenders = this.assistant.getRuleAppendHandler().getPendingList();
        if (appenders != null) {
            for (RuleAppender ruleAppender : appenders) {
                aspectranParameters.putValue(AspectranParameters.append, (Object)this.toAppendParameters(ruleAppender));
            }
        }
        return aspectranParameters;
    }

    private AppendParameters toAppendParameters(RuleAppender appender) {
        AppendRule appendRule = appender.getAppendRule();
        if (appendRule == null) {
            throw new IllegalArgumentException("Every appender except Root Appender requires an AppendRule");
        }
        return RuleToParamsConverter.toAppendParameters(appendRule);
    }

    public static AppendParameters toAppendParameters(AppendRule appendRule) {
        if (appendRule == null) {
            throw new IllegalArgumentException("appendRule must not be null");
        }
        AppendParameters appendParameters = new AppendParameters();
        appendParameters.putValueNonNull(AppendParameters.file, (Object)appendRule.getFile());
        appendParameters.putValueNonNull(AppendParameters.resource, (Object)appendRule.getResource());
        appendParameters.putValueNonNull(AppendParameters.url, (Object)appendRule.getUrl());
        appendParameters.putValueNonNull(AppendParameters.format, (Object)appendRule.getFormat());
        appendParameters.putValueNonNull(AppendParameters.profile, (Object)appendRule.getProfile());
        appendParameters.putValueNonNull(AppendParameters.aspectran, (Object)appendRule.getAspectranParameters());
        return appendParameters;
    }

    public static EnvironmentParameters toEnvironmentParameters(EnvironmentRule environmentRule) {
        if (environmentRule == null) {
            throw new IllegalArgumentException("environmentRule must not be null");
        }
        EnvironmentParameters environmentParameters = new EnvironmentParameters();
        environmentParameters.putValueNonNull(EnvironmentParameters.description, (Object)environmentRule.getDescription());
        environmentParameters.putValueNonNull(EnvironmentParameters.profile, (Object)environmentRule.getProfile());
        if (environmentRule.getPropertyItemRuleMapList() != null) {
            for (ItemRuleMap propertyItemRuleMap : environmentRule.getPropertyItemRuleMapList()) {
                ItemHolderParameters itemHolderParameters = RuleToParamsConverter.toItemHolderParameters(propertyItemRuleMap);
                environmentParameters.putValue(EnvironmentParameters.properties, (Object)itemHolderParameters);
            }
        }
        return environmentParameters;
    }

    public static AspectParameters toAspectParameters(AspectRule aspectRule) {
        ExceptionRule exceptionRule;
        Map<String, Object> settings;
        JoinpointParameters joinpointParameters;
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        AspectParameters aspectParameters = new AspectParameters();
        aspectParameters.putValueNonNull(AspectParameters.description, (Object)aspectRule.getDescription());
        aspectParameters.putValueNonNull(AspectParameters.id, (Object)aspectRule.getId());
        if (aspectRule.getOrder() != Integer.MAX_VALUE) {
            aspectParameters.putValueNonNull(AspectParameters.order, (Object)aspectRule.getOrder());
        }
        aspectParameters.putValueNonNull(AspectParameters.isolated, (Object)aspectRule.getIsolated());
        aspectParameters.putValueNonNull(AspectParameters.disabled, (Object)aspectRule.getDisabled());
        if (aspectRule.getJoinpointRule() != null && (joinpointParameters = aspectRule.getJoinpointRule().getJoinpointParameters()) != null) {
            joinpointParameters.putValueNonNull(JoinpointParameters.target, (Object)aspectRule.getJoinpointTargetType());
            aspectParameters.putValue(AspectParameters.joinpoint, (Object)joinpointParameters);
        }
        if (aspectRule.getSettingsAdviceRule() != null && (settings = aspectRule.getSettingsAdviceRule().getSettings()) != null) {
            Object settingsParameters = aspectParameters.newParameters(AspectParameters.settings);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                settingsParameters.putValue(entry.getKey(), entry.getValue());
            }
        }
        if (aspectRule.getAspectAdviceRuleList() != null) {
            AdviceParameters adviceParameters = (AdviceParameters)aspectParameters.newParameters(AspectParameters.advice);
            adviceParameters.putValue(AdviceParameters.bean, (Object)aspectRule.getAdviceBeanId());
            for (AspectAdviceRule aspectAdviceRule : aspectRule.getAspectAdviceRuleList()) {
                AdviceActionParameters adviceActionParameters;
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.BEFORE) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.beforeAdvice);
                    RuleToParamsConverter.applyAdviceActionParameters(aspectAdviceRule, adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AFTER) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.afterAdvice);
                    RuleToParamsConverter.applyAdviceActionParameters(aspectAdviceRule, adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AROUND) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.aroundAdvice);
                    RuleToParamsConverter.applyAdviceActionParameters(aspectAdviceRule, adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() != AspectAdviceType.FINALLY) continue;
                adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.finallyAdvice);
                if (aspectAdviceRule.getExceptionThrownRule() != null) {
                    adviceActionParameters.putValue(AdviceActionParameters.thrown, (Object)RuleToParamsConverter.toExceptionThrownParameters(aspectAdviceRule.getExceptionThrownRule()));
                }
                RuleToParamsConverter.applyAdviceActionParameters(aspectAdviceRule, adviceActionParameters);
            }
        }
        if ((exceptionRule = aspectRule.getExceptionRule()) != null) {
            ExceptionParameters exceptionParameters = (ExceptionParameters)aspectParameters.touchParameters(AspectParameters.exception);
            exceptionParameters.putValueNonNull(ExceptionParameters.description, (Object)exceptionRule.getDescription());
            for (ExceptionThrownRule etr : exceptionRule.getExceptionThrownRuleList()) {
                exceptionParameters.putValue(ExceptionParameters.thrown, (Object)RuleToParamsConverter.toExceptionThrownParameters(etr));
            }
        }
        return aspectParameters;
    }

    public static BeanParameters toBeanParameters(BeanRule beanRule) {
        ItemRuleMap propertyItemRuleMap;
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        BeanParameters beanParameters = new BeanParameters();
        beanParameters.putValueNonNull(BeanParameters.description, (Object)beanRule.getDescription());
        beanParameters.putValueNonNull(BeanParameters.id, (Object)beanRule.getId());
        beanParameters.putValueNonNull(BeanParameters.className, (Object)beanRule.getClassName());
        beanParameters.putValueNonNull(BeanParameters.scan, (Object)beanRule.getScanPattern());
        beanParameters.putValueNonNull(BeanParameters.mask, (Object)beanRule.getMaskPattern());
        if (beanRule.getSingleton() == Boolean.TRUE && beanRule.getScopeType() == ScopeType.SINGLETON) {
            beanParameters.putValue(BeanParameters.singleton, (Object)beanRule.getSingleton());
        } else if (beanRule.getScopeType() != null) {
            beanParameters.putValue(BeanParameters.scope, (Object)beanRule.getScopeType().toString());
        }
        beanParameters.putValueNonNull(BeanParameters.factoryBean, (Object)beanRule.getFactoryBeanId());
        beanParameters.putValueNonNull(BeanParameters.factoryMethod, (Object)beanRule.getFactoryMethodName());
        beanParameters.putValueNonNull(BeanParameters.initMethod, (Object)beanRule.getInitMethodName());
        beanParameters.putValueNonNull(BeanParameters.destroyMethod, (Object)beanRule.getDestroyMethodName());
        beanParameters.putValueNonNull(BeanParameters.lazyInit, (Object)beanRule.getLazyInit());
        beanParameters.putValueNonNull(BeanParameters.important, (Object)beanRule.getImportant());
        beanParameters.putValueNonNull(BeanParameters.filter, (Object)beanRule.getFilterParameters());
        ItemRuleMap constructorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
        if (constructorArgumentItemRuleMap != null) {
            ConstructorParameters constructorParameters = (ConstructorParameters)beanParameters.newParameters(BeanParameters.constructor);
            RuleToParamsConverter.toItemHolderParameters(constructorArgumentItemRuleMap, constructorParameters, ConstructorParameters.arguments);
        }
        if ((propertyItemRuleMap = beanRule.getPropertyItemRuleMap()) != null) {
            RuleToParamsConverter.toItemHolderParameters(propertyItemRuleMap, beanParameters, BeanParameters.properties);
        }
        return beanParameters;
    }

    public static ScheduleParameters toScheduleParameters(ScheduleRule scheduleRule) {
        List<ScheduledJobRule> scheduledJobRuleList;
        if (scheduleRule == null) {
            throw new IllegalArgumentException("scheduleRule must not be null");
        }
        ScheduleParameters scheduleParameters = new ScheduleParameters();
        scheduleParameters.putValueNonNull(ScheduleParameters.description, (Object)scheduleRule.getDescription());
        scheduleParameters.putValueNonNull(ScheduleParameters.id, (Object)scheduleRule.getId());
        SchedulerParameters schedulerParameters = (SchedulerParameters)scheduleParameters.newParameters(ScheduleParameters.scheduler);
        schedulerParameters.putValueNonNull(SchedulerParameters.bean, (Object)scheduleRule.getSchedulerBeanId());
        TriggerParameters triggerParameters = scheduleRule.getTriggerParameters();
        if (triggerParameters != null && scheduleRule.getTriggerType() != null) {
            triggerParameters.putValueNonNull(TriggerParameters.type, (Object)scheduleRule.getTriggerType().toString());
            schedulerParameters.putValue(SchedulerParameters.trigger, (Object)scheduleRule.getTriggerParameters());
        }
        if ((scheduledJobRuleList = scheduleRule.getScheduledJobRuleList()) != null) {
            for (ScheduledJobRule scheduledJobRule : scheduledJobRuleList) {
                scheduleParameters.putValue(ScheduleParameters.job, (Object)RuleToParamsConverter.toScheduledJobParameters(scheduledJobRule));
            }
        }
        return scheduleParameters;
    }

    public static ScheduledJobParameters toScheduledJobParameters(ScheduledJobRule scheduledJobRule) {
        if (scheduledJobRule == null) {
            throw new IllegalArgumentException("scheduledJobRule must not be null");
        }
        ScheduledJobParameters jobParameters = new ScheduledJobParameters();
        jobParameters.putValue(ScheduledJobParameters.translet, (Object)scheduledJobRule.getTransletName());
        jobParameters.putValueNonNull(ScheduledJobParameters.disabled, (Object)scheduledJobRule.getDisabled());
        return jobParameters;
    }

    public static TransletParameters toTransletParameters(TransletRule transletRule) {
        ExceptionRule exceptionRule;
        List<ResponseRule> responseRuleList;
        ContentList contentList;
        RequestRule requestRule;
        if (transletRule == null) {
            throw new IllegalArgumentException("transletRule must not be null");
        }
        TransletParameters transletParameters = new TransletParameters();
        transletParameters.putValueNonNull(TransletParameters.description, (Object)transletRule.getDescription());
        transletParameters.putValueNonNull(TransletParameters.name, (Object)transletRule.getName());
        transletParameters.putValueNonNull(TransletParameters.scan, (Object)transletRule.getScanPath());
        transletParameters.putValueNonNull(TransletParameters.mask, (Object)transletRule.getMaskPattern());
        if (transletRule.getAllowedMethods() != null) {
            transletParameters.putValue(TransletParameters.method, (Object)MethodType.stringify(transletRule.getAllowedMethods()));
        }
        if ((requestRule = transletRule.getRequestRule()) != null) {
            if (requestRule.isExplicit()) {
                ItemRuleMap attributeItemRuleMap;
                RequestParameters requestParameters = (RequestParameters)transletParameters.newParameters(TransletParameters.request);
                requestParameters.putValueNonNull(RequestParameters.method, (Object)requestRule.getAllowedMethod());
                requestParameters.putValueNonNull(RequestParameters.encoding, (Object)requestRule.getEncoding());
                ItemRuleMap parameterItemRuleMap = requestRule.getParameterItemRuleMap();
                if (parameterItemRuleMap != null) {
                    RuleToParamsConverter.toItemHolderParameters(parameterItemRuleMap, requestParameters, RequestParameters.parameters);
                }
                if ((attributeItemRuleMap = requestRule.getAttributeItemRuleMap()) != null) {
                    RuleToParamsConverter.toItemHolderParameters(attributeItemRuleMap, requestParameters, RequestParameters.attributes);
                }
            } else {
                ItemRuleMap attributeItemRuleMap;
                ItemRuleMap parameterItemRuleMap = requestRule.getParameterItemRuleMap();
                if (parameterItemRuleMap != null) {
                    RuleToParamsConverter.toItemHolderParameters(parameterItemRuleMap, transletParameters, TransletParameters.parameters);
                }
                if ((attributeItemRuleMap = requestRule.getAttributeItemRuleMap()) != null) {
                    RuleToParamsConverter.toItemHolderParameters(attributeItemRuleMap, transletParameters, TransletParameters.attributes);
                }
            }
        }
        if (transletRule.getChooseRuleMap() != null) {
            for (ChooseRule chooseRule : transletRule.getChooseRuleMap().values()) {
                ChooseParameters chooseParameters = (ChooseParameters)transletParameters.newParameters(TransletParameters.choose);
                chooseParameters.putValue(ChooseParameters.caseNo, (Object)chooseRule.getCaseNo());
                if (chooseRule.getChooseWhenRuleMap() == null) continue;
                for (ChooseWhenRule chooseWhenRule : chooseRule.getChooseWhenRuleMap().values()) {
                    ChooseWhenParameters chooseWhenParameters = chooseWhenRule.getExpression() != null ? (ChooseWhenParameters)chooseParameters.newParameters(ChooseParameters.when) : (ChooseWhenParameters)chooseParameters.newParameters(ChooseParameters.otherwise);
                    chooseWhenParameters.putValue(ChooseWhenParameters.caseNo, (Object)chooseWhenRule.getCaseNo());
                    chooseWhenParameters.putValueNonNull(ChooseWhenParameters.test, (Object)chooseWhenRule.getExpression());
                    if (chooseWhenRule.getResponse() == null) continue;
                    Response response = chooseWhenRule.getResponse();
                    if (response.getResponseType() == ResponseType.TRANSFORM) {
                        TransformResponse transformResponse = (TransformResponse)response;
                        chooseWhenParameters.putValue(ChooseWhenParameters.transform, (Object)RuleToParamsConverter.toTransformParameters(transformResponse.getTransformRule()));
                        continue;
                    }
                    if (response.getResponseType() == ResponseType.DISPATCH) {
                        DispatchResponse dispatchResponse = (DispatchResponse)response;
                        chooseWhenParameters.putValue(ChooseWhenParameters.dispatch, (Object)RuleToParamsConverter.toDispatchParameters(dispatchResponse.getDispatchRule()));
                        continue;
                    }
                    if (response.getResponseType() == ResponseType.FORWARD) {
                        ForwardResponse forwardResponse = (ForwardResponse)response;
                        chooseWhenParameters.putValue(ChooseWhenParameters.forward, (Object)RuleToParamsConverter.toForwardParameters(forwardResponse.getForwardRule()));
                        continue;
                    }
                    if (response.getResponseType() != ResponseType.REDIRECT) continue;
                    RedirectResponse redirectResponse = (RedirectResponse)response;
                    chooseWhenParameters.putValue(ChooseWhenParameters.redirect, (Object)RuleToParamsConverter.toRedirectParameters(redirectResponse.getRedirectRule()));
                }
            }
        }
        if ((contentList = transletRule.getContentList()) != null) {
            if (contentList.isExplicit()) {
                ContentsParameters contentsParameters = (ContentsParameters)transletParameters.newParameters(TransletParameters.contents);
                contentsParameters.putValueNonNull(ContentsParameters.name, (Object)contentList.getName());
                for (ActionList actionList : contentList) {
                    ContentParameters contentParameters = (ContentParameters)contentsParameters.newParameters(ContentsParameters.content);
                    contentParameters.putValueNonNull(ContentParameters.name, (Object)actionList.getName());
                    RuleToParamsConverter.applyActionParameters(actionList, contentParameters, ContentParameters.action);
                }
            } else {
                for (Object actionList : contentList) {
                    if (((ActionList)actionList).isExplicit()) {
                        ContentParameters contentParameters = (ContentParameters)transletParameters.newParameters(TransletParameters.content);
                        contentParameters.putValueNonNull(ContentParameters.name, (Object)((ActionList)actionList).getName());
                        RuleToParamsConverter.applyActionParameters((ActionList)actionList, contentParameters, ContentParameters.action);
                        continue;
                    }
                    RuleToParamsConverter.applyActionParameters((ActionList)actionList, transletParameters, TransletParameters.action);
                }
            }
        }
        if ((responseRuleList = transletRule.getResponseRuleList()) != null) {
            for (ResponseRule responseRule : responseRuleList) {
                if (responseRule == null) continue;
                transletParameters.putValue(TransletParameters.response, (Object)RuleToParamsConverter.toResponseParameters(responseRule));
            }
        } else {
            ResponseRule responseRule = transletRule.getResponseRule();
            if (responseRule != null) {
                if (responseRule.isExplicit()) {
                    transletParameters.putValue(TransletParameters.response, (Object)RuleToParamsConverter.toResponseParameters(responseRule));
                } else {
                    Response response = responseRule.getResponse();
                    if (response != null) {
                        if (response.getResponseType() == ResponseType.TRANSFORM) {
                            TransformResponse transformResponse = (TransformResponse)response;
                            transletParameters.putValue(TransletParameters.transform, (Object)RuleToParamsConverter.toTransformParameters(transformResponse.getTransformRule()));
                        } else if (response.getResponseType() == ResponseType.DISPATCH) {
                            DispatchResponse dispatchResponse = (DispatchResponse)response;
                            transletParameters.putValue(TransletParameters.dispatch, (Object)RuleToParamsConverter.toDispatchParameters(dispatchResponse.getDispatchRule()));
                        } else if (response.getResponseType() == ResponseType.FORWARD) {
                            ForwardResponse forwardResponse = (ForwardResponse)response;
                            transletParameters.putValue(TransletParameters.forward, (Object)RuleToParamsConverter.toForwardParameters(forwardResponse.getForwardRule()));
                        } else if (response.getResponseType() == ResponseType.REDIRECT) {
                            RedirectResponse redirectResponse = (RedirectResponse)response;
                            transletParameters.putValue(TransletParameters.redirect, (Object)RuleToParamsConverter.toRedirectParameters(redirectResponse.getRedirectRule()));
                        }
                    }
                }
            }
        }
        if ((exceptionRule = transletRule.getExceptionRule()) != null) {
            ExceptionParameters exceptionParameters = (ExceptionParameters)transletParameters.touchParameters(TransletParameters.exception);
            exceptionParameters.putValueNonNull(ExceptionParameters.description, (Object)exceptionRule.getDescription());
            for (ExceptionThrownRule etr : exceptionRule.getExceptionThrownRuleList()) {
                exceptionParameters.putValue(ExceptionParameters.thrown, (Object)RuleToParamsConverter.toExceptionThrownParameters(etr));
            }
        }
        return transletParameters;
    }

    public static ExceptionThrownParameters toExceptionThrownParameters(ExceptionThrownRule exceptionThrownRule) {
        if (exceptionThrownRule == null) {
            throw new IllegalArgumentException("exceptionThrownRule must not be null");
        }
        ExceptionThrownParameters etParameters = new ExceptionThrownParameters();
        if (exceptionThrownRule.getExceptionTypes() != null) {
            for (String exceptionType : exceptionThrownRule.getExceptionTypes()) {
                etParameters.putValue(ExceptionThrownParameters.type, (Object)exceptionType);
            }
        }
        if (exceptionThrownRule.getActionType() == ActionType.BEAN_METHOD) {
            BeanMethodActionRule beanMethodActionRule = (BeanMethodActionRule)exceptionThrownRule.getAction().getActionRule();
            etParameters.putValue(ExceptionThrownParameters.action, (Object)RuleToParamsConverter.toActionParameters(beanMethodActionRule));
        } else if (exceptionThrownRule.getActionType() == ActionType.ECHO) {
            EchoActionRule echoActionRule = (EchoActionRule)exceptionThrownRule.getAction().getActionRule();
            etParameters.putValue(ExceptionThrownParameters.action, (Object)RuleToParamsConverter.toActionParameters(echoActionRule));
        } else if (exceptionThrownRule.getActionType() == ActionType.HEADER) {
            HeaderActionRule headerActionRule = (HeaderActionRule)exceptionThrownRule.getAction().getActionRule();
            etParameters.putValue(ExceptionThrownParameters.action, (Object)RuleToParamsConverter.toActionParameters(headerActionRule));
        }
        ResponseMap responseMap = exceptionThrownRule.getResponseMap();
        for (Response response : responseMap) {
            if (response.getResponseType() == ResponseType.TRANSFORM) {
                TransformResponse transformResponse = (TransformResponse)response;
                etParameters.putValue(ExceptionThrownParameters.transform, (Object)RuleToParamsConverter.toTransformParameters(transformResponse.getTransformRule()));
                continue;
            }
            if (response.getResponseType() == ResponseType.DISPATCH) {
                DispatchResponse dispatchResponse = (DispatchResponse)response;
                etParameters.putValue(ExceptionThrownParameters.dispatch, (Object)RuleToParamsConverter.toDispatchParameters(dispatchResponse.getDispatchRule()));
                continue;
            }
            if (response.getResponseType() == ResponseType.REDIRECT) {
                RedirectResponse redirectResponse = (RedirectResponse)response;
                etParameters.putValue(ExceptionThrownParameters.redirect, (Object)RuleToParamsConverter.toRedirectParameters(redirectResponse.getRedirectRule()));
                continue;
            }
            if (response.getResponseType() != ResponseType.FORWARD) continue;
            throw new IllegalArgumentException("Cannot apply the forward response rule to the exception thrown rule");
        }
        return etParameters;
    }

    public static ResponseParameters toResponseParameters(ResponseRule responseRule) {
        if (responseRule == null) {
            throw new IllegalArgumentException("responseRule must not be null");
        }
        ResponseParameters responseParameters = new ResponseParameters();
        responseParameters.putValueNonNull(ResponseParameters.name, (Object)responseRule.getName());
        responseParameters.putValueNonNull(ResponseParameters.encoding, (Object)responseRule.getEncoding());
        if (responseRule.getResponse() != null) {
            if (responseRule.getResponseType() == ResponseType.TRANSFORM) {
                TransformResponse transformResponse = (TransformResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.transform, (Object)RuleToParamsConverter.toTransformParameters(transformResponse.getTransformRule()));
            } else if (responseRule.getResponseType() == ResponseType.DISPATCH) {
                DispatchResponse dispatchResponse = (DispatchResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.dispatch, (Object)RuleToParamsConverter.toDispatchParameters(dispatchResponse.getDispatchRule()));
            } else if (responseRule.getResponseType() == ResponseType.FORWARD) {
                ForwardResponse forwardResponse = (ForwardResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.forward, (Object)RuleToParamsConverter.toForwardParameters(forwardResponse.getForwardRule()));
            } else if (responseRule.getResponseType() == ResponseType.REDIRECT) {
                RedirectResponse redirectResponse = (RedirectResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.redirect, (Object)RuleToParamsConverter.toRedirectParameters(redirectResponse.getRedirectRule()));
            }
        }
        return responseParameters;
    }

    public static TransformParameters toTransformParameters(TransformRule transformRule) {
        if (transformRule == null) {
            throw new IllegalArgumentException("transformRule must not be null");
        }
        TransformParameters transformParameters = new TransformParameters();
        if (transformRule.getTransformType() != null) {
            transformParameters.putValue(TransformParameters.type, (Object)transformRule.getTransformType().toString());
        }
        transformParameters.putValueNonNull(TransformParameters.contentType, (Object)transformRule.getContentType());
        transformParameters.putValueNonNull(TransformParameters.encoding, (Object)transformRule.getEncoding());
        transformParameters.putValueNonNull(TransformParameters.defaultResponse, (Object)transformRule.getDefaultResponse());
        transformParameters.putValueNonNull(TransformParameters.pretty, (Object)transformRule.getPretty());
        ActionList actionList = transformRule.getActionList();
        if (actionList != null) {
            RuleToParamsConverter.applyActionParameters(actionList, transformParameters, TransformParameters.action);
        }
        if (transformRule.getTemplateId() != null) {
            CallParameters callParameters = (CallParameters)transformParameters.newParameters(TransformParameters.call);
            callParameters.putValue(CallParameters.template, (Object)transformRule.getTemplateId());
            transformParameters.putValue(TransformParameters.call, (Object)callParameters);
        }
        if (transformRule.getTemplateRule() != null) {
            transformParameters.putValue(TransformParameters.template, (Object)RuleToParamsConverter.toTemplateParameters(transformRule.getTemplateRule()));
        }
        return transformParameters;
    }

    public static DispatchParameters toDispatchParameters(DispatchRule dispatchRule) {
        if (dispatchRule == null) {
            throw new IllegalArgumentException("dispatchRule must not be null");
        }
        DispatchParameters dispatchParameters = new DispatchParameters();
        dispatchParameters.putValueNonNull(DispatchParameters.name, (Object)dispatchRule.getName());
        dispatchParameters.putValueNonNull(DispatchParameters.dispatcher, (Object)dispatchRule.getDispatcherName());
        dispatchParameters.putValueNonNull(DispatchParameters.contentType, (Object)dispatchRule.getContentType());
        dispatchParameters.putValueNonNull(DispatchParameters.encoding, (Object)dispatchRule.getEncoding());
        dispatchParameters.putValueNonNull(DispatchParameters.defaultResponse, (Object)dispatchRule.getDefaultResponse());
        ActionList actionList = dispatchRule.getActionList();
        if (actionList != null) {
            RuleToParamsConverter.applyActionParameters(actionList, dispatchParameters, DispatchParameters.action);
        }
        return dispatchParameters;
    }

    public static ForwardParameters toForwardParameters(ForwardRule forwardRule) {
        ActionList actionList;
        if (forwardRule == null) {
            throw new IllegalArgumentException("forwardRule must not be null");
        }
        ForwardParameters forwardParameters = new ForwardParameters();
        forwardParameters.putValueNonNull(ForwardParameters.contentType, (Object)forwardRule.getContentType());
        forwardParameters.putValueNonNull(ForwardParameters.translet, (Object)forwardRule.getTransletName());
        forwardParameters.putValueNonNull(ForwardParameters.defaultResponse, (Object)forwardRule.getDefaultResponse());
        ItemRuleMap attributeItemRuleMap = forwardRule.getAttributeItemRuleMap();
        if (attributeItemRuleMap != null) {
            RuleToParamsConverter.toItemHolderParameters(attributeItemRuleMap, forwardParameters, ForwardParameters.attributes);
        }
        if ((actionList = forwardRule.getActionList()) != null) {
            RuleToParamsConverter.applyActionParameters(actionList, forwardParameters, ForwardParameters.action);
        }
        return forwardParameters;
    }

    public static RedirectParameters toRedirectParameters(RedirectRule redirectRule) {
        ActionList actionList;
        if (redirectRule == null) {
            throw new IllegalArgumentException("redirectRule must not be null");
        }
        RedirectParameters redirectParameters = new RedirectParameters();
        redirectParameters.putValueNonNull(RedirectParameters.contentType, (Object)redirectRule.getContentType());
        redirectParameters.putValueNonNull(RedirectParameters.path, (Object)redirectRule.getPath());
        redirectParameters.putValueNonNull(RedirectParameters.encoding, (Object)redirectRule.getEncoding());
        redirectParameters.putValueNonNull(RedirectParameters.excludeNullParameters, (Object)redirectRule.getExcludeNullParameters());
        redirectParameters.putValueNonNull(RedirectParameters.excludeEmptyParameters, (Object)redirectRule.getExcludeEmptyParameters());
        redirectParameters.putValueNonNull(RedirectParameters.defaultResponse, (Object)redirectRule.getDefaultResponse());
        ItemRuleMap parameterItemRuleMap = redirectRule.getParameterItemRuleMap();
        if (parameterItemRuleMap != null) {
            RuleToParamsConverter.toItemHolderParameters(parameterItemRuleMap, redirectParameters, RedirectParameters.parameters);
        }
        if ((actionList = redirectRule.getActionList()) != null) {
            RuleToParamsConverter.applyActionParameters(actionList, redirectParameters, RedirectParameters.action);
        }
        return redirectParameters;
    }

    public static TemplateParameters toTemplateParameters(TemplateRule templateRule) {
        if (templateRule == null) {
            throw new IllegalArgumentException("templateRule must not be null");
        }
        TemplateParameters templateParameters = new TemplateParameters();
        templateParameters.putValueNonNull(TemplateParameters.id, (Object)templateRule.getId());
        templateParameters.putValueNonNull(TemplateParameters.engine, (Object)templateRule.getEngine());
        if (templateRule.getFile() != null) {
            templateParameters.putValueNonNull(TemplateParameters.file, (Object)templateRule.getFile());
        } else if (templateRule.getResource() != null) {
            templateParameters.putValueNonNull(TemplateParameters.resource, (Object)templateRule.getResource());
        } else if (templateRule.getUrl() != null) {
            templateParameters.putValueNonNull(TemplateParameters.url, (Object)templateRule.getUrl());
        } else if (templateRule.getName() != null) {
            templateParameters.putValueNonNull(TemplateParameters.name, (Object)templateRule.getName());
        } else if (templateRule.getContent() != null) {
            TextStyleType textStyleType = templateRule.getContentStyle();
            if (textStyleType == TextStyleType.APON) {
                String content = TextStyler.styling(templateRule.getContent(), textStyleType);
                templateParameters.putValue(TemplateParameters.content, (Object)content);
            } else {
                templateParameters.putValue(TemplateParameters.content, (Object)templateRule.getContent());
                templateParameters.putValueNonNull(TemplateParameters.style, (Object)textStyleType);
            }
        } else {
            templateParameters.putValueNonNull(TemplateParameters.content, (Object)templateRule.getTemplateSource());
            templateParameters.putValueNonNull(TemplateParameters.style, (Object)templateRule.getContentStyle());
        }
        templateParameters.putValueNonNull(TemplateParameters.encoding, (Object)templateRule.getEncoding());
        templateParameters.putValueNonNull(TemplateParameters.noCache, (Object)templateRule.getNoCache());
        return templateParameters;
    }

    private static void applyActionParameters(ActionList actionList, Parameters parameters, ParameterDefinition actionParam) {
        for (Executable action : actionList) {
            ActionParameters actionParameters = null;
            if (action.getActionType() == ActionType.BEAN_METHOD) {
                BeanMethodActionRule beanMethodActionRule = (BeanMethodActionRule)action.getActionRule();
                actionParameters = RuleToParamsConverter.toActionParameters(beanMethodActionRule);
            } else if (action.getActionType() == ActionType.ANNOTATED_METHOD) {
                AnnotatedMethodActionRule annotatedMethodActionRule = (AnnotatedMethodActionRule)action.getActionRule();
                actionParameters = RuleToParamsConverter.toActionParameters(annotatedMethodActionRule);
            } else if (action.getActionType() == ActionType.INCLUDE) {
                IncludeActionRule includeActionRule = (IncludeActionRule)action.getActionRule();
                actionParameters = RuleToParamsConverter.toActionParameters(includeActionRule);
            } else if (action.getActionType() == ActionType.ECHO) {
                EchoActionRule echoActionRule = (EchoActionRule)action.getActionRule();
                actionParameters = RuleToParamsConverter.toActionParameters(echoActionRule);
            } else if (action.getActionType() == ActionType.HEADER) {
                HeaderActionRule headerActionRule = (HeaderActionRule)action.getActionRule();
                actionParameters = RuleToParamsConverter.toActionParameters(headerActionRule);
            }
            if (actionParameters == null) continue;
            if (action.getCaseNo() > 0) {
                actionParameters.putValue(ActionParameters.caseNo, (Object)action.getCaseNo());
            }
            parameters.putValue(actionParam, (Object)actionParameters);
        }
    }

    private static void applyAdviceActionParameters(AspectAdviceRule aspectAdviceRule, AdviceActionParameters adviceActionParameters) {
        if (aspectAdviceRule.getActionType() == ActionType.BEAN_METHOD) {
            BeanMethodActionRule beanMethodActionRule = (BeanMethodActionRule)aspectAdviceRule.getExecutableAction().getActionRule();
            adviceActionParameters.putValue(AdviceActionParameters.action, (Object)RuleToParamsConverter.toActionParameters(beanMethodActionRule));
        } else if (aspectAdviceRule.getActionType() == ActionType.ANNOTATED_METHOD) {
            AnnotatedMethodActionRule annotatedMethodActionRule = (AnnotatedMethodActionRule)aspectAdviceRule.getExecutableAction().getActionRule();
            adviceActionParameters.putValue(AdviceActionParameters.action, (Object)RuleToParamsConverter.toActionParameters(annotatedMethodActionRule));
        } else if (aspectAdviceRule.getActionType() == ActionType.ECHO) {
            EchoActionRule echoActionRule = (EchoActionRule)aspectAdviceRule.getExecutableAction().getActionRule();
            adviceActionParameters.putValue(AdviceActionParameters.action, (Object)RuleToParamsConverter.toActionParameters(echoActionRule));
        } else if (aspectAdviceRule.getActionType() == ActionType.HEADER) {
            HeaderActionRule headerActionRule = (HeaderActionRule)aspectAdviceRule.getExecutableAction().getActionRule();
            adviceActionParameters.putValue(AdviceActionParameters.action, (Object)RuleToParamsConverter.toActionParameters(headerActionRule));
        }
    }

    public static ActionParameters toActionParameters(BeanMethodActionRule beanMethodActionRule) {
        ItemRuleMap argumentItemRuleMap;
        if (beanMethodActionRule == null) {
            throw new IllegalArgumentException("beanMethodActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueNonNull(ActionParameters.id, (Object)beanMethodActionRule.getActionId());
        actionParameters.putValueNonNull(ActionParameters.bean, (Object)beanMethodActionRule.getBeanId());
        actionParameters.putValueNonNull(ActionParameters.method, (Object)beanMethodActionRule.getMethodName());
        actionParameters.putValueNonNull(ActionParameters.hidden, (Object)beanMethodActionRule.getHidden());
        ItemRuleMap propertyItemRuleMap = beanMethodActionRule.getPropertyItemRuleMap();
        if (propertyItemRuleMap != null) {
            RuleToParamsConverter.toItemHolderParameters(propertyItemRuleMap, actionParameters, ActionParameters.properties);
        }
        if ((argumentItemRuleMap = beanMethodActionRule.getArgumentItemRuleMap()) != null) {
            RuleToParamsConverter.toItemHolderParameters(argumentItemRuleMap, actionParameters, ActionParameters.arguments);
        }
        return actionParameters;
    }

    public static ActionParameters toActionParameters(AnnotatedMethodActionRule annotatedMethodActionRule) {
        if (annotatedMethodActionRule == null) {
            throw new IllegalArgumentException("annotatedMethodActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueNonNull(ActionParameters.id, (Object)annotatedMethodActionRule.getActionId());
        actionParameters.putValueNonNull(ActionParameters.bean, (Object)annotatedMethodActionRule.getBeanClass().toString());
        actionParameters.putValueNonNull(ActionParameters.method, (Object)annotatedMethodActionRule.getMethod().toString());
        return actionParameters;
    }

    public static ActionParameters toActionParameters(IncludeActionRule includeActionRule) {
        ItemRuleMap attributeItemRuleMap;
        if (includeActionRule == null) {
            throw new IllegalArgumentException("includeActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueNonNull(ActionParameters.id, (Object)includeActionRule.getActionId());
        actionParameters.putValueNonNull(ActionParameters.include, (Object)includeActionRule.getTransletName());
        actionParameters.putValueNonNull(ActionParameters.method, (Object)includeActionRule.getMethodType());
        actionParameters.putValueNonNull(ActionParameters.hidden, (Object)includeActionRule.getHidden());
        ItemRuleMap parameterItemRuleMap = includeActionRule.getParameterItemRuleMap();
        if (parameterItemRuleMap != null) {
            RuleToParamsConverter.toItemHolderParameters(parameterItemRuleMap, actionParameters, ActionParameters.parameters);
        }
        if ((attributeItemRuleMap = includeActionRule.getAttributeItemRuleMap()) != null) {
            RuleToParamsConverter.toItemHolderParameters(attributeItemRuleMap, actionParameters, ActionParameters.attributes);
        }
        return actionParameters;
    }

    public static ActionParameters toActionParameters(EchoActionRule echoActionRule) {
        if (echoActionRule == null) {
            throw new IllegalArgumentException("echoActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueNonNull(ActionParameters.id, (Object)echoActionRule.getActionId());
        actionParameters.putValueNonNull(ActionParameters.hidden, (Object)echoActionRule.getHidden());
        ItemRuleMap attributeItemRuleMap = echoActionRule.getAttributeItemRuleMap();
        if (attributeItemRuleMap != null) {
            actionParameters.putValue(ActionParameters.echo, (Object)RuleToParamsConverter.toItemHolderParameters(attributeItemRuleMap));
        }
        return actionParameters;
    }

    public static ActionParameters toActionParameters(HeaderActionRule headerActionRule) {
        if (headerActionRule == null) {
            throw new IllegalArgumentException("headerActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueNonNull(ActionParameters.id, (Object)headerActionRule.getActionId());
        actionParameters.putValueNonNull(ActionParameters.hidden, (Object)headerActionRule.getHidden());
        ItemRuleMap headerItemRuleMap = headerActionRule.getHeaderItemRuleMap();
        if (headerItemRuleMap != null) {
            actionParameters.putValue(ActionParameters.headers, (Object)RuleToParamsConverter.toItemHolderParameters(headerItemRuleMap));
        }
        return actionParameters;
    }

    public static ItemHolderParameters toItemHolderParameters(ItemRuleMap itemRuleMap) {
        if (itemRuleMap == null) {
            throw new IllegalArgumentException("itemRuleMap must not be null");
        }
        ItemHolderParameters itemHolderParameters = new ItemHolderParameters();
        if (itemRuleMap.getProfile() != null) {
            itemHolderParameters.putValue(ItemHolderParameters.profile, (Object)itemRuleMap.getProfile());
        }
        for (ItemRule itemRule : itemRuleMap.values()) {
            itemHolderParameters.putValue(ItemHolderParameters.item, (Object)RuleToParamsConverter.toItemParameters(itemRule));
        }
        return itemHolderParameters;
    }

    private static void toItemHolderParameters(ItemRuleMap itemRuleMap, Parameters parameters, ParameterDefinition parameterDefinition) {
        if (itemRuleMap.getCandidates() != null) {
            for (ItemRuleMap irm : itemRuleMap.getCandidates()) {
                parameters.putValue(parameterDefinition, (Object)RuleToParamsConverter.toItemHolderParameters(irm));
            }
        } else {
            parameters.putValue(parameterDefinition, (Object)RuleToParamsConverter.toItemHolderParameters(itemRuleMap));
        }
    }

    public static ItemParameters toItemParameters(ItemRule itemRule) {
        ItemParameters itemParameters;
        block8: {
            Map<String, String> valueMap;
            block9: {
                block7: {
                    if (itemRule == null) {
                        throw new IllegalArgumentException("itemRule must not be null");
                    }
                    itemParameters = new ItemParameters();
                    if (itemRule.getType() != null && itemRule.getType() != ItemType.SINGLE) {
                        itemParameters.putValue(ItemParameters.type, (Object)itemRule.getType().toString());
                    }
                    if (!itemRule.isAutoNamed()) {
                        itemParameters.putValue(ItemParameters.name, (Object)itemRule.getName());
                    }
                    if (itemRule.getValueType() != null) {
                        itemParameters.putValue(ItemParameters.valueType, (Object)itemRule.getValueType().toString());
                    }
                    itemParameters.putValueNonNull(ItemParameters.defaultValue, (Object)itemRule.getDefaultValue());
                    itemParameters.putValueNonNull(ItemParameters.tokenize, (Object)itemRule.getTokenize());
                    itemParameters.putValueNonNull(ItemParameters.mandatory, (Object)itemRule.getMandatory());
                    itemParameters.putValueNonNull(ItemParameters.secret, (Object)itemRule.getSecret());
                    if (itemRule.getType() != ItemType.SINGLE) break block7;
                    Object o = RuleToParamsConverter.determineItemValue(itemRule.getValueType(), itemRule.getValue());
                    itemParameters.putValueNonNull(ItemParameters.value, o);
                    break block8;
                }
                if (!itemRule.isListableType()) break block9;
                List<String> valueList = itemRule.getValueList();
                if (valueList == null || valueList.isEmpty()) break block8;
                Parameter p = itemParameters.getParameter(ItemParameters.value);
                p.arraylize();
                for (String value : valueList) {
                    Object o = RuleToParamsConverter.determineItemValue(itemRule.getValueType(), value);
                    p.putValue(o);
                }
                break block8;
            }
            if (itemRule.isMappableType() && (valueMap = itemRule.getValueMap()) != null) {
                Object p = itemParameters.newParameters(ItemParameters.value);
                for (Map.Entry<String, String> entry : valueMap.entrySet()) {
                    Object o = RuleToParamsConverter.determineItemValue(itemRule.getValueType(), entry.getValue());
                    p.putValue(entry.getKey(), o);
                }
            }
        }
        return itemParameters;
    }

    private static Object determineItemValue(ItemValueType valueType, String value) {
        if (value == null) {
            return null;
        }
        if (valueType == ItemValueType.PARAMETERS) {
            try {
                return new VariableParameters(value);
            }
            catch (AponParseException e) {
                throw new RuntimeException("Parameters can not be parsed", e);
            }
        }
        return value;
    }
}

